/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.aspect;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.CacheType;
import org.apache.dolphinscheduler.remote.command.CacheExpireCommand;
import org.apache.dolphinscheduler.service.cache.CacheNotifyService;
import org.apache.dolphinscheduler.service.cache.impl.CacheKeyGenerator;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CacheEvictAspect {
    private static final Logger logger = LoggerFactory.getLogger(CacheEvictAspect.class);
    private static final String EL_SYMBOL = "#";
    private static final String P = "p";
    @Autowired
    private CacheKeyGenerator cacheKeyGenerator;
    @Autowired
    private CacheNotifyService cacheNotifyService;

    @Pointcut(value="@annotation(org.springframework.cache.annotation.CacheEvict)")
    public void cacheEvictPointCut() {
    }

    @Around(value="cacheEvictPointCut()")
    public Object doAround(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        CacheEvict cacheEvict;
        MethodSignature sign = (MethodSignature)proceedingJoinPoint.getSignature();
        Method method = sign.getMethod();
        Object target = proceedingJoinPoint.getTarget();
        Object[] args = proceedingJoinPoint.getArgs();
        Object result = proceedingJoinPoint.proceed();
        CacheConfig cacheConfig = method.getDeclaringClass().getAnnotation(CacheConfig.class);
        CacheType cacheType = this.getCacheType(cacheConfig, cacheEvict = method.getAnnotation(CacheEvict.class));
        if (cacheType != null) {
            String cacheKey;
            if (cacheEvict.key().isEmpty()) {
                cacheKey = (String)this.cacheKeyGenerator.generate(target, method, args);
            } else {
                cacheKey = cacheEvict.key();
                if (cacheEvict.key().contains(EL_SYMBOL)) {
                    cacheKey = this.parseKey(cacheEvict.key(), Arrays.asList(args));
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)cacheKey)) {
                this.cacheNotifyService.notifyMaster(new CacheExpireCommand(cacheType, cacheKey).convert2Command());
            }
        }
        return result;
    }

    private CacheType getCacheType(CacheConfig cacheConfig, CacheEvict cacheEvict) {
        String cacheName = null;
        if (cacheEvict.cacheNames().length > 0) {
            cacheName = cacheEvict.cacheNames()[0];
        }
        if (cacheConfig.cacheNames().length > 0) {
            cacheName = cacheConfig.cacheNames()[0];
        }
        if (cacheName == null) {
            return null;
        }
        for (CacheType cacheType : CacheType.values()) {
            if (!cacheType.getCacheName().equals(cacheName)) continue;
            return cacheType;
        }
        return null;
    }

    private String parseKey(String key, List<Object> paramList) {
        SpelExpressionParser spelParser = new SpelExpressionParser();
        StandardEvaluationContext ctx = new StandardEvaluationContext();
        for (int i = 0; i < paramList.size(); ++i) {
            ctx.setVariable(P + i, paramList.get(i));
        }
        Object obj = spelParser.parseExpression(key).getValue((EvaluationContext)ctx);
        if (null == obj) {
            throw new RuntimeException("parseKey error");
        }
        return obj.toString();
    }
}

