/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.DataSourceService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.service.utils.CommonUtils;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"DATA_SOURCE_TAG"})
@RestController
@RequestMapping(value={"datasources"})
public class DataSourceController
extends BaseController {
    @Autowired
    private DataSourceService dataSourceService;

    @ApiOperation(value="createDataSource", notes="CREATE_DATA_SOURCE_NOTES")
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_DATASOURCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createDataSource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="dataSourceParam", value="DATA_SOURCE_PARAM", required=true) @RequestBody String jsonStr) {
        BaseDataSourceParamDTO dataSourceParam = DataSourceUtils.buildDatasourceParam((String)jsonStr);
        return this.dataSourceService.createDataSource(loginUser, dataSourceParam);
    }

    @ApiOperation(value="updateDataSource", notes="UPDATE_DATA_SOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="DATA_SOURCE_ID", required=true, dataTypeClass=int.class), @ApiImplicitParam(name="dataSourceParam", value="DATA_SOURCE_PARAM", required=true, dataTypeClass=BaseDataSourceParamDTO.class)})
    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_DATASOURCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateDataSource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") Integer id, @RequestBody String jsonStr) {
        BaseDataSourceParamDTO dataSourceParam = DataSourceUtils.buildDatasourceParam((String)jsonStr);
        dataSourceParam.setId(id);
        return this.dataSourceService.updateDataSource(dataSourceParam.getId(), loginUser, dataSourceParam);
    }

    @ApiOperation(value="queryDataSource", notes="QUERY_DATA_SOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="DATA_SOURCE_ID", required=true, dataTypeClass=int.class, example="100")})
    @GetMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DATASOURCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryDataSource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id) {
        Map<String, Object> result = this.dataSourceService.queryDataSource(id);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryDataSourceList", notes="QUERY_DATA_SOURCE_LIST_BY_TYPE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="DB_TYPE", required=true, dataType="DbType")})
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DATASOURCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryDataSourceList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") DbType type) {
        Map<String, Object> result = this.dataSourceService.queryDataSourceList(loginUser, type.ordinal());
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryDataSourceListPaging", notes="QUERY_DATA_SOURCE_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataTypeClass=String.class), @ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataTypeClass=int.class, example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataTypeClass=int.class, example="20")})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DATASOURCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryDataSourceListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        return this.dataSourceService.queryDataSourceListPaging(loginUser, searchVal, pageNo, pageSize);
    }

    @ApiOperation(value="connectDataSource", notes="CONNECT_DATA_SOURCE_NOTES")
    @PostMapping(value={"/connect"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.CONNECT_DATASOURCE_FAILURE)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result connectDataSource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @io.swagger.v3.oas.annotations.parameters.RequestBody(description="dataSourceParam") @RequestBody String jsonStr) {
        BaseDataSourceParamDTO dataSourceParam = DataSourceUtils.buildDatasourceParam((String)jsonStr);
        DataSourceUtils.checkDatasourceParam((BaseDataSourceParamDTO)dataSourceParam);
        ConnectionParam connectionParams = DataSourceUtils.buildConnectionParams((BaseDataSourceParamDTO)dataSourceParam);
        return this.dataSourceService.checkConnection(dataSourceParam.getType(), connectionParams);
    }

    @ApiOperation(value="connectionTest", notes="CONNECT_DATA_SOURCE_TEST_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="DATA_SOURCE_ID", required=true, dataTypeClass=int.class, example="100")})
    @GetMapping(value={"/{id}/connect-test"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.CONNECTION_TEST_FAILURE)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result connectionTest(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id) {
        return this.dataSourceService.connectionTest(id);
    }

    @ApiOperation(value="deleteDataSource", notes="DELETE_DATA_SOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="DATA_SOURCE_ID", required=true, dataTypeClass=int.class, example="100")})
    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_DATA_SOURCE_FAILURE)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteDataSource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id) {
        return this.dataSourceService.delete(loginUser, id);
    }

    @ApiOperation(value="verifyDataSourceName", notes="VERIFY_DATA_SOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="DATA_SOURCE_NAME", required=true, dataTypeClass=String.class)})
    @GetMapping(value={"/verify-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_DATASOURCE_NAME_FAILURE)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result verifyDataSourceName(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="name") String name) {
        return this.dataSourceService.verifyDataSourceName(name);
    }

    @ApiOperation(value="unauthDatasource", notes="UNAUTHORIZED_DATA_SOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", required=true, dataTypeClass=int.class, example="100")})
    @GetMapping(value={"/unauth-datasource"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UNAUTHORIZED_DATASOURCE)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result unauthDatasource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        Map<String, Object> result = this.dataSourceService.unauthDatasource(loginUser, userId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="authedDatasource", notes="AUTHORIZED_DATA_SOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", required=true, dataTypeClass=int.class, example="100")})
    @GetMapping(value={"/authed-datasource"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.AUTHORIZED_DATA_SOURCE)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result authedDatasource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        Map<String, Object> result = this.dataSourceService.authedDatasource(loginUser, userId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="getKerberosStartupState", notes="GET_USER_INFO_NOTES")
    @GetMapping(value={"/kerberos-startup-state"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.KERBEROS_STARTUP_STATE)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result getKerberosStartupState(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        return this.success(Status.SUCCESS.getMsg(), CommonUtils.getKerberosStartupState());
    }

    @ApiOperation(value="tables", notes="GET_DATASOURCE_TABLES_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="datasourceId", value="DATA_SOURCE_ID", required=true, dataTypeClass=int.class, example="1")})
    @GetMapping(value={"/tables"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GET_DATASOURCE_TABLES_ERROR)
    public Result getTables(@RequestParam(value="datasourceId") Integer datasourceId) {
        Map<String, Object> result = this.dataSourceService.getTables(datasourceId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="tableColumns", notes="GET_DATASOURCE_TABLE_COLUMNS_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="datasourceId", value="DATA_SOURCE_ID", required=true, dataTypeClass=int.class, example="1"), @ApiImplicitParam(name="tableName", value="TABLE_NAME", required=true, dataTypeClass=String.class, example="test")})
    @GetMapping(value={"/tableColumns"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GET_DATASOURCE_TABLE_COLUMNS_ERROR)
    public Result getTableColumns(@RequestParam(value="datasourceId") Integer datasourceId, @RequestParam(value="tableName") String tableName) {
        Map<String, Object> result = this.dataSourceService.getTableColumns(datasourceId, tableName);
        return this.returnDataList(result);
    }
}

