/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.TaskDefinitionService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.TaskExecuteType;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"TASK_DEFINITION_TAG"})
@RestController
@RequestMapping(value={"projects/{projectCode}/task-definition"})
public class TaskDefinitionController
extends BaseController {
    @Autowired
    private TaskDefinitionService taskDefinitionService;

    @ApiOperation(value="save", notes="CREATE_TASK_DEFINITION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectCode", value="PROJECT_CODE", required=true, dataTypeClass=long.class), @ApiImplicitParam(name="taskDefinitionJson", value="TASK_DEFINITION_JSON", required=true, dataTypeClass=String.class)})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_TASK_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createTaskDefinition(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="taskDefinitionJson", required=true) String taskDefinitionJson) {
        Map<String, Object> result = this.taskDefinitionService.createTaskDefinition(loginUser, projectCode, taskDefinitionJson);
        return this.returnDataList(result);
    }

    @ApiOperation(value="saveSingle", notes="CREATE_SINGLE_TASK_DEFINITION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectCode", value="PROJECT_CODE", required=true, dataTypeClass=long.class), @ApiImplicitParam(name="processDefinitionCode", value="PROCESS_DEFINITION_CODE", required=true, dataTypeClass=long.class), @ApiImplicitParam(name="taskDefinitionJsonObj", value="TASK_DEFINITION_JSON", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="upstreamCodes", value="UPSTREAM_CODES", required=false, dataTypeClass=String.class)})
    @PostMapping(value={"/save-single"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_TASK_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createTaskBindsWorkFlow(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="processDefinitionCode", required=true) long processDefinitionCode, @RequestParam(value="taskDefinitionJsonObj", required=true) String taskDefinitionJsonObj, @RequestParam(value="upstreamCodes", required=false) String upstreamCodes) {
        Map<String, Object> result = this.taskDefinitionService.createTaskBindsWorkFlow(loginUser, projectCode, processDefinitionCode, taskDefinitionJsonObj, StringUtils.defaultString((String)upstreamCodes));
        return this.returnDataList(result);
    }

    @ApiOperation(value="update", notes="UPDATE_TASK_DEFINITION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectCode", value="PROJECT_CODE", required=true, dataTypeClass=long.class), @ApiImplicitParam(name="code", value="TASK_DEFINITION_CODE", required=true, dataTypeClass=long.class, example="1"), @ApiImplicitParam(name="taskDefinitionJsonObj", value="TASK_DEFINITION_JSON", required=true, dataTypeClass=String.class)})
    @PutMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_TASK_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateTaskDefinition(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code, @RequestParam(value="taskDefinitionJsonObj", required=true) String taskDefinitionJsonObj) {
        Map<String, Object> result = this.taskDefinitionService.updateTaskDefinition(loginUser, projectCode, code, taskDefinitionJsonObj);
        return this.returnDataList(result);
    }

    @ApiOperation(value="updateWithUpstream", notes="UPDATE_TASK_DEFINITION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectCode", value="PROJECT_CODE", required=true, dataTypeClass=long.class), @ApiImplicitParam(name="code", value="TASK_DEFINITION_CODE", required=true, dataTypeClass=long.class, example="1"), @ApiImplicitParam(name="taskDefinitionJsonObj", value="TASK_DEFINITION_JSON", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="upstreamCodes", value="UPSTREAM_CODES", required=false, dataTypeClass=String.class)})
    @PutMapping(value={"/{code}/with-upstream"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_TASK_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateTaskWithUpstream(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code, @RequestParam(value="taskDefinitionJsonObj", required=true) String taskDefinitionJsonObj, @RequestParam(value="upstreamCodes", required=false) String upstreamCodes) {
        Map<String, Object> result = this.taskDefinitionService.updateTaskWithUpstream(loginUser, projectCode, code, taskDefinitionJsonObj, upstreamCodes);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryVersions", notes="QUERY_TASK_DEFINITION_VERSIONS_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="TASK_DEFINITION_CODE", required=true, dataTypeClass=long.class, example="1"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataTypeClass=int.class, example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataTypeClass=int.class, example="10")})
    @GetMapping(value={"/{code}/versions"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_DEFINITION_VERSIONS_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryTaskDefinitionVersions(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code, @RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        return this.taskDefinitionService.queryTaskDefinitionVersions(loginUser, projectCode, code, pageNo, pageSize);
    }

    @ApiOperation(value="switchVersion", notes="SWITCH_TASK_DEFINITION_VERSION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="TASK_DEFINITION_CODE", required=true, dataTypeClass=long.class, example="1"), @ApiImplicitParam(name="version", value="VERSION", required=true, dataTypeClass=int.class, example="100")})
    @GetMapping(value={"/{code}/versions/{version}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.SWITCH_TASK_DEFINITION_VERSION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result switchTaskDefinitionVersion(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code, @PathVariable(value="version") int version) {
        Map<String, Object> result = this.taskDefinitionService.switchVersion(loginUser, projectCode, code, version);
        return this.returnDataList(result);
    }

    @ApiOperation(value="deleteVersion", notes="DELETE_TASK_DEFINITION_VERSION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="TASK_DEFINITION_CODE", required=true, dataTypeClass=long.class, example="1"), @ApiImplicitParam(name="version", value="VERSION", required=true, dataTypeClass=int.class, example="100")})
    @DeleteMapping(value={"/{code}/versions/{version}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_TASK_DEFINITION_VERSION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteTaskDefinitionVersion(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code, @PathVariable(value="version") int version) {
        Map<String, Object> result = this.taskDefinitionService.deleteByCodeAndVersion(loginUser, projectCode, code, version);
        return this.returnDataList(result);
    }

    @ApiOperation(value="deleteTaskDefinition", notes="DELETE_TASK_DEFINITION_BY_CODE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="TASK_DEFINITION_CODE", required=true, dataTypeClass=long.class, example="1")})
    @DeleteMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_TASK_DEFINE_BY_CODE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteTaskDefinitionByCode(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code) {
        Map<String, Object> result = this.taskDefinitionService.deleteTaskDefinitionByCode(loginUser, projectCode, code);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryTaskDefinitionByCode", notes="QUERY_TASK_DEFINITION_DETAIL_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="TASK_DEFINITION_CODE", required=true, dataTypeClass=long.class, example="1")})
    @GetMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DETAIL_OF_TASK_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryTaskDefinitionDetail(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code) {
        Map<String, Object> result = this.taskDefinitionService.queryTaskDefinitionDetail(loginUser, projectCode, code);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryTaskDefinitionListPaging", notes="QUERY_TASK_DEFINITION_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectCode", value="PROJECT_CODE", required=false, dataTypeClass=long.class), @ApiImplicitParam(name="searchWorkflowName", value="SEARCH_WORKFLOW_NAME", required=false, dataTypeClass=String.class), @ApiImplicitParam(name="searchTaskName", value="SEARCH_TASK_NAME", required=false, dataTypeClass=String.class), @ApiImplicitParam(name="taskType", value="TASK_TYPE", required=false, dataTypeClass=String.class, example="SHELL"), @ApiImplicitParam(name="taskExecuteType", value="TASK_EXECUTE_TYPE", required=false, dataTypeClass=TaskExecuteType.class, example="STREAM"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataTypeClass=int.class, example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataTypeClass=int.class, example="10")})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_DEFINITION_LIST_PAGING_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryTaskDefinitionListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="searchWorkflowName", required=false) String searchWorkflowName, @RequestParam(value="searchTaskName", required=false) String searchTaskName, @RequestParam(value="taskType", required=false) String taskType, @RequestParam(value="taskExecuteType", required=false, defaultValue="BATCH") TaskExecuteType taskExecuteType, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchWorkflowName = ParameterUtils.handleEscapes((String)searchWorkflowName);
        searchTaskName = ParameterUtils.handleEscapes((String)searchTaskName);
        return this.taskDefinitionService.queryTaskDefinitionListPaging(loginUser, projectCode, searchWorkflowName, searchTaskName, taskType, taskExecuteType, pageNo, pageSize);
    }

    @ApiOperation(value="genTaskCodeList", notes="GEN_TASK_CODE_LIST_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="genNum", value="GEN_NUM", required=true, dataTypeClass=int.class, example="1")})
    @GetMapping(value={"/gen-task-codes"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LOGIN_USER_QUERY_PROJECT_LIST_PAGING_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result genTaskCodeList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="genNum") Integer genNum) {
        Map<String, Object> result = this.taskDefinitionService.genTaskCodeList(genNum);
        return this.returnDataList(result);
    }

    @ApiOperation(value="releaseTaskDefinition", notes="RELEASE_TASK_DEFINITION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectCode", value="PROCESS_DEFINITION_NAME", required=true, dataTypeClass=long.class), @ApiImplicitParam(name="code", value="TASK_DEFINITION_CODE", required=true, dataTypeClass=long.class, example="123456789"), @ApiImplicitParam(name="releaseState", value="RELEASE_PROCESS_DEFINITION_NOTES", required=true, dataTypeClass=ReleaseState.class)})
    @PostMapping(value={"/{code}/release"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.RELEASE_TASK_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result releaseTaskDefinition(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code", required=true) long code, @RequestParam(value="releaseState", required=true, defaultValue="OFFLINE") ReleaseState releaseState) {
        Map<String, Object> result = this.taskDefinitionService.releaseTaskDefinition(loginUser, projectCode, code, releaseState);
        return this.returnDataList(result);
    }
}

