/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.google.common.primitives.Bytes;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.LoggerService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.constants.Constants;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.ResponseTaskLog;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.service.log.LogClient;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoggerServiceImpl
extends BaseServiceImpl
implements LoggerService {
    private static final Logger logger = LoggerFactory.getLogger(LoggerServiceImpl.class);
    private static final String LOG_HEAD_FORMAT = "[LOG-PATH]: %s, [HOST]:  %s%s";
    @Autowired
    private ProcessService processService;
    @Autowired
    private LogClient logClient;
    @Autowired
    ProjectMapper projectMapper;
    @Autowired
    ProjectService projectService;
    @Autowired
    TaskDefinitionMapper taskDefinitionMapper;

    @Override
    public Result<ResponseTaskLog> queryLog(int taskInstId, int skipLineNum, int limit) {
        TaskInstance taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(taskInstId));
        if (taskInstance == null) {
            return Result.error(Status.TASK_INSTANCE_NOT_FOUND);
        }
        if (StringUtils.isBlank((CharSequence)taskInstance.getHost())) {
            return Result.error(Status.TASK_INSTANCE_HOST_IS_NULL);
        }
        Result<ResponseTaskLog> result = new Result<ResponseTaskLog>(Status.SUCCESS.getCode(), Status.SUCCESS.getMsg());
        String log = this.queryLog(taskInstance, skipLineNum, limit);
        int lineNum = log.split("\\r\\n").length;
        result.setData(new ResponseTaskLog(lineNum, log));
        return result;
    }

    @Override
    public byte[] getLogBytes(int taskInstId) {
        TaskInstance taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(taskInstId));
        if (taskInstance == null || StringUtils.isBlank((CharSequence)taskInstance.getHost())) {
            throw new ServiceException("task instance is null or host is null");
        }
        return this.getLogBytes(taskInstance);
    }

    @Override
    public Map<String, Object> queryLog(User loginUser, long projectCode, int taskInstId, int skipLineNum, int limit) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:log:detail");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        TaskInstance task = this.processService.findTaskInstanceById(Integer.valueOf(taskInstId));
        if (task == null || StringUtils.isBlank((CharSequence)task.getHost())) {
            this.putMsg(result, Status.TASK_INSTANCE_NOT_FOUND, new Object[0]);
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(task.getTaskCode());
        if (taskDefinition != null && projectCode != taskDefinition.getProjectCode()) {
            this.putMsg(result, Status.TASK_INSTANCE_NOT_FOUND, taskInstId);
            return result;
        }
        String log = this.queryLog(task, skipLineNum, limit);
        result.put("data", log);
        return result;
    }

    @Override
    public byte[] getLogBytes(User loginUser, long projectCode, int taskInstId) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:log:download-log");
        if (result.get("status") != Status.SUCCESS) {
            throw new ServiceException("user has no permission");
        }
        TaskInstance task = this.processService.findTaskInstanceById(Integer.valueOf(taskInstId));
        if (task == null || StringUtils.isBlank((CharSequence)task.getHost())) {
            throw new ServiceException("task instance is null or host is null");
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(task.getTaskCode());
        if (taskDefinition != null && projectCode != taskDefinition.getProjectCode()) {
            throw new ServiceException("task instance does not exist in project");
        }
        return this.getLogBytes(task);
    }

    private String queryLog(TaskInstance taskInstance, int skipLineNum, int limit) {
        Host host = Host.of((String)taskInstance.getHost());
        logger.info("log host : {} , logPath : {} , port : {}", new Object[]{host.getIp(), taskInstance.getLogPath(), host.getPort()});
        StringBuilder log = new StringBuilder();
        if (skipLineNum == 0) {
            String head = String.format(LOG_HEAD_FORMAT, taskInstance.getLogPath(), host, Constants.SYSTEM_LINE_SEPARATOR);
            log.append(head);
        }
        log.append(this.logClient.rollViewLog(host.getIp(), host.getPort(), taskInstance.getLogPath(), skipLineNum, limit));
        return log.toString();
    }

    private byte[] getLogBytes(TaskInstance taskInstance) {
        Host host = Host.of((String)taskInstance.getHost());
        byte[] head = String.format(LOG_HEAD_FORMAT, taskInstance.getLogPath(), host, Constants.SYSTEM_LINE_SEPARATOR).getBytes(StandardCharsets.UTF_8);
        return Bytes.concat((byte[][])new byte[][]{head, this.logClient.getLogBytes(host.getIp(), host.getPort(), taskInstance.getLogPath())});
    }
}

