/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.AccessTokenService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"ACCESS_TOKEN_TAG"})
@RestController
@RequestMapping(value={"/access-tokens"})
public class AccessTokenController
extends BaseController {
    @Autowired
    private AccessTokenService accessTokenService;

    @ApiOperation(value="createToken", notes="CREATE_TOKEN_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", required=true, dataTypeClass=int.class), @ApiImplicitParam(name="expireTime", value="EXPIRE_TIME", required=true, dataTypeClass=String.class, example="2021-12-31 00:00:00"), @ApiImplicitParam(name="token", value="TOKEN", required=false, dataTypeClass=String.class, example="xxxx")})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_ACCESS_TOKEN_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createToken(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="expireTime") String expireTime, @RequestParam(value="token", required=false) String token) {
        return this.accessTokenService.createToken(loginUser, userId, expireTime, token);
    }

    @ApiIgnore
    @PostMapping(value={"/generate"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.GENERATE_TOKEN_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result generateToken(@RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="expireTime") String expireTime) {
        Map<String, Object> result = this.accessTokenService.generateToken(loginUser, userId, expireTime);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryAccessTokenList", notes="QUERY_ACCESS_TOKEN_LIST_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataTypeClass=String.class), @ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataTypeClass=int.class, example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataTypeClass=int.class, example="20")})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ACCESSTOKEN_LIST_PAGING_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryAccessTokenList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        result = this.accessTokenService.queryAccessTokenList(loginUser, searchVal, pageNo, pageSize);
        return result;
    }

    @ApiOperation(value="queryAccessTokenByUser", notes="QUERY_ACCESS_TOKEN_BY_USER_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", dataTypeClass=int.class)})
    @GetMapping(value={"/user/{userId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ACCESSTOKEN_BY_USER_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryAccessTokenByUser(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="userId") Integer userId) {
        Map<String, Object> result = this.accessTokenService.queryAccessTokenByUser(loginUser, userId);
        return this.returnDataList(result);
    }

    @ApiIgnore
    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_ACCESS_TOKEN_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result delAccessTokenById(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id) {
        Map<String, Object> result = this.accessTokenService.delAccessTokenById(loginUser, id);
        return this.returnDataList(result);
    }

    @ApiOperation(value="updateToken", notes="UPDATE_TOKEN_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="TOKEN_ID", required=true, dataTypeClass=int.class), @ApiImplicitParam(name="userId", value="USER_ID", required=true, dataTypeClass=int.class), @ApiImplicitParam(name="expireTime", value="EXPIRE_TIME", required=true, dataTypeClass=String.class, example="2021-12-31 00:00:00"), @ApiImplicitParam(name="token", value="TOKEN", required=false, dataTypeClass=String.class, example="xxxx")})
    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_ACCESS_TOKEN_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateToken(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id, @RequestParam(value="userId") int userId, @RequestParam(value="expireTime") String expireTime, @RequestParam(value="token", required=false) String token) {
        Map<String, Object> result = this.accessTokenService.updateToken(loginUser, id, userId, expireTime, token);
        return this.returnDataList(result);
    }
}

