/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.DqExecuteResultService;
import org.apache.dolphinscheduler.api.service.DqRuleService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"DATA_QUALITY_SERVICE"})
@RestController
@RequestMapping(value={"/data-quality"})
public class DataQualityController
extends BaseController {
    @Autowired
    private DqRuleService dqRuleService;
    @Autowired
    private DqExecuteResultService dqExecuteResultService;

    @ApiOperation(value="getRuleFormCreateJson", notes="GET_RULE_FORM_CREATE_JSON_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ruleId", value="RULE_ID", dataTypeClass=int.class, example="1")})
    @GetMapping(value={"/getRuleFormCreateJson"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GET_RULE_FORM_CREATE_JSON_ERROR)
    public Result getRuleFormCreateJsonById(@RequestParam(value="ruleId") int ruleId) {
        Map<String, Object> result = this.dqRuleService.getRuleFormCreateJsonById(ruleId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryRuleListPaging", notes="QUERY_RULE_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataTypeClass=String.class), @ApiImplicitParam(name="ruleType", value="RULE_TYPE", dataTypeClass=int.class, example="1"), @ApiImplicitParam(name="startDate", value="START_DATE", dataTypeClass=String.class), @ApiImplicitParam(name="endDate", value="END_DATE", dataTypeClass=String.class), @ApiImplicitParam(name="pageNo", value="PAGE_NO", dataTypeClass=int.class, example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", dataTypeClass=int.class, example="10")})
    @GetMapping(value={"/rule/page"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_RULE_LIST_PAGING_ERROR)
    public Result queryRuleListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="ruleType", required=false) Integer ruleType, @RequestParam(value="startDate", required=false) String startTime, @RequestParam(value="endDate", required=false) String endTime, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        return this.dqRuleService.queryRuleListPaging(loginUser, searchVal, ruleType, startTime, endTime, pageNo, pageSize);
    }

    @ApiOperation(value="queryRuleList", notes="QUERY_RULE_LIST_NOTES")
    @GetMapping(value={"/ruleList"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_RULE_LIST_ERROR)
    public Result queryRuleList() {
        Map<String, Object> result = this.dqRuleService.queryAllRuleList();
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryExecuteResultListPaging", notes="QUERY_EXECUTE_RESULT_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataTypeClass=String.class), @ApiImplicitParam(name="ruleType", value="RULE_TYPE", dataTypeClass=int.class, example="1"), @ApiImplicitParam(name="state", value="STATE", dataTypeClass=int.class, example="1"), @ApiImplicitParam(name="startDate", value="START_DATE", dataTypeClass=String.class), @ApiImplicitParam(name="endDate", value="END_DATE", dataTypeClass=String.class), @ApiImplicitParam(name="pageNo", value="PAGE_NO", dataTypeClass=int.class, example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", dataTypeClass=int.class, example="10")})
    @GetMapping(value={"/result/page"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_EXECUTE_RESULT_LIST_PAGING_ERROR)
    public Result queryExecuteResultListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="ruleType", required=false) Integer ruleType, @RequestParam(value="state", required=false) Integer state, @RequestParam(value="startDate", required=false) String startTime, @RequestParam(value="endDate", required=false) String endTime, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        return this.dqExecuteResultService.queryResultListPaging(loginUser, searchVal, state, ruleType, startTime, endTime, pageNo, pageSize);
    }

    @ApiOperation(value="getDatasourceOptionsById", notes="GET_DATASOURCE_OPTIONS_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="datasourceId", value="DATA_SOURCE_ID", dataTypeClass=int.class, example="1")})
    @GetMapping(value={"/getDatasourceOptionsById"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GET_DATASOURCE_OPTIONS_ERROR)
    public Result getDatasourceOptionsById(@RequestParam(value="datasourceId") int datasourceId) {
        Map<String, Object> result = this.dqRuleService.getDatasourceOptionsById(datasourceId);
        return this.returnDataList(result);
    }
}

