/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.configuration;

import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.service.Operation;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;

@Component
public class OpenAPITranslationConfiguration {

    @Component
    @Order(value=0x7FFFFFFF)
    public static class TranslationOperationBuilderPlugin
    implements OperationBuilderPlugin {
        private final MessageSource messageSource;

        public boolean supports(DocumentationType delimiter) {
            return true;
        }

        public void apply(OperationContext context) {
            Locale locale = LocaleContextHolder.getLocale();
            Operation operation = context.operationBuilder().build();
            String notes = operation.getNotes();
            notes = this.messageSource.getMessage(notes, null, notes, locale);
            Set tags = operation.getTags().stream().map(tag -> this.messageSource.getMessage(tag, null, tag, locale)).collect(Collectors.toSet());
            Collection parameters = operation.getRequestParameters().stream().map(it -> new RequestParameter(it.getName(), it.getIn(), this.messageSource.getMessage(it.getDescription(), null, it.getDescription(), locale), it.getRequired(), it.getDeprecated(), it.getHidden(), it.getParameterSpecification(), it.getScalarExample(), (Collection)it.getExamples(), it.getPrecedence().intValue(), it.getExtensions(), it.getParameterIndex())).collect(Collectors.toList());
            context.operationBuilder().notes(notes).requestParameters(parameters).tags(tags);
        }

        @Generated
        public TranslationOperationBuilderPlugin(MessageSource messageSource) {
            this.messageSource = messageSource;
        }
    }
}

