/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.AlertGroupService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.dao.entity.AlertGroup;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.AlertGroupMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AlertGroupServiceImpl
extends BaseServiceImpl
implements AlertGroupService {
    private Logger logger = LoggerFactory.getLogger(AlertGroupServiceImpl.class);
    @Autowired
    private AlertGroupMapper alertGroupMapper;

    @Override
    public Map<String, Object> queryAlertgroup(User loginUser) {
        List alertGroups;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (loginUser.getUserType().equals((Object)UserType.ADMIN_USER)) {
            alertGroups = this.alertGroupMapper.queryAllGroupList();
        } else {
            Set ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.ALERT_GROUP, loginUser.getId(), this.logger);
            if (ids.isEmpty()) {
                result.put("data", Collections.emptyList());
                this.putMsg(result, Status.SUCCESS, new Object[0]);
                return result;
            }
            alertGroups = this.alertGroupMapper.selectBatchIds(ids);
        }
        result.put("data", alertGroups);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryAlertGroupById(User loginUser, Integer id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        if (!this.canOperatorPermissions(loginUser, new Object[]{id}, AuthorizationType.ALERT_GROUP, "security:alert-group:view")) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        AlertGroup alertGroup = (AlertGroup)this.alertGroupMapper.selectById((Serializable)id);
        if (alertGroup == null) {
            this.putMsg(result, Status.ALERT_GROUP_NOT_EXIST, new Object[0]);
            return result;
        }
        result.put("data", alertGroup);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result listPaging(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        IPage alertGroupPage;
        Result result = new Result();
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        if (loginUser.getUserType().equals((Object)UserType.ADMIN_USER)) {
            alertGroupPage = this.alertGroupMapper.queryAlertGroupPage(page, searchVal);
        } else {
            Set ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.ALERT_GROUP, loginUser.getId(), this.logger);
            if (ids.isEmpty()) {
                result.setData(pageInfo);
                this.putMsg(result, Status.SUCCESS, new Object[0]);
                return result;
            }
            alertGroupPage = this.alertGroupMapper.queryAlertGroupPageByIds(page, new ArrayList(ids), searchVal);
        }
        pageInfo.setTotal((int)alertGroupPage.getTotal());
        pageInfo.setTotalList(alertGroupPage.getRecords());
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> createAlertgroup(User loginUser, String groupName, String desc, String alertInstanceIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.ALERT_GROUP, "security:alert-group:create")) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (this.checkDescriptionLength(desc)) {
            this.putMsg(result, Status.DESCRIPTION_TOO_LONG_ERROR, new Object[0]);
            return result;
        }
        AlertGroup alertGroup = new AlertGroup();
        Date now = new Date();
        alertGroup.setGroupName(groupName);
        alertGroup.setAlertInstanceIds(alertInstanceIds);
        alertGroup.setDescription(desc);
        alertGroup.setCreateTime(now);
        alertGroup.setUpdateTime(now);
        alertGroup.setCreateUserId(loginUser.getId().intValue());
        try {
            int insert = this.alertGroupMapper.insert((Object)alertGroup);
            if (insert > 0) {
                result.put("data", alertGroup);
                this.putMsg(result, Status.SUCCESS, new Object[0]);
                this.permissionPostHandle(AuthorizationType.ALERT_GROUP, loginUser.getId(), Collections.singletonList(alertGroup.getId()), this.logger);
            } else {
                this.putMsg(result, Status.CREATE_ALERT_GROUP_ERROR, new Object[0]);
            }
        }
        catch (DuplicateKeyException ex) {
            this.logger.error("Create alert group error.", (Throwable)ex);
            this.putMsg(result, Status.ALERT_GROUP_EXIST, new Object[0]);
        }
        return result;
    }

    @Override
    public Map<String, Object> updateAlertgroup(User loginUser, int id, String groupName, String desc, String alertInstanceIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.canOperatorPermissions(loginUser, new Object[]{id}, AuthorizationType.ALERT_GROUP, "security:alert-group:update")) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (this.checkDescriptionLength(desc)) {
            this.putMsg(result, Status.DESCRIPTION_TOO_LONG_ERROR, new Object[0]);
            return result;
        }
        AlertGroup alertGroup = (AlertGroup)this.alertGroupMapper.selectById((Serializable)Integer.valueOf(id));
        if (alertGroup == null) {
            this.putMsg(result, Status.ALERT_GROUP_NOT_EXIST, new Object[0]);
            return result;
        }
        Date now = new Date();
        if (!StringUtils.isEmpty((CharSequence)groupName)) {
            alertGroup.setGroupName(groupName);
        }
        alertGroup.setDescription(desc);
        alertGroup.setUpdateTime(now);
        alertGroup.setCreateUserId(loginUser.getId().intValue());
        alertGroup.setAlertInstanceIds(alertInstanceIds);
        try {
            this.alertGroupMapper.updateById((Object)alertGroup);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        catch (DuplicateKeyException ex) {
            this.logger.error("Update alert group error.", (Throwable)ex);
            this.putMsg(result, Status.ALERT_GROUP_EXIST, new Object[0]);
        }
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> delAlertgroupById(User loginUser, int id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        if (!this.canOperatorPermissions(loginUser, new Object[]{id}, AuthorizationType.ALERT_GROUP, "security:alert-group:delete")) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (id == 1) {
            this.putMsg(result, Status.NOT_ALLOW_TO_DELETE_DEFAULT_ALARM_GROUP, new Object[0]);
            return result;
        }
        AlertGroup alertGroup = (AlertGroup)this.alertGroupMapper.selectById((Serializable)Integer.valueOf(id));
        if (alertGroup == null) {
            this.putMsg(result, Status.ALERT_GROUP_NOT_EXIST, new Object[0]);
            return result;
        }
        this.alertGroupMapper.deleteById((Serializable)Integer.valueOf(id));
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public boolean existGroupName(String groupName) {
        return this.alertGroupMapper.existGroupName(groupName) == Boolean.TRUE;
    }
}

