/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.EnvironmentService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"ENVIRONMENT_TAG"})
@RestController
@RequestMapping(value={"environment"})
public class EnvironmentController
extends BaseController {
    @Autowired
    private EnvironmentService environmentService;

    @ApiOperation(value="createEnvironment", notes="CREATE_ENVIRONMENT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="ENVIRONMENT_NAME", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="config", value="ENVIRONMENT_CONFIG", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="description", value="ENVIRONMENT_DESC", dataTypeClass=String.class), @ApiImplicitParam(name="workerGroups", value="WORKER_GROUP_LIST", dataTypeClass=String.class)})
    @PostMapping(value={"/create"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_ENVIRONMENT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createEnvironment(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="name") String name, @RequestParam(value="config") String config, @RequestParam(value="description", required=false) String description, @RequestParam(value="workerGroups", required=false) String workerGroups) {
        Map<String, Object> result = this.environmentService.createEnvironment(loginUser, name, config, description, workerGroups);
        return this.returnDataList(result);
    }

    @ApiOperation(value="updateEnvironment", notes="UPDATE_ENVIRONMENT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="ENVIRONMENT_CODE", required=true, dataTypeClass=long.class, example="100"), @ApiImplicitParam(name="name", value="ENVIRONMENT_NAME", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="config", value="ENVIRONMENT_CONFIG", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="description", value="ENVIRONMENT_DESC", dataTypeClass=String.class), @ApiImplicitParam(name="workerGroups", value="WORKER_GROUP_LIST", dataTypeClass=String.class)})
    @PostMapping(value={"/update"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_ENVIRONMENT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateEnvironment(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="code") Long code, @RequestParam(value="name") String name, @RequestParam(value="config") String config, @RequestParam(value="description", required=false) String description, @RequestParam(value="workerGroups", required=false) String workerGroups) {
        Map<String, Object> result = this.environmentService.updateEnvironmentByCode(loginUser, code, name, config, description, workerGroups);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryEnvironmentByCode", notes="QUERY_ENVIRONMENT_BY_CODE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="environmentCode", value="ENVIRONMENT_CODE", required=true, dataTypeClass=long.class, example="100")})
    @GetMapping(value={"/query-by-code"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ENVIRONMENT_BY_CODE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryEnvironmentByCode(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="environmentCode") Long environmentCode) {
        Map<String, Object> result = this.environmentService.queryEnvironmentByCode(environmentCode);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryEnvironmentListPaging", notes="QUERY_ENVIRONMENT_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataTypeClass=String.class), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataTypeClass=int.class, example="20"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataTypeClass=int.class, example="1")})
    @GetMapping(value={"/list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ENVIRONMENT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryEnvironmentListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="pageNo") Integer pageNo) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        result = this.environmentService.queryEnvironmentListPaging(loginUser, pageNo, pageSize, searchVal);
        return result;
    }

    @ApiOperation(value="deleteEnvironmentByCode", notes="DELETE_ENVIRONMENT_BY_CODE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="environmentCode", value="ENVIRONMENT_CODE", required=true, dataTypeClass=long.class, example="100")})
    @PostMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_ENVIRONMENT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteEnvironment(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="environmentCode") Long environmentCode) {
        Map<String, Object> result = this.environmentService.deleteEnvironmentByCode(loginUser, environmentCode);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryAllEnvironmentList", notes="QUERY_ALL_ENVIRONMENT_LIST_NOTES")
    @GetMapping(value={"/query-environment-list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ENVIRONMENT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryAllEnvironmentList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        Map<String, Object> result = this.environmentService.queryAllEnvironmentList(loginUser);
        return this.returnDataList(result);
    }

    @ApiOperation(value="verifyEnvironment", notes="VERIFY_ENVIRONMENT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="environmentName", value="ENVIRONMENT_NAME", required=true, dataTypeClass=String.class)})
    @PostMapping(value={"/verify-environment"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_ENVIRONMENT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result verifyEnvironment(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="environmentName") String environmentName) {
        Map<String, Object> result = this.environmentService.verifyEnvironment(environmentName);
        return this.returnDataList(result);
    }
}

