/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.aspect;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.metrics.ApiServerMetrics;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class AccessLogAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AccessLogAspect.class);
    private static final String TRACE_ID = "traceId";
    public static final String sensitiveDataRegEx = "(password=['\"]+)(\\S+)(['\"]+)";
    private static final Pattern sensitiveDataPattern = Pattern.compile("(password=['\"]+)(\\S+)(['\"]+)", 2);

    @Pointcut(value="@annotation(org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object doAround(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        long startTime = System.currentTimeMillis();
        String URI = null;
        String requestMethod = null;
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            URI = request.getRequestURI();
            requestMethod = request.getMethod();
        }
        MethodSignature sign = (MethodSignature)proceedingJoinPoint.getSignature();
        Method method = sign.getMethod();
        AccessLogAnnotation annotation = method.getAnnotation(AccessLogAnnotation.class);
        String traceId = String.valueOf(CodeGenerateUtils.getInstance().genCode());
        int userId = -1;
        String userName = "NOT LOGIN";
        if (!annotation.ignoreRequest() && attributes != null) {
            User loginUser;
            HttpServletRequest request = attributes.getRequest();
            String traceIdFromHeader = request.getHeader(TRACE_ID);
            if (StringUtils.isNotEmpty((CharSequence)traceIdFromHeader)) {
                traceId = traceIdFromHeader;
            }
            if ((loginUser = this.parseLoginInfo(request)) != null) {
                userName = loginUser.getUserName();
                userId = loginUser.getId();
            }
            String argsString = this.parseArgs(proceedingJoinPoint, annotation);
            argsString = this.handleSensitiveData(argsString);
            log.info("REQUEST TRACE_ID:{}, LOGIN_USER:{}, URI:{}, METHOD:{}, HANDLER:{}, ARGS:{}", new Object[]{traceId, userName, request.getRequestURI(), request.getMethod(), proceedingJoinPoint.getSignature().getDeclaringTypeName() + "." + proceedingJoinPoint.getSignature().getName(), argsString});
        }
        Object ob = proceedingJoinPoint.proceed();
        long costTime = System.currentTimeMillis() - startTime;
        log.info("Call {}:{} success, cost: {}ms", new Object[]{requestMethod, URI, costTime});
        if (userId != -1) {
            ApiServerMetrics.recordApiResponseTime(costTime, userId);
        }
        return ob;
    }

    private String parseArgs(ProceedingJoinPoint proceedingJoinPoint, AccessLogAnnotation annotation) {
        String[] parameterNames;
        Object[] args = proceedingJoinPoint.getArgs();
        String argsString = Arrays.toString(args);
        if (annotation.ignoreRequestArgs().length > 0 && (parameterNames = ((MethodSignature)proceedingJoinPoint.getSignature()).getParameterNames()).length > 0) {
            Set ignoreSet = Arrays.stream(annotation.ignoreRequestArgs()).collect(Collectors.toSet());
            HashMap<String, Object> argsMap = new HashMap<String, Object>();
            for (int i = 0; i < parameterNames.length; ++i) {
                if (ignoreSet.contains(parameterNames[i])) continue;
                argsMap.put(parameterNames[i], args[i]);
            }
            argsString = argsMap.toString();
        }
        return argsString;
    }

    protected String handleSensitiveData(String originalData) {
        Matcher matcher = sensitiveDataPattern.matcher(originalData.toLowerCase());
        IntStream stream = IntStream.builder().build();
        boolean exists = false;
        while (matcher.find()) {
            if (matcher.groupCount() != 3) continue;
            stream = IntStream.concat(stream, IntStream.range(matcher.end(1), matcher.end(2)));
            exists = true;
        }
        if (exists) {
            char[] chars = originalData.toCharArray();
            stream.forEach(idx -> {
                chars[idx] = 42;
            });
            return new String(chars);
        }
        return originalData;
    }

    private User parseLoginInfo(HttpServletRequest request) {
        User loginUser = (User)request.getAttribute("session.user");
        return loginUser;
    }
}

