/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.configuration;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import org.apache.dolphinscheduler.dao.entity.DsVersion;
import org.apache.dolphinscheduler.dao.repository.DsVersionDao;
import org.springdoc.core.GroupedOpenApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnWebApplication
@PropertySource(value={"classpath:swagger.properties"})
public class SwaggerConfiguration
implements WebMvcConfigurer {
    @Autowired
    private DsVersionDao dsVersionDao;
    private volatile String dsVersion;

    @Bean
    public OpenAPI openAPI() {
        Info info = new Info().title("Apache DolphinScheduler Api Docs").description("Apache DolphinScheduler Api Docs").version(this.getDsVersion());
        return new OpenAPI().info(info);
    }

    @Bean
    public GroupedOpenApi publicApi1() {
        return GroupedOpenApi.builder().group("v1").pathsToExclude(new String[]{"/v2/**"}).build();
    }

    @Bean
    public GroupedOpenApi publicApi2() {
        return GroupedOpenApi.builder().group("v2").pathsToMatch(new String[]{"/v2/**"}).build();
    }

    private String getDsVersion() {
        if (this.dsVersion != null) {
            return this.dsVersion;
        }
        this.dsVersion = this.dsVersionDao.selectVersion().map(DsVersion::getVersion).orElse("unknown");
        return this.dsVersion;
    }
}

