/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.AccessTokenService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="ACCESS_TOKEN_TAG")
@RestController
@RequestMapping(value={"/access-tokens"})
public class AccessTokenController
extends BaseController {
    @Autowired
    private AccessTokenService accessTokenService;

    @Operation(summary="createToken", description="CREATE_TOKEN_NOTES")
    @Parameters(value={@Parameter(name="userId", description="USER_ID", schema=@Schema(implementation=int.class), required=true), @Parameter(name="expireTime", description="EXPIRE_TIME", schema=@Schema(implementation=String.class), required=true, example="2021-12-31 00:00:00"), @Parameter(name="token", description="TOKEN", required=false, schema=@Schema(implementation=String.class), example="xxxx")})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_ACCESS_TOKEN_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createToken(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="expireTime") String expireTime, @RequestParam(value="token", required=false) String token) {
        return this.accessTokenService.createToken(loginUser, userId, expireTime, token);
    }

    @Parameter(hidden=true)
    @PostMapping(value={"/generate"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.GENERATE_TOKEN_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result generateToken(@RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="expireTime") String expireTime) {
        Map<String, Object> result = this.accessTokenService.generateToken(loginUser, userId, expireTime);
        return this.returnDataList(result);
    }

    @Operation(summary="queryAccessTokenList", description="QUERY_ACCESS_TOKEN_LIST_NOTES")
    @Parameters(value={@Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class)), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class), example="1"), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class), example="20")})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ACCESSTOKEN_LIST_PAGING_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryAccessTokenList(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        result = this.accessTokenService.queryAccessTokenList(loginUser, searchVal, pageNo, pageSize);
        return result;
    }

    @Operation(summary="queryAccessTokenByUser", description="QUERY_ACCESS_TOKEN_BY_USER_NOTES")
    @Parameters(value={@Parameter(name="userId", description="USER_ID", schema=@Schema(implementation=int.class))})
    @GetMapping(value={"/user/{userId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ACCESSTOKEN_BY_USER_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryAccessTokenByUser(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="userId") Integer userId) {
        Map<String, Object> result = this.accessTokenService.queryAccessTokenByUser(loginUser, userId);
        return this.returnDataList(result);
    }

    @Parameter(hidden=true)
    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_ACCESS_TOKEN_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result delAccessTokenById(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id) {
        Map<String, Object> result = this.accessTokenService.delAccessTokenById(loginUser, id);
        return this.returnDataList(result);
    }

    @Operation(summary="updateToken", description="UPDATE_TOKEN_NOTES")
    @Parameters(value={@Parameter(name="id", description="TOKEN_ID", required=true, schema=@Schema(implementation=int.class)), @Parameter(name="userId", description="USER_ID", required=true, schema=@Schema(implementation=int.class)), @Parameter(name="expireTime", description="EXPIRE_TIME", required=true, schema=@Schema(implementation=String.class), example="2021-12-31 00:00:00"), @Parameter(name="token", description="TOKEN", required=false, schema=@Schema(implementation=String.class), example="xxxx")})
    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_ACCESS_TOKEN_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateToken(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id, @RequestParam(value="userId") int userId, @RequestParam(value="expireTime") String expireTime, @RequestParam(value="token", required=false) String token) {
        Map<String, Object> result = this.accessTokenService.updateToken(loginUser, id, userId, expireTime, token);
        return this.returnDataList(result);
    }
}

