/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import lombok.Generated;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.AlertGroupService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="ALERT_GROUP_TAG")
@RestController
@RequestMapping(value={"/alert-groups"})
public class AlertGroupController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertGroupController.class);
    @Autowired
    private AlertGroupService alertGroupService;

    @Operation(summary="createAlertgroup", description="CREATE_ALERT_GROUP_NOTES")
    @Parameters(value={@Parameter(name="groupName", description="GROUP_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="description", description="DESC", schema=@Schema(implementation=String.class)), @Parameter(name="alertInstanceIds", description="alertInstanceIds", required=true, schema=@Schema(implementation=String.class))})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_ALERT_GROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createAlertgroup(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="groupName") String groupName, @RequestParam(value="description", required=false) String description, @RequestParam(value="alertInstanceIds") String alertInstanceIds) {
        Map<String, Object> result = this.alertGroupService.createAlertgroup(loginUser, groupName, description, alertInstanceIds);
        return this.returnDataList(result);
    }

    @Operation(summary="listAlertgroupById", description="QUERY_ALERT_GROUP_LIST_NOTES")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ALL_ALERTGROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result list(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        Map<String, Object> result = this.alertGroupService.queryAlertgroup(loginUser);
        return this.returnDataList(result);
    }

    @Operation(summary="queryAlertGroupListPaging", description="QUERY_ALERT_GROUP_LIST_PAGING_NOTES")
    @Parameters(value={@Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class)), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="20"))})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LIST_PAGING_ALERT_GROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result listPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        return this.alertGroupService.listPaging(loginUser, searchVal, pageNo, pageSize);
    }

    @Operation(summary="queryAlertGroupById", description="QUERY_ALERT_GROUP_BY_ID_NOTES")
    @Parameters(value={@Parameter(name="id", description="ALERT_GROUP_ID", schema=@Schema(implementation=int.class, example="1"))})
    @PostMapping(value={"/query"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ALERT_GROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryAlertGroupById(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") Integer id) {
        Map<String, Object> result = this.alertGroupService.queryAlertGroupById(loginUser, id);
        return this.returnDataList(result);
    }

    @Operation(summary="updateAlertgroup", description="UPDATE_ALERT_GROUP_NOTES")
    @Parameters(value={@Parameter(name="id", description="ALERT_GROUP_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="groupName", description="GROUP_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="description", description="DESC", schema=@Schema(implementation=String.class)), @Parameter(name="alertInstanceIds", description="ALERT_INSTANCE_IDS", required=true, schema=@Schema(implementation=String.class))})
    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_ALERT_GROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateAlertgroup(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id, @RequestParam(value="groupName") String groupName, @RequestParam(value="description", required=false) String description, @RequestParam(value="alertInstanceIds") String alertInstanceIds) {
        Map<String, Object> result = this.alertGroupService.updateAlertgroup(loginUser, id, groupName, description, alertInstanceIds);
        return this.returnDataList(result);
    }

    @Operation(summary="delAlertgroupById", description="DELETE_ALERT_GROUP_BY_ID_NOTES")
    @Parameters(value={@Parameter(name="id", description="ALERT_GROUP_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_ALERT_GROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result delAlertgroupById(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id) {
        Map<String, Object> result = this.alertGroupService.delAlertgroupById(loginUser, id);
        return this.returnDataList(result);
    }

    @Operation(summary="verifyGroupName", description="VERIFY_ALERT_GROUP_NAME_NOTES")
    @Parameters(value={@Parameter(name="groupName", description="GROUP_NAME", required=true, schema=@Schema(implementation=String.class))})
    @GetMapping(value={"/verify-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result verifyGroupName(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="groupName") String groupName) {
        boolean exist = this.alertGroupService.existGroupName(groupName);
        Result result = new Result();
        if (exist) {
            log.error("group {} has exist, can't create again.", (Object)groupName);
            result.setCode(Status.ALERT_GROUP_EXIST.getCode());
            result.setMsg(Status.ALERT_GROUP_EXIST.getMsg());
        } else {
            result.setCode(Status.SUCCESS.getCode());
            result.setMsg(Status.SUCCESS.getMsg());
        }
        return result;
    }
}

