/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import lombok.Generated;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.AlertPluginInstanceService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="ALERT_PLUGIN_INSTANCE_TAG")
@RestController
@RequestMapping(value={"alert-plugin-instances"})
public class AlertPluginInstanceController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertPluginInstanceController.class);
    @Autowired
    private AlertPluginInstanceService alertPluginInstanceService;

    @Operation(summary="createAlertPluginInstance", description="CREATE_ALERT_PLUGIN_INSTANCE_NOTES")
    @Parameters(value={@Parameter(name="pluginDefineId", description="ALERT_PLUGIN_DEFINE_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="instanceName", description="ALERT_PLUGIN_INSTANCE_NAME", required=true, schema=@Schema(implementation=String.class, example="DING TALK")), @Parameter(name="pluginInstanceParams", description="ALERT_PLUGIN_INSTANCE_PARAMS", required=true, schema=@Schema(implementation=String.class, example="ALERT_PLUGIN_INSTANCE_PARAMS"))})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_ALERT_PLUGIN_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createAlertPluginInstance(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pluginDefineId") int pluginDefineId, @RequestParam(value="instanceName") String instanceName, @RequestParam(value="pluginInstanceParams") String pluginInstanceParams) {
        Map<String, Object> result = this.alertPluginInstanceService.create(loginUser, pluginDefineId, instanceName, pluginInstanceParams);
        return this.returnDataList(result);
    }

    @Operation(summary="updateAlertPluginInstance", description="UPDATE_ALERT_PLUGIN_INSTANCE_NOTES")
    @Parameters(value={@Parameter(name="alertPluginInstanceId", description="ALERT_PLUGIN_INSTANCE_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="instanceName", description="ALERT_PLUGIN_INSTANCE_NAME", required=true, schema=@Schema(implementation=String.class, example="DING TALK")), @Parameter(name="pluginInstanceParams", description="ALERT_PLUGIN_INSTANCE_PARAMS", required=true, schema=@Schema(implementation=String.class, example="ALERT_PLUGIN_INSTANCE_PARAMS"))})
    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_ALERT_PLUGIN_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateAlertPluginInstance(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id, @RequestParam(value="instanceName") String instanceName, @RequestParam(value="pluginInstanceParams") String pluginInstanceParams) {
        Map<String, Object> result = this.alertPluginInstanceService.update(loginUser, id, instanceName, pluginInstanceParams);
        return this.returnDataList(result);
    }

    @Operation(summary="deleteAlertPluginInstance", description="DELETE_ALERT_PLUGIN_INSTANCE_NOTES")
    @Parameters(value={@Parameter(name="id", description="ALERT_PLUGIN_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_ALERT_PLUGIN_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteAlertPluginInstance(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id) {
        Map<String, Object> result = this.alertPluginInstanceService.delete(loginUser, id);
        return this.returnDataList(result);
    }

    @Operation(summary="getAlertPluginInstance", description="GET_ALERT_PLUGIN_INSTANCE_NOTES")
    @GetMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GET_ALERT_PLUGIN_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result getAlertPluginInstance(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id) {
        Map<String, Object> result = this.alertPluginInstanceService.get(loginUser, id);
        return this.returnDataList(result);
    }

    @Operation(summary="queryAlertPluginInstanceList", description="QUERY_ALL_ALERT_PLUGIN_INSTANCE_NOTES")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ALL_ALERT_PLUGIN_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result getAlertPluginInstance(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        Map<String, Object> result = this.alertPluginInstanceService.queryAll();
        return this.returnDataList(result);
    }

    @Operation(summary="verifyAlertInstanceName", description="VERIFY_ALERT_INSTANCE_NAME_NOTES")
    @Parameters(value={@Parameter(name="alertInstanceName", description="ALERT_INSTANCE_NAME", required=true, schema=@Schema(implementation=String.class))})
    @GetMapping(value={"/verify-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result verifyGroupName(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="alertInstanceName") String alertInstanceName) {
        boolean exist = this.alertPluginInstanceService.checkExistPluginInstanceName(alertInstanceName);
        if (exist) {
            log.error("alert plugin instance {} has exist, can't create again.", (Object)alertInstanceName);
            return Result.error(Status.PLUGIN_INSTANCE_ALREADY_EXISTS);
        }
        return Result.success();
    }

    @Operation(summary="queryAlertPluginInstanceListPaging", description="QUERY_ALERT_PLUGIN_INSTANCE_LIST_PAGING_NOTES")
    @Parameters(value={@Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class)), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="20"))})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LIST_PAGING_ALERT_PLUGIN_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result listPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        return this.alertPluginInstanceService.listPaging(loginUser, searchVal, pageNo, pageSize);
    }
}

