/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.AuditService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.AuditOperationType;
import org.apache.dolphinscheduler.common.enums.AuditResourceType;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="AUDIT_LOG_TAG")
@RestController
@RequestMapping(value={"projects/audit"})
public class AuditLogController
extends BaseController {
    @Autowired
    AuditService auditService;

    @Operation(summary="queryAuditLogListPaging", description="QUERY_AUDIT_LOG")
    @Parameters(value={@Parameter(name="startDate", description="START_DATE", schema=@Schema(implementation=String.class)), @Parameter(name="endDate", description="END_DATE", schema=@Schema(implementation=String.class)), @Parameter(name="resourceType", description="RESOURCE_TYPE", schema=@Schema(implementation=AuditResourceType.class)), @Parameter(name="operationType", description="OPERATION_TYPE", schema=@Schema(implementation=AuditOperationType.class)), @Parameter(name="userName", description="USER_NAME", schema=@Schema(implementation=String.class)), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="20"))})
    @GetMapping(value={"/audit-log-list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_AUDIT_LOG_LIST_PAGING)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryAuditLogListPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="resourceType", required=false) AuditResourceType resourceType, @RequestParam(value="operationType", required=false) AuditOperationType operationType, @RequestParam(value="startDate", required=false) String startDate, @RequestParam(value="endDate", required=false) String endDate, @RequestParam(value="userName", required=false) String userName) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        result = this.auditService.queryLogListPaging(loginUser, resourceType, operationType, startDate, endDate, userName, pageNo, pageSize);
        return result;
    }
}

