/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ClusterService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="CLUSTER_TAG")
@RestController
@RequestMapping(value={"cluster"})
public class ClusterController
extends BaseController {
    @Autowired
    private ClusterService clusterService;

    @Operation(summary="createCluster", description="CREATE_CLUSTER_NOTES")
    @Parameters(value={@Parameter(name="name", description="CLUSTER_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="config", description="CLUSTER_CONFIG", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="description", description="CLUSTER_DESC", schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/create"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_CLUSTER_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createProject(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="name") String name, @RequestParam(value="config") String config, @RequestParam(value="description", required=false) String description) {
        Map<String, Object> result = this.clusterService.createCluster(loginUser, name, config, description);
        return this.returnDataList(result);
    }

    @Operation(summary="updateCluster", description="UPDATE_CLUSTER_NOTES")
    @Parameters(value={@Parameter(name="code", description="CLUSTER_CODE", required=true, schema=@Schema(implementation=long.class, example="100")), @Parameter(name="name", description="CLUSTER_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="config", description="CLUSTER_CONFIG", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="description", description="CLUSTER_DESC", schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/update"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_CLUSTER_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateCluster(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="code") Long code, @RequestParam(value="name") String name, @RequestParam(value="config") String config, @RequestParam(value="description", required=false) String description) {
        Map<String, Object> result = this.clusterService.updateClusterByCode(loginUser, code, name, config, description);
        return this.returnDataList(result);
    }

    @Operation(summary="queryClusterByCode", description="QUERY_CLUSTER_BY_CODE_NOTES")
    @Parameters(value={@Parameter(name="clusterCode", description="CLUSTER_CODE", required=true, schema=@Schema(implementation=long.class, example="100"))})
    @GetMapping(value={"/query-by-code"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_CLUSTER_BY_CODE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryClusterByCode(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="clusterCode") Long clusterCode) {
        Map<String, Object> result = this.clusterService.queryClusterByCode(clusterCode);
        return this.returnDataList(result);
    }

    @Operation(summary="queryClusterListPaging", description="QUERY_CLUSTER_LIST_PAGING_NOTES")
    @Parameters(value={@Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class)), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="20")), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1"))})
    @GetMapping(value={"/list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_CLUSTER_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryClusterListPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="pageNo") Integer pageNo) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        result = this.clusterService.queryClusterListPaging(pageNo, pageSize, searchVal);
        return result;
    }

    @Operation(summary="deleteClusterByCode", description="DELETE_CLUSTER_BY_CODE_NOTES")
    @Parameters(value={@Parameter(name="clusterCode", description="CLUSTER_CODE", required=true, schema=@Schema(implementation=long.class, example="100"))})
    @PostMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_CLUSTER_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteCluster(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="clusterCode") Long clusterCode) {
        Map<String, Object> result = this.clusterService.deleteClusterByCode(loginUser, clusterCode);
        return this.returnDataList(result);
    }

    @Operation(summary="queryAllClusterList", description="QUERY_ALL_CLUSTER_LIST_NOTES")
    @GetMapping(value={"/query-cluster-list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_CLUSTER_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryAllClusterList(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        Map<String, Object> result = this.clusterService.queryAllClusterList();
        return this.returnDataList(result);
    }

    @Operation(summary="verifyCluster", description="VERIFY_CLUSTER_NOTES")
    @Parameters(value={@Parameter(name="clusterName", description="CLUSTER_NAME", required=true, schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/verify-cluster"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_CLUSTER_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result verifyCluster(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="clusterName") String clusterName) {
        Map<String, Object> result = this.clusterService.verifyCluster(clusterName);
        return this.returnDataList(result);
    }
}

