/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.DqExecuteResultService;
import org.apache.dolphinscheduler.api.service.DqRuleService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="DATA_QUALITY_TAG")
@RestController
@RequestMapping(value={"/data-quality"})
public class DataQualityController
extends BaseController {
    @Autowired
    private DqRuleService dqRuleService;
    @Autowired
    private DqExecuteResultService dqExecuteResultService;

    @Operation(summary="getRuleFormCreateJson", description="GET_RULE_FORM_CREATE_JSON_NOTES")
    @Parameters(value={@Parameter(name="ruleId", description="RULE_ID", schema=@Schema(implementation=int.class, example="1"))})
    @GetMapping(value={"/getRuleFormCreateJson"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GET_RULE_FORM_CREATE_JSON_ERROR)
    public Result getRuleFormCreateJsonById(@RequestParam(value="ruleId") int ruleId) {
        Map<String, Object> result = this.dqRuleService.getRuleFormCreateJsonById(ruleId);
        return this.returnDataList(result);
    }

    @Operation(summary="queryRuleListPaging", description="QUERY_RULE_LIST_PAGING_NOTES")
    @Parameters(value={@Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class)), @Parameter(name="ruleType", description="RULE_TYPE", schema=@Schema(implementation=int.class, example="1")), @Parameter(name="startDate", description="START_DATE", schema=@Schema(implementation=String.class)), @Parameter(name="endDate", description="END_DATE", schema=@Schema(implementation=String.class)), @Parameter(name="pageNo", description="PAGE_NO", schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", schema=@Schema(implementation=int.class, example="10"))})
    @GetMapping(value={"/rule/page"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_RULE_LIST_PAGING_ERROR)
    public Result queryRuleListPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="ruleType", required=false) Integer ruleType, @RequestParam(value="startDate", required=false) String startTime, @RequestParam(value="endDate", required=false) String endTime, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        return this.dqRuleService.queryRuleListPaging(loginUser, searchVal, ruleType, startTime, endTime, pageNo, pageSize);
    }

    @Operation(summary="queryRuleList", description="QUERY_RULE_LIST_NOTES")
    @GetMapping(value={"/ruleList"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_RULE_LIST_ERROR)
    public Result queryRuleList() {
        Map<String, Object> result = this.dqRuleService.queryAllRuleList();
        return this.returnDataList(result);
    }

    @Operation(summary="queryExecuteResultListPaging", description="QUERY_EXECUTE_RESULT_LIST_PAGING_NOTES")
    @Parameters(value={@Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class)), @Parameter(name="ruleType", description="RULE_TYPE", schema=@Schema(implementation=int.class, example="1")), @Parameter(name="state", description="STATE", schema=@Schema(implementation=int.class, example="1")), @Parameter(name="startDate", description="START_DATE", schema=@Schema(implementation=String.class)), @Parameter(name="endDate", description="END_DATE", schema=@Schema(implementation=String.class)), @Parameter(name="pageNo", description="PAGE_NO", schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", schema=@Schema(implementation=int.class, example="10"))})
    @GetMapping(value={"/result/page"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_EXECUTE_RESULT_LIST_PAGING_ERROR)
    public Result queryExecuteResultListPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="ruleType", required=false) Integer ruleType, @RequestParam(value="state", required=false) Integer state, @RequestParam(value="startDate", required=false) String startTime, @RequestParam(value="endDate", required=false) String endTime, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        return this.dqExecuteResultService.queryResultListPaging(loginUser, searchVal, state, ruleType, startTime, endTime, pageNo, pageSize);
    }

    @Operation(summary="getDatasourceOptionsById", description="GET_DATASOURCE_OPTIONS_NOTES")
    @Parameters(value={@Parameter(name="datasourceId", description="DATA_SOURCE_ID", schema=@Schema(implementation=int.class, example="1"))})
    @GetMapping(value={"/getDatasourceOptionsById"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GET_DATASOURCE_OPTIONS_ERROR)
    public Result getDatasourceOptionsById(@RequestParam(value="datasourceId") int datasourceId) {
        Map<String, Object> result = this.dqRuleService.getDatasourceOptionsById(datasourceId);
        return this.returnDataList(result);
    }
}

