/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.Resource;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.configuration.DynamicTaskTypeConfiguration;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.dto.taskType.DynamicTaskInfo;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="DYNAMIC_TASK_TYPE")
@RestController
@RequestMapping(value={"/dynamic"})
public class DynamicTaskTypeController
extends BaseController {
    @Resource
    private DynamicTaskTypeConfiguration dynamicTaskTypeConfiguration;

    @Operation(summary="listTaskCates", description="LIST_TASK_TYPE_CATES")
    @GetMapping(value={"/taskCategories"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LIST_TASK_TYPE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result listDynamicTaskCategories(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        List<String> taskCategories = this.dynamicTaskTypeConfiguration.getTaskCategories();
        return this.success(Status.SUCCESS.getMsg(), taskCategories);
    }

    @Operation(summary="listDynamicTaskTypes", description="LIST_DYNAMIC_TASK_TYPES")
    @GetMapping(value={"/{taskCategory}/taskTypes"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LIST_TASK_TYPE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result listDynamicTaskTypes(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="taskCategory") String taskCategory) {
        List<DynamicTaskInfo> taskTypes = this.dynamicTaskTypeConfiguration.getTaskTypesByCategory(taskCategory);
        return this.success(Status.SUCCESS.getMsg(), taskTypes);
    }
}

