/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.ExecuteType;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ExecutorService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.ComplementDependentMode;
import org.apache.dolphinscheduler.common.enums.ExecutionOrder;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.RunMode;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.remote.dto.WorkflowExecuteDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="EXECUTOR_TAG")
@RestController
@RequestMapping(value={"projects/{projectCode}/executors"})
public class ExecutorController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutorController.class);
    @Autowired
    private ExecutorService execService;

    @Operation(summary="startProcessInstance", description="RUN_PROCESS_INSTANCE_NOTES")
    @Parameters(value={@Parameter(name="processDefinitionCode", description="PROCESS_DEFINITION_CODE", required=true, schema=@Schema(implementation=Long.class), example="100"), @Parameter(name="scheduleTime", description="SCHEDULE_TIME", required=true, schema=@Schema(implementation=String.class), example="2022-04-06 00:00:00,2022-04-06 00:00:00"), @Parameter(name="failureStrategy", description="FAILURE_STRATEGY", required=true, schema=@Schema(implementation=FailureStrategy.class)), @Parameter(name="startNodeList", description="START_NODE_LIST", schema=@Schema(implementation=String.class)), @Parameter(name="taskDependType", description="TASK_DEPEND_TYPE", schema=@Schema(implementation=TaskDependType.class)), @Parameter(name="execType", description="COMMAND_TYPE", schema=@Schema(implementation=CommandType.class)), @Parameter(name="warningType", description="WARNING_TYPE", required=true, schema=@Schema(implementation=WarningType.class)), @Parameter(name="warningGroupId", description="WARNING_GROUP_ID", schema=@Schema(implementation=int.class, example="100")), @Parameter(name="runMode", description="RUN_MODE", schema=@Schema(implementation=RunMode.class)), @Parameter(name="processInstancePriority", description="PROCESS_INSTANCE_PRIORITY", required=true, schema=@Schema(implementation=Priority.class)), @Parameter(name="workerGroup", description="WORKER_GROUP", schema=@Schema(implementation=String.class, example="default")), @Parameter(name="tenantCode", description="TENANT_CODE", schema=@Schema(implementation=String.class, example="default")), @Parameter(name="environmentCode", description="ENVIRONMENT_CODE", schema=@Schema(implementation=Long.class, example="-1")), @Parameter(name="timeout", description="TIMEOUT", schema=@Schema(implementation=int.class, example="100")), @Parameter(name="expectedParallelismNumber", description="EXPECTED_PARALLELISM_NUMBER", schema=@Schema(implementation=int.class, example="8")), @Parameter(name="dryRun", description="DRY_RUN", schema=@Schema(implementation=int.class, example="0")), @Parameter(name="testFlag", description="TEST_FLAG", schema=@Schema(implementation=int.class, example="0")), @Parameter(name="complementDependentMode", description="COMPLEMENT_DEPENDENT_MODE", schema=@Schema(implementation=ComplementDependentMode.class)), @Parameter(name="allLevelDependent", description="ALL_LEVEL_DEPENDENT", schema=@Schema(implementation=boolean.class, example="false")), @Parameter(name="executionOrder", description="EXECUTION_ORDER", schema=@Schema(implementation=ExecutionOrder.class))})
    @PostMapping(value={"start-process-instance"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.START_PROCESS_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result startProcessInstance(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="processDefinitionCode") long processDefinitionCode, @RequestParam(value="scheduleTime") String scheduleTime, @RequestParam(value="failureStrategy") FailureStrategy failureStrategy, @RequestParam(value="startNodeList", required=false) String startNodeList, @RequestParam(value="taskDependType", required=false) TaskDependType taskDependType, @RequestParam(value="execType", required=false) CommandType execType, @RequestParam(value="warningType") WarningType warningType, @RequestParam(value="warningGroupId", required=false) Integer warningGroupId, @RequestParam(value="runMode", required=false) RunMode runMode, @RequestParam(value="processInstancePriority", required=false) Priority processInstancePriority, @RequestParam(value="workerGroup", required=false, defaultValue="default") String workerGroup, @RequestParam(value="tenantCode", required=false, defaultValue="default") String tenantCode, @RequestParam(value="environmentCode", required=false, defaultValue="-1") Long environmentCode, @RequestParam(value="timeout", required=false) Integer timeout, @RequestParam(value="startParams", required=false) String startParams, @RequestParam(value="expectedParallelismNumber", required=false) Integer expectedParallelismNumber, @RequestParam(value="dryRun", defaultValue="0", required=false) int dryRun, @RequestParam(value="testFlag", defaultValue="0") int testFlag, @RequestParam(value="complementDependentMode", required=false) ComplementDependentMode complementDependentMode, @RequestParam(value="version", required=false) Integer version, @RequestParam(value="allLevelDependent", required=false, defaultValue="false") boolean allLevelDependent, @RequestParam(value="executionOrder", required=false) ExecutionOrder executionOrder) {
        if (timeout == null) {
            timeout = 86400;
        }
        Map startParamMap = null;
        if (startParams != null) {
            startParamMap = JSONUtils.toMap((String)startParams);
        }
        if (complementDependentMode == null) {
            complementDependentMode = ComplementDependentMode.OFF_MODE;
        }
        Map<String, Object> result = this.execService.execProcessInstance(loginUser, projectCode, processDefinitionCode, scheduleTime, execType, failureStrategy, startNodeList, taskDependType, warningType, warningGroupId, runMode, processInstancePriority, workerGroup, tenantCode, environmentCode, timeout, startParamMap, expectedParallelismNumber, dryRun, testFlag, complementDependentMode, version, allLevelDependent, executionOrder);
        return this.returnDataList(result);
    }

    @Operation(summary="batchStartProcessInstance", description="BATCH_RUN_PROCESS_INSTANCE_NOTES")
    @Parameters(value={@Parameter(name="processDefinitionCodes", description="PROCESS_DEFINITION_CODE_LIST", required=true, schema=@Schema(implementation=String.class, example="1,2,3")), @Parameter(name="scheduleTime", description="SCHEDULE_TIME", required=true, schema=@Schema(implementation=String.class, example="2022-04-06 00:00:00,2022-04-06 00:00:00")), @Parameter(name="failureStrategy", description="FAILURE_STRATEGY", required=true, schema=@Schema(implementation=FailureStrategy.class)), @Parameter(name="startNodeList", description="START_NODE_LIST", schema=@Schema(implementation=String.class)), @Parameter(name="taskDependType", description="TASK_DEPEND_TYPE", schema=@Schema(implementation=TaskDependType.class)), @Parameter(name="execType", description="COMMAND_TYPE", schema=@Schema(implementation=CommandType.class)), @Parameter(name="warningType", description="WARNING_TYPE", required=true, schema=@Schema(implementation=WarningType.class)), @Parameter(name="warningGroupId", description="WARNING_GROUP_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="runMode", description="RUN_MODE", schema=@Schema(implementation=RunMode.class)), @Parameter(name="processInstancePriority", description="PROCESS_INSTANCE_PRIORITY", required=true, schema=@Schema(implementation=Priority.class)), @Parameter(name="workerGroup", description="WORKER_GROUP", schema=@Schema(implementation=String.class, example="default")), @Parameter(name="tenantCode", description="TENANT_CODE", schema=@Schema(implementation=String.class, example="default")), @Parameter(name="environmentCode", description="ENVIRONMENT_CODE", schema=@Schema(implementation=Long.class, example="-1")), @Parameter(name="timeout", description="TIMEOUT", schema=@Schema(implementation=int.class, example="100")), @Parameter(name="expectedParallelismNumber", description="EXPECTED_PARALLELISM_NUMBER", schema=@Schema(implementation=int.class, example="8")), @Parameter(name="dryRun", description="DRY_RUN", schema=@Schema(implementation=int.class, example="0")), @Parameter(name="testFlag", description="TEST_FLAG", schema=@Schema(implementation=int.class, example="0")), @Parameter(name="complementDependentMode", description="COMPLEMENT_DEPENDENT_MODE", schema=@Schema(implementation=ComplementDependentMode.class)), @Parameter(name="allLevelDependent", description="ALL_LEVEL_DEPENDENT", schema=@Schema(implementation=boolean.class, example="false")), @Parameter(name="executionOrder", description="EXECUTION_ORDER", schema=@Schema(implementation=ExecutionOrder.class))})
    @PostMapping(value={"batch-start-process-instance"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.START_PROCESS_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result batchStartProcessInstance(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="processDefinitionCodes") String processDefinitionCodes, @RequestParam(value="scheduleTime") String scheduleTime, @RequestParam(value="failureStrategy") FailureStrategy failureStrategy, @RequestParam(value="startNodeList", required=false) String startNodeList, @RequestParam(value="taskDependType", required=false) TaskDependType taskDependType, @RequestParam(value="execType", required=false) CommandType execType, @RequestParam(value="warningType") WarningType warningType, @RequestParam(value="warningGroupId", required=false) Integer warningGroupId, @RequestParam(value="runMode", required=false) RunMode runMode, @RequestParam(value="processInstancePriority", required=false) Priority processInstancePriority, @RequestParam(value="workerGroup", required=false, defaultValue="default") String workerGroup, @RequestParam(value="tenantCode", required=false, defaultValue="default") String tenantCode, @RequestParam(value="environmentCode", required=false, defaultValue="-1") Long environmentCode, @RequestParam(value="timeout", required=false) Integer timeout, @RequestParam(value="startParams", required=false) String startParams, @RequestParam(value="expectedParallelismNumber", required=false) Integer expectedParallelismNumber, @RequestParam(value="dryRun", defaultValue="0", required=false) int dryRun, @RequestParam(value="testFlag", defaultValue="0") int testFlag, @RequestParam(value="complementDependentMode", required=false) ComplementDependentMode complementDependentMode, @RequestParam(value="allLevelDependent", required=false, defaultValue="false") boolean allLevelDependent, @RequestParam(value="executionOrder", required=false) ExecutionOrder executionOrder) {
        if (timeout == null) {
            log.debug("Parameter timeout set to {} due to null.", (Object)86400);
            timeout = 86400;
        }
        Map startParamMap = null;
        if (startParams != null) {
            startParamMap = JSONUtils.toMap((String)startParams);
        }
        if (complementDependentMode == null) {
            log.debug("Parameter complementDependentMode set to {} due to null.", (Object)ComplementDependentMode.OFF_MODE);
            complementDependentMode = ComplementDependentMode.OFF_MODE;
        }
        Map<String, Object> result = new HashMap<String, Object>();
        List<String> processDefinitionCodeArray = Arrays.asList(processDefinitionCodes.split(","));
        ArrayList<String> startFailedProcessDefinitionCodeList = new ArrayList<String>();
        processDefinitionCodeArray = processDefinitionCodeArray.stream().distinct().collect(Collectors.toList());
        for (String strProcessDefinitionCode : processDefinitionCodeArray) {
            long processDefinitionCode = Long.parseLong(strProcessDefinitionCode);
            result = this.execService.execProcessInstance(loginUser, projectCode, processDefinitionCode, scheduleTime, execType, failureStrategy, startNodeList, taskDependType, warningType, warningGroupId, runMode, processInstancePriority, workerGroup, tenantCode, environmentCode, timeout, startParamMap, expectedParallelismNumber, dryRun, testFlag, complementDependentMode, null, allLevelDependent, executionOrder);
            if (!Status.SUCCESS.equals(result.get("status"))) {
                log.error("Process definition start failed, projectCode:{}, processDefinitionCode:{}.", (Object)projectCode, (Object)processDefinitionCode);
                startFailedProcessDefinitionCodeList.add(String.valueOf(processDefinitionCode));
                continue;
            }
            log.info("Start process definition complete, projectCode:{}, processDefinitionCode:{}.", (Object)projectCode, (Object)processDefinitionCode);
        }
        if (!startFailedProcessDefinitionCodeList.isEmpty()) {
            this.putMsg(result, Status.BATCH_START_PROCESS_INSTANCE_ERROR, String.join((CharSequence)",", startFailedProcessDefinitionCodeList));
        }
        return this.returnDataList(result);
    }

    @Operation(summary="execute", description="EXECUTE_ACTION_TO_PROCESS_INSTANCE_NOTES")
    @Parameters(value={@Parameter(name="processInstanceId", description="PROCESS_INSTANCE_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="executeType", description="EXECUTE_TYPE", required=true, schema=@Schema(implementation=ExecuteType.class))})
    @PostMapping(value={"/execute"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.EXECUTE_PROCESS_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result execute(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="processInstanceId") Integer processInstanceId, @RequestParam(value="executeType") ExecuteType executeType) {
        Map<String, Object> result = this.execService.execute(loginUser, projectCode, processInstanceId, executeType);
        return this.returnDataList(result);
    }

    @Operation(summary="batchExecute", description="BATCH_EXECUTE_ACTION_TO_PROCESS_INSTANCE_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=int.class)), @Parameter(name="processInstanceIds", description="PROCESS_INSTANCE_IDS", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="executeType", description="EXECUTE_TYPE", required=true, schema=@Schema(implementation=ExecuteType.class))})
    @PostMapping(value={"/batch-execute"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.BATCH_EXECUTE_PROCESS_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result batchExecute(@RequestAttribute(value="session.user") User loginUser, @PathVariable long projectCode, @RequestParam(value="processInstanceIds") String processInstanceIds, @RequestParam(value="executeType") ExecuteType executeType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> executeFailedIdList = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)processInstanceIds)) {
            String[] processInstanceIdArray;
            for (String strProcessInstanceId : processInstanceIdArray = processInstanceIds.split(",")) {
                int processInstanceId = Integer.parseInt(strProcessInstanceId);
                try {
                    Map<String, Object> singleResult = this.execService.execute(loginUser, projectCode, processInstanceId, executeType);
                    if (!Status.SUCCESS.equals(singleResult.get("status"))) {
                        log.error("Start to execute process instance error, projectCode:{}, processInstanceId:{}.", (Object)projectCode, (Object)processInstanceId);
                        executeFailedIdList.add((String)singleResult.get("msg"));
                        continue;
                    }
                    log.info("Start to execute process instance complete, projectCode:{}, processInstanceId:{}.", (Object)projectCode, (Object)processInstanceId);
                }
                catch (Exception e) {
                    executeFailedIdList.add(MessageFormat.format(Status.PROCESS_INSTANCE_ERROR.getMsg(), strProcessInstanceId));
                }
            }
        }
        if (!executeFailedIdList.isEmpty()) {
            this.putMsg(result, Status.BATCH_EXECUTE_PROCESS_INSTANCE_ERROR, String.join((CharSequence)"\n", executeFailedIdList));
        } else {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return this.returnDataList(result);
    }

    @Operation(summary="startCheckProcessDefinition", description="START_CHECK_PROCESS_DEFINITION_NOTES")
    @Parameters(value={@Parameter(name="processDefinitionCode", description="PROCESS_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="100"))})
    @PostMapping(value={"/start-check"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.CHECK_PROCESS_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result startCheckProcessDefinition(@RequestParam(value="processDefinitionCode") long processDefinitionCode) {
        Map<String, Object> result = this.execService.startCheckByProcessDefinedCode(processDefinitionCode);
        return this.returnDataList(result);
    }

    @Operation(summary="queryExecutingWorkflow", description="QUERY_WORKFLOW_EXECUTE_DATA")
    @Parameters(value={@Parameter(name="processInstanceId", description="PROCESS_INSTANCE_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/query-executing-workflow"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_EXECUTING_WORKFLOW_ERROR)
    @AccessLogAnnotation
    public Result queryExecutingWorkflow(@RequestParam(value="id") Integer processInstanceId) {
        WorkflowExecuteDto workflowExecuteDto = this.execService.queryExecutingWorkflowByProcessInstanceId(processInstanceId);
        return Result.success(workflowExecuteDto);
    }

    @Operation(summary="startTaskInstance", description="RUN_TASK_INSTANCE_NOTES")
    @Parameters(value={@Parameter(name="version", description="VERSION", schema=@Schema(implementation=int.class, example="1")), @Parameter(name="failureStrategy", description="FAILURE_STRATEGY", required=true, schema=@Schema(implementation=FailureStrategy.class)), @Parameter(name="execType", description="COMMAND_TYPE", schema=@Schema(implementation=CommandType.class)), @Parameter(name="warningType", description="WARNING_TYPE", required=true, schema=@Schema(implementation=WarningType.class)), @Parameter(name="warningGroupId", description="WARNING_GROUP_ID", schema=@Schema(implementation=int.class, example="100")), @Parameter(name="workerGroup", description="WORKER_GROUP", schema=@Schema(implementation=String.class, example="default")), @Parameter(name="tenantCode", description="TENANT_CODE", schema=@Schema(implementation=String.class, example="default")), @Parameter(name="environmentCode", description="ENVIRONMENT_CODE", schema=@Schema(implementation=long.class, example="-1")), @Parameter(name="timeout", description="TIMEOUT", schema=@Schema(implementation=int.class, example="100")), @Parameter(name="dryRun", description="DRY_RUN", schema=@Schema(implementation=int.class, example="0"))})
    @PostMapping(value={"/task-instance/{code}/start"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.START_PROCESS_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result startStreamTaskInstance(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @Parameter(name="code", description="TASK_CODE", required=true) @PathVariable long code, @RequestParam(value="version", required=true) int version, @RequestParam(value="warningGroupId", required=false, defaultValue="0") Integer warningGroupId, @RequestParam(value="workerGroup", required=false, defaultValue="default") String workerGroup, @RequestParam(value="tenantCode", required=false, defaultValue="default") String tenantCode, @RequestParam(value="environmentCode", required=false, defaultValue="-1") Long environmentCode, @RequestParam(value="startParams", required=false) String startParams, @RequestParam(value="dryRun", defaultValue="0", required=false) int dryRun) {
        Map startParamMap = null;
        if (startParams != null) {
            startParamMap = JSONUtils.toMap((String)startParams);
        }
        log.info("Start to execute stream task instance, projectCode:{}, taskDefinitionCode:{}, taskVersion:{}.", new Object[]{projectCode, code, version});
        Map<String, Object> result = this.execService.execStreamTaskInstance(loginUser, projectCode, code, version, warningGroupId, workerGroup, tenantCode, environmentCode, startParamMap, dryRun);
        return this.returnDataList(result);
    }

    @Operation(summary="execute-task", description="EXECUTE_ACTION_TO_PROCESS_INSTANCE_NOTES")
    @Parameters(value={@Parameter(name="processInstanceId", description="PROCESS_INSTANCE_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="startNodeList", description="START_NODE_LIST", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="taskDependType", description="TASK_DEPEND_TYPE", required=true, schema=@Schema(implementation=TaskDependType.class))})
    @PostMapping(value={"/execute-task"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.EXECUTE_PROCESS_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result executeTask(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="processInstanceId") Integer processInstanceId, @RequestParam(value="startNodeList") String startNodeList, @RequestParam(value="taskDependType") TaskDependType taskDependType) {
        log.info("Start to execute task in process instance, projectCode:{}, processInstanceId:{}.", (Object)projectCode, (Object)processInstanceId);
        return this.execService.executeTask(loginUser, projectCode, processInstanceId, startNodeList, taskDependType);
    }
}

