/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.K8sNamespaceService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.K8sNamespace;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="K8S_NAMESPACE_TAG")
@RestController
@RequestMapping(value={"/k8s-namespace"})
public class K8sNamespaceController
extends BaseController {
    @Autowired
    private K8sNamespaceService k8sNamespaceService;

    @Operation(summary="queryNamespaceListPaging", description="QUERY_NAMESPACE_LIST_PAGING_NOTES")
    @Parameters(value={@Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class)), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="10")), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1"))})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_K8S_NAMESPACE_LIST_PAGING_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryNamespaceListPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="pageNo") Integer pageNo) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        result = this.k8sNamespaceService.queryListPaging(loginUser, searchVal, pageNo, pageSize);
        return result;
    }

    @Operation(summary="createK8sNamespace", description="CREATE_NAMESPACE_NOTES")
    @Parameters(value={@Parameter(name="namespace", description="NAMESPACE", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="clusterCode", description="CLUSTER_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="limits_cpu", description="LIMITS_CPU", required=false, schema=@Schema(implementation=double.class)), @Parameter(name="limits_memory", description="LIMITS_MEMORY", required=false, schema=@Schema(implementation=int.class))})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_K8S_NAMESPACE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createNamespace(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="namespace") String namespace, @RequestParam(value="clusterCode") Long clusterCode, @RequestParam(value="limitsCpu", required=false) Double limitsCpu, @RequestParam(value="limitsMemory", required=false) Integer limitsMemory) {
        Map<String, Object> result = this.k8sNamespaceService.createK8sNamespace(loginUser, namespace, clusterCode, limitsCpu, limitsMemory);
        return this.returnDataList(result);
    }

    @Operation(summary="updateK8sNamespace", description="UPDATE_NAMESPACE_NOTES")
    @Parameters(value={@Parameter(name="id", description="K8S_NAMESPACE_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="userName", description="OWNER", required=false, schema=@Schema(implementation=String.class)), @Parameter(name="limitsCpu", description="LIMITS_CPU", required=false, schema=@Schema(implementation=double.class)), @Parameter(name="limitsMemory", description="LIMITS_MEMORY", required=false, schema=@Schema(implementation=int.class))})
    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.UPDATE_K8S_NAMESPACE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateNamespace(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id, @RequestParam(value="userName", required=false) String userName, @RequestParam(value="tag", required=false) String tag, @RequestParam(value="limitsCpu", required=false) Double limitsCpu, @RequestParam(value="limitsMemory", required=false) Integer limitsMemory) {
        Map<String, Object> result = this.k8sNamespaceService.updateK8sNamespace(loginUser, id, userName, limitsCpu, limitsMemory);
        return this.returnDataList(result);
    }

    @Operation(summary="verifyNamespaceK8s", description="VERIFY_NAMESPACE_K8S_NOTES")
    @Parameters(value={@Parameter(name="namespace", description="NAMESPACE", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="clusterCode", description="CLUSTER_CODE", required=true, schema=@Schema(implementation=long.class))})
    @PostMapping(value={"/verify"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_K8S_NAMESPACE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result verifyNamespace(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="namespace") String namespace, @RequestParam(value="clusterCode") Long clusterCode) {
        return this.k8sNamespaceService.verifyNamespaceK8s(namespace, clusterCode);
    }

    @Operation(summary="delNamespaceById", description="DELETE_NAMESPACE_BY_ID_NOTES")
    @Parameters(value={@Parameter(name="id", description="NAMESPACE_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @PostMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_K8S_NAMESPACE_BY_ID_ERROR)
    @AccessLogAnnotation
    public Result delNamespaceById(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int id) {
        Map<String, Object> result = this.k8sNamespaceService.deleteNamespaceById(loginUser, id);
        return this.returnDataList(result);
    }

    @Operation(summary="queryUnauthorizedNamespace", description="QUERY_UNAUTHORIZED_NAMESPACE_NOTES")
    @Parameters(value={@Parameter(name="userId", description="USER_ID", schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/unauth-namespace"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_UNAUTHORIZED_NAMESPACE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryUnauthorizedNamespace(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        Map<String, Object> result = this.k8sNamespaceService.queryUnauthorizedNamespace(loginUser, userId);
        return this.returnDataList(result);
    }

    @Operation(summary="queryAuthorizedNamespace", description="QUERY_AUTHORIZED_NAMESPACE_NOTES")
    @Parameters(value={@Parameter(name="userId", description="USER_ID", schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/authed-namespace"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_AUTHORIZED_NAMESPACE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryAuthorizedNamespace(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        Map<String, Object> result = this.k8sNamespaceService.queryAuthorizedNamespace(loginUser, userId);
        return this.returnDataList(result);
    }

    @Operation(summary="queryAvailableNamespaceList", description="QUERY_AVAILABLE_NAMESPACE_LIST_NOTES")
    @GetMapping(value={"/available-list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_CAN_USE_K8S_NAMESPACE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryAvailableNamespaceList(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        List<K8sNamespace> result = this.k8sNamespaceService.queryNamespaceAvailable(loginUser);
        return this.success(result);
    }
}

