/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.LoggerService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.ResponseTaskLog;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="LOGGER_TAG")
@RestController
@RequestMapping(value={"/log"})
public class LoggerController
extends BaseController {
    @Autowired
    private LoggerService loggerService;

    @Operation(summary="queryLog", description="QUERY_TASK_INSTANCE_LOG_NOTES")
    @Parameters(value={@Parameter(name="taskInstanceId", description="TASK_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="skipLineNum", description="SKIP_LINE_NUM", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="limit", description="LIMIT", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/detail"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_INSTANCE_LOG_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result<ResponseTaskLog> queryLog(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="taskInstanceId") int taskInstanceId, @RequestParam(value="skipLineNum") int skipNum, @RequestParam(value="limit") int limit) {
        return this.loggerService.queryLog(loginUser, taskInstanceId, skipNum, limit);
    }

    @Operation(summary="downloadTaskLog", description="DOWNLOAD_TASK_INSTANCE_LOG_NOTES")
    @Parameters(value={@Parameter(name="taskInstanceId", description="TASK_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/download-log"})
    @ResponseBody
    @ApiException(value=Status.DOWNLOAD_TASK_INSTANCE_LOG_FILE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public ResponseEntity downloadTaskLog(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="taskInstanceId") int taskInstanceId) {
        byte[] logBytes = this.loggerService.getLogBytes(loginUser, taskInstanceId);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + System.currentTimeMillis() + ".log\""})).body((Object)logBytes);
    }

    @Operation(summary="queryLogInSpecifiedProject", description="QUERY_TASK_INSTANCE_LOG_IN_SPECIFIED_PROJECT_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="taskInstanceId", description="TASK_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="skipLineNum", description="SKIP_LINE_NUM", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="limit", description="LIMIT", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/{projectCode}/detail"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_INSTANCE_LOG_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result<String> queryLog(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="taskInstanceId") int taskInstanceId, @RequestParam(value="skipLineNum") int skipNum, @RequestParam(value="limit") int limit) {
        return this.returnDataList(this.loggerService.queryLog(loginUser, projectCode, taskInstanceId, skipNum, limit));
    }

    @Operation(summary="downloadTaskLogInSpecifiedProject", description="DOWNLOAD_TASK_INSTANCE_LOG_IN_SPECIFIED_PROJECT_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="taskInstanceId", description="TASK_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/{projectCode}/download-log"})
    @ResponseBody
    @ApiException(value=Status.DOWNLOAD_TASK_INSTANCE_LOG_FILE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public ResponseEntity downloadTaskLog(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="taskInstanceId") int taskInstanceId) {
        byte[] logBytes = this.loggerService.getLogBytes(loginUser, projectCode, taskInstanceId);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + System.currentTimeMillis() + ".log\""})).body((Object)logBytes);
    }
}

