/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ProcessDefinitionService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.ProcessExecutionTypeEnum;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="PROCESS_DEFINITION_TAG")
@RestController
@RequestMapping(value={"projects/{projectCode}/process-definition"})
public class ProcessDefinitionController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessDefinitionController.class);
    @Autowired
    private ProcessDefinitionService processDefinitionService;

    @Operation(summary="createProcessDefinition", description="CREATE_PROCESS_DEFINITION_NOTES")
    @Parameters(value={@Parameter(name="name", description="PROCESS_DEFINITION_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="locations", description="PROCESS_DEFINITION_LOCATIONS", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="description", description="PROCESS_DEFINITION_DESC", required=false, schema=@Schema(implementation=String.class)), @Parameter(name="otherParamsJson", description="OTHER_PARAMS_JSON", required=false, schema=@Schema(implementation=String.class))})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_PROCESS_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createProcessDefinition(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="name", required=true) String name, @RequestParam(value="description", required=false) String description, @RequestParam(value="globalParams", required=false, defaultValue="[]") String globalParams, @RequestParam(value="locations", required=false) String locations, @RequestParam(value="timeout", required=false, defaultValue="0") int timeout, @RequestParam(value="taskRelationJson", required=true) String taskRelationJson, @RequestParam(value="taskDefinitionJson", required=true) String taskDefinitionJson, @RequestParam(value="otherParamsJson", required=false) String otherParamsJson, @RequestParam(value="executionType", defaultValue="PARALLEL") ProcessExecutionTypeEnum executionType) {
        Map<String, Object> result = this.processDefinitionService.createProcessDefinition(loginUser, projectCode, name, description, globalParams, locations, timeout, taskRelationJson, taskDefinitionJson, otherParamsJson, executionType);
        return this.returnDataList(result);
    }

    @Operation(summary="batchCopyByCodes", description="COPY_PROCESS_DEFINITION_NOTES")
    @Parameters(value={@Parameter(name="codes", description="PROCESS_DEFINITION_CODES", required=true, schema=@Schema(implementation=String.class, example="3,4")), @Parameter(name="targetProjectCode", description="TARGET_PROJECT_CODE", required=true, schema=@Schema(implementation=long.class, example="123"))})
    @PostMapping(value={"/batch-copy"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.BATCH_COPY_PROCESS_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result copyProcessDefinition(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="codes", required=true) String codes, @RequestParam(value="targetProjectCode", required=true) long targetProjectCode) {
        return this.returnDataList(this.processDefinitionService.batchCopyProcessDefinition(loginUser, projectCode, codes, targetProjectCode));
    }

    @Operation(summary="batchMoveByCodes", description="MOVE_PROCESS_DEFINITION_NOTES")
    @Parameters(value={@Parameter(name="codes", description="PROCESS_DEFINITION_CODES", required=true, schema=@Schema(implementation=String.class, example="3,4")), @Parameter(name="targetProjectCode", description="TARGET_PROJECT_CODE", required=true, schema=@Schema(implementation=long.class, example="123"))})
    @PostMapping(value={"/batch-move"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.BATCH_MOVE_PROCESS_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result moveProcessDefinition(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="codes", required=true) String codes, @RequestParam(value="targetProjectCode", required=true) long targetProjectCode) {
        return this.returnDataList(this.processDefinitionService.batchMoveProcessDefinition(loginUser, projectCode, codes, targetProjectCode));
    }

    @Operation(summary="verify-name", description="VERIFY_PROCESS_DEFINITION_NAME_NOTES")
    @Parameters(value={@Parameter(name="name", description="PROCESS_DEFINITION_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="code", description="PROCESS_DEFINITION_CODE", required=false, schema=@Schema(implementation=Long.class))})
    @GetMapping(value={"/verify-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_PROCESS_DEFINITION_NAME_UNIQUE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result verifyProcessDefinitionName(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="name", required=true) String name, @RequestParam(value="code", required=false, defaultValue="0") long processDefinitionCode) {
        Map<String, Object> result = this.processDefinitionService.verifyProcessDefinitionName(loginUser, projectCode, name, processDefinitionCode);
        return this.returnDataList(result);
    }

    @Operation(summary="update", description="UPDATE_PROCESS_DEFINITION_NOTES")
    @Parameters(value={@Parameter(name="name", description="PROCESS_DEFINITION_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="code", description="PROCESS_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="123456789")), @Parameter(name="locations", description="PROCESS_DEFINITION_LOCATIONS", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="description", description="PROCESS_DEFINITION_DESC", required=false, schema=@Schema(implementation=String.class)), @Parameter(name="releaseState", description="RELEASE_PROCESS_DEFINITION_NOTES", required=false, schema=@Schema(implementation=ReleaseState.class)), @Parameter(name="otherParamsJson", description="OTHER_PARAMS_JSON", required=false, schema=@Schema(implementation=String.class))})
    @PutMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_PROCESS_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateProcessDefinition(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="name", required=true) String name, @PathVariable(value="code", required=true) long code, @RequestParam(value="description", required=false) String description, @RequestParam(value="globalParams", required=false, defaultValue="[]") String globalParams, @RequestParam(value="locations", required=false) String locations, @RequestParam(value="timeout", required=false, defaultValue="0") int timeout, @RequestParam(value="taskRelationJson", required=true) String taskRelationJson, @RequestParam(value="taskDefinitionJson", required=true) String taskDefinitionJson, @RequestParam(value="otherParamsJson", required=false) String otherParamsJson, @RequestParam(value="executionType", defaultValue="PARALLEL") ProcessExecutionTypeEnum executionType, @RequestParam(value="releaseState", required=false, defaultValue="OFFLINE") ReleaseState releaseState) {
        Map<String, Object> result = this.processDefinitionService.updateProcessDefinition(loginUser, projectCode, name, code, description, globalParams, locations, timeout, taskRelationJson, taskDefinitionJson, otherParamsJson, executionType);
        if (result.get("status") != Status.SUCCESS) {
            return this.returnDataList(result);
        }
        if (releaseState == ReleaseState.ONLINE) {
            result = this.processDefinitionService.releaseProcessDefinition(loginUser, projectCode, code, releaseState);
        }
        return this.returnDataList(result);
    }

    @Operation(summary="queryVersions", description="QUERY_PROCESS_DEFINITION_VERSIONS_NOTES")
    @Parameters(value={@Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="10")), @Parameter(name="code", description="PROCESS_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="1"))})
    @GetMapping(value={"/{code}/versions"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_DEFINITION_VERSIONS_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryProcessDefinitionVersions(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize, @PathVariable(value="code") long code) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        result = this.processDefinitionService.queryProcessDefinitionVersions(loginUser, projectCode, pageNo, pageSize, code);
        return result;
    }

    @Operation(summary="switchVersion", description="SWITCH_PROCESS_DEFINITION_VERSION_NOTES")
    @Parameters(value={@Parameter(name="code", description="PROCESS_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="1")), @Parameter(name="version", description="VERSION", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/{code}/versions/{version}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.SWITCH_PROCESS_DEFINITION_VERSION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result switchProcessDefinitionVersion(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code, @PathVariable(value="version") int version) {
        Map<String, Object> result = this.processDefinitionService.switchProcessDefinitionVersion(loginUser, projectCode, code, version);
        return this.returnDataList(result);
    }

    @Operation(summary="deleteVersion", description="DELETE_PROCESS_DEFINITION_VERSION_NOTES")
    @Parameters(value={@Parameter(name="code", description="PROCESS_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="1")), @Parameter(name="version", description="VERSION", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @DeleteMapping(value={"/{code}/versions/{version}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_PROCESS_DEFINITION_VERSION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteProcessDefinitionVersion(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code, @PathVariable(value="version") int version) {
        Map<String, Object> result = this.processDefinitionService.deleteProcessDefinitionVersion(loginUser, projectCode, code, version);
        return this.returnDataList(result);
    }

    @Operation(summary="release", description="RELEASE_PROCESS_DEFINITION_NOTES")
    @Parameters(value={@Parameter(name="name", description="PROCESS_DEFINITION_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="code", description="PROCESS_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="123456789")), @Parameter(name="releaseState", description="PROCESS_DEFINITION_RELEASE", required=true, schema=@Schema(implementation=ReleaseState.class))})
    @PostMapping(value={"/{code}/release"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.RELEASE_PROCESS_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result releaseProcessDefinition(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code", required=true) long code, @RequestParam(value="releaseState", required=true) ReleaseState releaseState) {
        Map<String, Object> result = this.processDefinitionService.releaseProcessDefinition(loginUser, projectCode, code, releaseState);
        return this.returnDataList(result);
    }

    @Operation(summary="queryProcessDefinitionByCode", description="QUERY_PROCESS_DEFINITION_BY_CODE_NOTES")
    @Parameters(value={@Parameter(name="code", description="PROCESS_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="123456789"))})
    @GetMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DETAIL_OF_PROCESS_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryProcessDefinitionByCode(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code", required=true) long code) {
        Map<String, Object> result = this.processDefinitionService.queryProcessDefinitionByCode(loginUser, projectCode, code);
        return this.returnDataList(result);
    }

    @Operation(summary="queryProcessDefinitionByName", description="QUERY_PROCESS_DEFINITION_BY_NAME_NOTES")
    @Parameters(value={@Parameter(name="name", description="PROCESS_DEFINITION_NAME", required=true, schema=@Schema(implementation=String.class))})
    @GetMapping(value={"/query-by-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DETAIL_OF_PROCESS_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result<ProcessDefinition> queryProcessDefinitionByName(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="name") String name) {
        Map<String, Object> result = this.processDefinitionService.queryProcessDefinitionByName(loginUser, projectCode, name);
        return this.returnDataList(result);
    }

    @Operation(summary="queryList", description="QUERY_PROCESS_DEFINITION_LIST_NOTES")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_DEFINITION_LIST)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryProcessDefinitionList(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode) {
        Map<String, Object> result = this.processDefinitionService.queryProcessDefinitionList(loginUser, projectCode);
        return this.returnDataList(result);
    }

    @Operation(summary="querySimpleList", description="QUERY_PROCESS_DEFINITION_SIMPLE_LIST_NOTES")
    @GetMapping(value={"/simple-list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_DEFINITION_LIST)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryProcessDefinitionSimpleList(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode) {
        Map<String, Object> result = this.processDefinitionService.queryProcessDefinitionSimpleList(loginUser, projectCode);
        return this.returnDataList(result);
    }

    @Operation(summary="queryListPaging", description="QUERY_PROCESS_DEFINITION_LIST_PAGING_NOTES")
    @Parameters(value={@Parameter(name="searchVal", description="SEARCH_VAL", required=false, schema=@Schema(implementation=String.class)), @Parameter(name="userId", description="USER_ID", required=false, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="10")), @Parameter(name="otherParamsJson", description="OTHER_PARAMS_JSON", required=false, schema=@Schema(implementation=String.class))})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_DEFINITION_LIST_PAGING_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result<PageInfo<ProcessDefinition>> queryProcessDefinitionListPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="otherParamsJson", required=false) String otherParamsJson, @RequestParam(value="userId", required=false, defaultValue="0") Integer userId, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Result<PageInfo<ProcessDefinition>> result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        PageInfo<ProcessDefinition> pageInfo = this.processDefinitionService.queryProcessDefinitionListPaging(loginUser, projectCode, searchVal, otherParamsJson, userId, pageNo, pageSize);
        return Result.success(pageInfo);
    }

    @Operation(summary="viewTree", description="VIEW_TREE_NOTES")
    @Parameters(value={@Parameter(name="code", description="PROCESS_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="100")), @Parameter(name="limit", description="LIMIT", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/{code}/view-tree"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.ENCAPSULATION_TREEVIEW_STRUCTURE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result viewTree(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code, @RequestParam(value="limit") Integer limit) {
        Map<String, Object> result = this.processDefinitionService.viewTree(loginUser, projectCode, code, limit);
        return this.returnDataList(result);
    }

    @Operation(summary="getTasksByDefinitionCode", description="GET_TASK_LIST_BY_DEFINITION_CODE_NOTES")
    @Parameters(value={@Parameter(name="code", description="PROCESS_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="100"))})
    @GetMapping(value={"/{code}/tasks"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GET_TASKS_LIST_BY_PROCESS_DEFINITION_ID_ERROR)
    public Result getNodeListByDefinitionCode(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code) {
        Map<String, Object> result = this.processDefinitionService.getTaskNodeListByDefinitionCode(loginUser, projectCode, code);
        return this.returnDataList(result);
    }

    @Operation(summary="getTaskListByDefinitionCodes", description="GET_TASK_LIST_BY_DEFINITION_CODE_NOTES")
    @Parameters(value={@Parameter(name="codes", description="PROCESS_DEFINITION_CODES", required=true, schema=@Schema(implementation=String.class, example="100,200,300"))})
    @GetMapping(value={"/batch-query-tasks"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GET_TASKS_LIST_BY_PROCESS_DEFINITION_ID_ERROR)
    public Result getNodeListMapByDefinitionCodes(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="codes") String codes) {
        Map<String, Object> result = this.processDefinitionService.getNodeListMapByDefinitionCodes(loginUser, projectCode, codes);
        return this.returnDataList(result);
    }

    @Operation(summary="getProcessListByProjectCode", description="GET_PROCESS_LIST_BY_PROCESS_CODE_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=long.class, example="100"))})
    @GetMapping(value={"/query-process-definition-list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GET_TASKS_LIST_BY_PROCESS_DEFINITION_ID_ERROR)
    public Result getProcessListByProjectCode(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode) {
        Map<String, Object> result = this.processDefinitionService.queryProcessDefinitionListByProjectCode(projectCode);
        return this.returnDataList(result);
    }

    @Operation(summary="getTaskListByProcessDefinitionCode", description="GET_TASK_LIST_BY_PROCESS_CODE_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=long.class, example="100")), @Parameter(name="processDefinitionCode", description="PROCESS_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="100"))})
    @GetMapping(value={"/query-task-definition-list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GET_TASKS_LIST_BY_PROCESS_DEFINITION_ID_ERROR)
    public Result getTaskListByProcessDefinitionCode(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="processDefinitionCode") Long processDefinitionCode) {
        Map<String, Object> result = this.processDefinitionService.queryTaskDefinitionListByProcessDefinitionCode(projectCode, processDefinitionCode);
        return this.returnDataList(result);
    }

    @Operation(summary="deleteByCode", description="DELETE_PROCESS_DEFINITION_BY_ID_NOTES")
    @Parameters(value={@Parameter(name="code", description="PROCESS_DEFINITION_CODE", schema=@Schema(implementation=int.class, example="100"))})
    @DeleteMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_PROCESS_DEFINE_BY_CODE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteProcessDefinitionByCode(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long workflowDefinitionCode) {
        this.processDefinitionService.deleteProcessDefinitionByCode(loginUser, workflowDefinitionCode);
        return new Result(Status.SUCCESS);
    }

    @Operation(summary="batchDeleteByCodes", description="BATCH_DELETE_PROCESS_DEFINITION_BY_IDS_NOTES")
    @Parameters(value={@Parameter(name="codes", description="PROCESS_DEFINITION_CODE", required=true, schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/batch-delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.BATCH_DELETE_PROCESS_DEFINE_BY_CODES_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result batchDeleteProcessDefinitionByCodes(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="codes") String codes) {
        Map<String, Object> result = this.processDefinitionService.batchDeleteProcessDefinitionByCodes(loginUser, projectCode, codes);
        return this.returnDataList(result);
    }

    @Operation(summary="batchExportByCodes", description="BATCH_EXPORT_PROCESS_DEFINITION_BY_CODES_NOTES")
    @Parameters(value={@Parameter(name="codes", description="PROCESS_DEFINITION_CODE", required=true, schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/batch-export"})
    @ResponseBody
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser", "response"})
    public void batchExportProcessDefinitionByCodes(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="codes") String codes, HttpServletResponse response) {
        try {
            this.processDefinitionService.batchExportProcessDefinitionByCodes(loginUser, projectCode, codes, response);
        }
        catch (Exception e) {
            log.error(Status.BATCH_EXPORT_PROCESS_DEFINE_BY_IDS_ERROR.getMsg(), (Throwable)e);
        }
    }

    @Operation(summary="queryAllByProjectCode", description="QUERY_PROCESS_DEFINITION_All_BY_PROJECT_CODE_NOTES")
    @GetMapping(value={"/all"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_DEFINITION_LIST)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryAllProcessDefinitionByProjectCode(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode) {
        Map<String, Object> result = this.processDefinitionService.queryAllProcessDefinitionByProjectCode(loginUser, projectCode);
        return this.returnDataList(result);
    }

    @Operation(summary="importProcessDefinition", description="IMPORT_PROCESS_DEFINITION_NOTES")
    @Parameters(value={@Parameter(name="file", description="RESOURCE_FILE", required=true, schema=@Schema(implementation=MultipartFile.class))})
    @PostMapping(value={"/import"})
    @ApiException(value=Status.IMPORT_PROCESS_DEFINE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser", "file"})
    public Result importProcessDefinition(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="file") MultipartFile file) {
        Map<String, Object> result = "application/zip".equals(file.getContentType()) ? this.processDefinitionService.importSqlProcessDefinition(loginUser, projectCode, file) : this.processDefinitionService.importProcessDefinition(loginUser, projectCode, file);
        return this.returnDataList(result);
    }

    @Operation(summary="createEmptyProcessDefinition", description="CREATE_EMPTY_PROCESS_NOTES")
    @Parameters(value={@Parameter(name="name", description="PROCESS_DEFINITION_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=long.class, example="123456789")), @Parameter(name="description", description="PROCESS_DEFINITION_DESC", required=false, schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/empty"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.CREATE_PROCESS_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createEmptyProcessDefinition(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="name", required=true) String name, @RequestParam(value="description", required=false) String description, @RequestParam(value="globalParams", required=false, defaultValue="[]") String globalParams, @RequestParam(value="timeout", required=false, defaultValue="0") int timeout, @RequestParam(value="scheduleJson", required=false) String scheduleJson, @RequestParam(value="executionType", defaultValue="PARALLEL") ProcessExecutionTypeEnum executionType) {
        return this.returnDataList(this.processDefinitionService.createEmptyProcessDefinition(loginUser, projectCode, name, description, globalParams, timeout, scheduleJson, executionType));
    }

    @Operation(summary="updateBasicInfo", description="UPDATE_PROCESS_DEFINITION_BASIC_INFO_NOTES")
    @Parameters(value={@Parameter(name="name", description="PROCESS_DEFINITION_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="code", description="PROCESS_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="123456789")), @Parameter(name="description", description="PROCESS_DEFINITION_DESC", required=false, schema=@Schema(implementation=String.class)), @Parameter(name="releaseState", description="RELEASE_PROCESS_DEFINITION_NOTES", required=false, schema=@Schema(implementation=ReleaseState.class)), @Parameter(name="otherParamsJson", description="OTHER_PARAMS_JSON", required=false, schema=@Schema(implementation=String.class))})
    @PutMapping(value={"/{code}/basic-info"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_PROCESS_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateProcessDefinitionBasicInfo(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="name", required=true) String name, @PathVariable(value="code", required=true) long code, @RequestParam(value="description", required=false) String description, @RequestParam(value="globalParams", required=false, defaultValue="[]") String globalParams, @RequestParam(value="timeout", required=false, defaultValue="0") int timeout, @RequestParam(value="scheduleJson", required=false) String scheduleJson, @RequestParam(value="otherParamsJson", required=false) String otherParamsJson, @RequestParam(value="executionType", defaultValue="PARALLEL") ProcessExecutionTypeEnum executionType, @RequestParam(value="releaseState", required=false, defaultValue="OFFLINE") ReleaseState releaseState) {
        Map<String, Object> result = this.processDefinitionService.updateProcessDefinitionBasicInfo(loginUser, projectCode, name, code, description, globalParams, timeout, scheduleJson, otherParamsJson, executionType);
        if (result.get("status") != Status.SUCCESS) {
            return this.returnDataList(result);
        }
        if (releaseState == ReleaseState.ONLINE) {
            result = this.processDefinitionService.releaseWorkflowAndSchedule(loginUser, projectCode, code, releaseState);
        }
        return this.returnDataList(result);
    }

    @Operation(summary="releaseWorkflowAndSchedule", description="RELEASE_WORKFLOW_SCHEDULE_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROCESS_DEFINITION_NAME", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="code", description="PROCESS_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="123456789")), @Parameter(name="releaseState", description="RELEASE_PROCESS_DEFINITION_NOTES", required=true, schema=@Schema(implementation=ReleaseState.class))})
    @PostMapping(value={"/{code}/release-workflow"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.RELEASE_PROCESS_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result releaseWorkflowAndSchedule(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code", required=true) long code, @RequestParam(value="releaseState", required=true, defaultValue="OFFLINE") ReleaseState releaseState) {
        return this.returnDataList(this.processDefinitionService.releaseWorkflowAndSchedule(loginUser, projectCode, code, releaseState));
    }

    @Operation(summary="viewVariables", description="QUERY_PROCESS_DEFINITION_GLOBAL_VARIABLES_AND_LOCAL_VARIABLES_NOTES")
    @Parameters(value={@Parameter(name="code", description="PROCESS_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="100"))})
    @GetMapping(value={"/{code}/view-variables"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_DEFINITION_ALL_VARIABLES_ERROR)
    @AccessLogAnnotation
    public Result viewVariables(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") Long code) {
        Map<String, Object> result = this.processDefinitionService.viewVariables(loginUser, projectCode, code);
        return this.returnDataList(result);
    }
}

