/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.dto.DynamicSubWorkflowDto;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ProcessInstanceService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="PROCESS_INSTANCE_TAG")
@RestController
@RequestMapping(value={"/projects/{projectCode}/process-instances"})
public class ProcessInstanceController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessInstanceController.class);
    @Autowired
    private ProcessInstanceService processInstanceService;

    @Operation(summary="queryProcessInstanceListPaging", description="QUERY_PROCESS_INSTANCE_LIST_NOTES")
    @Parameters(value={@Parameter(name="processDefineCode", description="PROCESS_DEFINITION_CODE", schema=@Schema(implementation=long.class, example="100")), @Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class)), @Parameter(name="executorName", description="EXECUTOR_NAME", schema=@Schema(implementation=String.class)), @Parameter(name="stateType", description="EXECUTION_STATUS", schema=@Schema(implementation=WorkflowExecutionStatus.class)), @Parameter(name="host", description="HOST", schema=@Schema(implementation=String.class)), @Parameter(name="startDate", description="START_DATE", schema=@Schema(implementation=String.class)), @Parameter(name="endDate", description="END_DATE", schema=@Schema(implementation=String.class)), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="10"))})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_INSTANCE_LIST_PAGING_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryProcessInstanceList(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="processDefineCode", required=false, defaultValue="0") long processDefineCode, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="executorName", required=false) String executorName, @RequestParam(value="stateType", required=false) WorkflowExecutionStatus stateType, @RequestParam(value="host", required=false) String host, @RequestParam(value="startDate", required=false) String startTime, @RequestParam(value="endDate", required=false) String endTime, @RequestParam(value="otherParamsJson", required=false) String otherParamsJson, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Result<Object> result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        result = this.processInstanceService.queryProcessInstanceList(loginUser, projectCode, processDefineCode, startTime, endTime, searchVal, executorName, stateType, host, otherParamsJson, pageNo, pageSize);
        return result;
    }

    @Operation(summary="queryTaskListByProcessId", description="QUERY_TASK_LIST_BY_PROCESS_INSTANCE_ID_NOTES")
    @Parameters(value={@Parameter(name="id", description="PROCESS_INSTANCE_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/{id}/tasks"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_LIST_BY_PROCESS_INSTANCE_ID_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryTaskListByProcessId(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) throws IOException {
        Map<String, Object> result = this.processInstanceService.queryTaskListByProcessId(loginUser, projectCode, id);
        return this.returnDataList(result);
    }

    @Operation(summary="updateProcessInstance", description="UPDATE_PROCESS_INSTANCE_NOTES")
    @Parameters(value={@Parameter(name="taskRelationJson", description="TASK_RELATION_JSON", schema=@Schema(implementation=String.class)), @Parameter(name="taskDefinitionJson", description="TASK_DEFINITION_JSON", schema=@Schema(implementation=String.class)), @Parameter(name="id", description="PROCESS_INSTANCE_ID", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="scheduleTime", description="SCHEDULE_TIME", schema=@Schema(implementation=String.class)), @Parameter(name="syncDefine", description="SYNC_DEFINE", required=true, schema=@Schema(implementation=boolean.class, example="false")), @Parameter(name="globalParams", description="PROCESS_GLOBAL_PARAMS", schema=@Schema(implementation=String.class, example="[]")), @Parameter(name="locations", description="PROCESS_INSTANCE_LOCATIONS", schema=@Schema(implementation=String.class)), @Parameter(name="timeout", description="PROCESS_TIMEOUT", schema=@Schema(implementation=int.class, example="0"))})
    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_PROCESS_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateProcessInstance(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="taskRelationJson", required=true) String taskRelationJson, @RequestParam(value="taskDefinitionJson", required=true) String taskDefinitionJson, @PathVariable(value="id") Integer id, @RequestParam(value="scheduleTime", required=false) String scheduleTime, @RequestParam(value="syncDefine", required=true) Boolean syncDefine, @RequestParam(value="globalParams", required=false, defaultValue="[]") String globalParams, @RequestParam(value="locations", required=false) String locations, @RequestParam(value="timeout", required=false, defaultValue="0") int timeout) {
        Map<String, Object> result = this.processInstanceService.updateProcessInstance(loginUser, projectCode, id, taskRelationJson, taskDefinitionJson, scheduleTime, syncDefine, globalParams, locations, timeout);
        return this.returnDataList(result);
    }

    @Operation(summary="queryProcessInstanceById", description="QUERY_PROCESS_INSTANCE_BY_ID_NOTES")
    @Parameters(value={@Parameter(name="id", description="PROCESS_INSTANCE_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_INSTANCE_BY_ID_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryProcessInstanceById(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) {
        Map<String, Object> result = this.processInstanceService.queryProcessInstanceById(loginUser, projectCode, id);
        return this.returnDataList(result);
    }

    @Operation(summary="queryTopNLongestRunningProcessInstance", description="QUERY_TOPN_LONGEST_RUNNING_PROCESS_INSTANCE_NOTES")
    @Parameters(value={@Parameter(name="size", description="PROCESS_INSTANCE_SIZE", required=true, schema=@Schema(implementation=int.class, example="10")), @Parameter(name="startTime", description="PROCESS_INSTANCE_START_TIME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="endTime", description="PROCESS_INSTANCE_END_TIME", required=true, schema=@Schema(implementation=String.class))})
    @GetMapping(value={"/top-n"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_INSTANCE_BY_ID_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result<ProcessInstance> queryTopNLongestRunningProcessInstance(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="size") Integer size, @RequestParam(value="startTime", required=true) String startTime, @RequestParam(value="endTime", required=true) String endTime) {
        Map<String, Object> result = this.processInstanceService.queryTopNLongestRunningProcessInstance(loginUser, projectCode, size, startTime, endTime);
        return this.returnDataList(result);
    }

    @Operation(summary="deleteProcessInstanceById", description="DELETE_PROCESS_INSTANCE_BY_ID_NOTES")
    @Parameters(value={@Parameter(name="id", description="PROCESS_INSTANCE_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_PROCESS_INSTANCE_BY_ID_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result<Void> deleteProcessInstanceById(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) {
        this.processInstanceService.deleteProcessInstanceById(loginUser, id);
        return Result.success();
    }

    @Operation(summary="querySubProcessInstanceByTaskCode", description="QUERY_SUBPROCESS_INSTANCE_BY_TASK_CODE_NOTES")
    @Parameters(value={@Parameter(name="taskCode", description="TASK_CODE", required=true, schema=@Schema(implementation=long.class, example="100"))})
    @GetMapping(value={"/query-sub-by-parent"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_SUB_PROCESS_INSTANCE_DETAIL_INFO_BY_TASK_ID_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result querySubProcessInstanceByTaskId(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="taskId") Integer taskId) {
        Map<String, Object> result = this.processInstanceService.querySubProcessInstanceByTaskId(loginUser, projectCode, taskId);
        return this.returnDataList(result);
    }

    @Operation(summary="queryParentInstanceBySubId", description="QUERY_PARENT_PROCESS_INSTANCE_BY_SUB_PROCESS_INSTANCE_ID_NOTES")
    @Parameters(value={@Parameter(name="subId", description="SUB_PROCESS_INSTANCE_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/query-parent-by-sub"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PARENT_PROCESS_INSTANCE_DETAIL_INFO_BY_SUB_PROCESS_INSTANCE_ID_ERROR)
    @AccessLogAnnotation
    public Result queryParentInstanceBySubId(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="subId") Integer subId) {
        Map<String, Object> result = this.processInstanceService.queryParentInstanceBySubId(loginUser, projectCode, subId);
        return this.returnDataList(result);
    }

    @Operation(summary="queryDynamicSubWorkflowInstances", description="QUERY_DYNAMIC_SUBPROCESS_INSTANCE_BY_TASK_CODE_NOTES")
    @Parameters(value={@Parameter(name="taskId", description="taskInstanceId", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/query-dynamic-sub-workflows"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_SUB_PROCESS_INSTANCE_DETAIL_INFO_BY_TASK_ID_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result<List<DynamicSubWorkflowDto>> queryDynamicSubWorkflowInstances(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="taskId") Integer taskId) {
        List<DynamicSubWorkflowDto> dynamicSubWorkflowDtos = this.processInstanceService.queryDynamicSubWorkflowInstances(loginUser, taskId);
        return new Result<List<DynamicSubWorkflowDto>>(Status.SUCCESS.getCode(), Status.SUCCESS.getMsg(), dynamicSubWorkflowDtos);
    }

    @Operation(summary="viewVariables", description="QUERY_PROCESS_INSTANCE_GLOBAL_VARIABLES_AND_LOCAL_VARIABLES_NOTES")
    @Parameters(value={@Parameter(name="id", description="PROCESS_INSTANCE_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/{id}/view-variables"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_INSTANCE_ALL_VARIABLES_ERROR)
    @AccessLogAnnotation
    public Result viewVariables(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) {
        Map<String, Object> result = this.processInstanceService.viewVariables(projectCode, id);
        return this.returnDataList(result);
    }

    @Operation(summary="vieGanttTree", description="VIEW_GANTT_NOTES")
    @Parameters(value={@Parameter(name="id", description="PROCESS_INSTANCE_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/{id}/view-gantt"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.ENCAPSULATION_PROCESS_INSTANCE_GANTT_STRUCTURE_ERROR)
    @AccessLogAnnotation
    public Result viewTree(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) throws Exception {
        Map<String, Object> result = this.processInstanceService.viewGantt(projectCode, id);
        return this.returnDataList(result);
    }

    @Operation(summary="batchDeleteProcessInstanceByIds", description="BATCH_DELETE_PROCESS_INSTANCE_BY_IDS_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=int.class)), @Parameter(name="processInstanceIds", description="PROCESS_INSTANCE_IDS", required=true, schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/batch-delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.BATCH_DELETE_PROCESS_INSTANCE_BY_IDS_ERROR)
    @AccessLogAnnotation
    public Result batchDeleteProcessInstanceByIds(@RequestAttribute(value="session.user") User loginUser, @PathVariable long projectCode, @RequestParam(value="processInstanceIds") String processInstanceIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> deleteFailedIdList = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)processInstanceIds)) {
            String[] processInstanceIdArray;
            for (String strProcessInstanceId : processInstanceIdArray = processInstanceIds.split(",")) {
                int processInstanceId = Integer.parseInt(strProcessInstanceId);
                try {
                    this.processInstanceService.deleteProcessInstanceById(loginUser, processInstanceId);
                }
                catch (Exception e) {
                    log.error("Delete workflow instance: {} error", (Object)strProcessInstanceId, (Object)e);
                    deleteFailedIdList.add(MessageFormat.format(Status.PROCESS_INSTANCE_ERROR.getMsg(), strProcessInstanceId));
                }
            }
        }
        if (!deleteFailedIdList.isEmpty()) {
            this.putMsg(result, Status.BATCH_DELETE_PROCESS_INSTANCE_BY_IDS_ERROR, String.join((CharSequence)"\n", deleteFailedIdList));
        } else {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return this.returnDataList(result);
    }

    @Operation(summary="queryProcessInstanceListByTrigger", description="QUERY_PROCESS_INSTANCE_BY_TRIGGER_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=Long.class)), @Parameter(name="triggerCode", description="TRIGGER_CODE", required=true, schema=@Schema(implementation=Long.class))})
    @GetMapping(value={"/trigger"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_INSTANCE_LIST_PAGING_ERROR)
    @AccessLogAnnotation
    public Result queryProcessInstancesByTriggerCode(@RequestAttribute(value="session.user") User loginUser, @PathVariable long projectCode, @RequestParam(value="triggerCode") Long triggerCode) {
        Map<String, Object> result = this.processInstanceService.queryByTriggerCode(loginUser, projectCode, triggerCode);
        return this.returnDataList(result);
    }
}

