/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.QueueService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="QUEUE_TAG")
@RestController
@RequestMapping(value={"/queues"})
public class QueueController
extends BaseController {
    @Autowired
    private QueueService queueService;

    @Operation(summary="queryList", description="QUERY_QUEUE_LIST_NOTES")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_QUEUE_LIST_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryList(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        return this.queueService.queryList(loginUser);
    }

    @Operation(summary="queryQueueListPaging", description="QUERY_QUEUE_LIST_PAGING_NOTES")
    @Parameters(value={@Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class)), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="20"))})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_QUEUE_LIST_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryQueueListPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        result = this.queueService.queryList(loginUser, searchVal, pageNo, pageSize);
        return result;
    }

    @Operation(summary="createQueue", description="CREATE_QUEUE_NOTES")
    @Parameters(value={@Parameter(name="queue", description="YARN_QUEUE_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="queueName", description="QUEUE_NAME", required=true, schema=@Schema(implementation=String.class))})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_QUEUE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createQueue(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="queue") String queue, @RequestParam(value="queueName") String queueName) {
        return this.queueService.createQueue(loginUser, queue, queueName);
    }

    @Operation(summary="updateQueue", description="UPDATE_QUEUE_NOTES")
    @Parameters(value={@Parameter(name="id", description="QUEUE_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="queue", description="YARN_QUEUE_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="queueName", description="QUEUE_NAME", required=true, schema=@Schema(implementation=String.class))})
    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.UPDATE_QUEUE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateQueue(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id, @RequestParam(value="queue") String queue, @RequestParam(value="queueName") String queueName) {
        return this.queueService.updateQueue(loginUser, id, queue, queueName);
    }

    @Operation(summary="deleteQueueById", description="DELETE_QUEUE_NOTES")
    @Parameters(value={@Parameter(name="id", description="QUEUE_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_QUEUE_BY_ID_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteQueueById(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id) throws Exception {
        Map<String, Object> result = this.queueService.deleteQueueById(loginUser, id);
        return this.returnDataList(result);
    }

    @Operation(summary="verifyQueue", description="VERIFY_QUEUE_NOTES")
    @Parameters(value={@Parameter(name="queue", description="YARN_QUEUE_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="queueName", description="QUEUE_NAME", required=true, schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/verify"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_QUEUE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result verifyQueue(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="queue") String queue, @RequestParam(value="queueName") String queueName) {
        return this.queueService.verifyQueue(queue, queueName);
    }
}

