/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.TaskGroupQueueService;
import org.apache.dolphinscheduler.api.service.TaskGroupService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="TASK_GROUP_TAG")
@RestController
@RequestMapping(value={"/task-group"})
public class TaskGroupController
extends BaseController {
    @Autowired
    private TaskGroupService taskGroupService;
    @Autowired
    private TaskGroupQueueService taskGroupQueueService;

    @Operation(summary="create", description="CREATE_TASK_GROUP_NOTE")
    @Parameters(value={@Parameter(name="name", description="NAME", schema=@Schema(implementation=String.class)), @Parameter(name="projectCode", description="PROJECT_CODE", schema=@Schema(implementation=long.class)), @Parameter(name="description", description="TASK_GROUP_DESCRIPTION", schema=@Schema(implementation=String.class)), @Parameter(name="groupSize", description="GROUP_SIZE", schema=@Schema(implementation=int.class))})
    @PostMapping(value={"/create"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_TASK_GROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createTaskGroup(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="name") String name, @RequestParam(value="projectCode", required=false, defaultValue="0") Long projectcode, @RequestParam(value="description") String description, @RequestParam(value="groupSize") Integer groupSize) {
        Map<String, Object> result = this.taskGroupService.createTaskGroup(loginUser, projectcode, name, description, groupSize);
        return this.returnDataList(result);
    }

    @Operation(summary="update", description="UPDATE_TASK_GROUP_NOTE")
    @Parameters(value={@Parameter(name="id", description="TASK_GROUP_ID", schema=@Schema(implementation=int.class)), @Parameter(name="name", description="TASK_GROUP_NAME", schema=@Schema(implementation=String.class)), @Parameter(name="description", description="TASK_GROUP_DESCRIPTION", schema=@Schema(implementation=String.class)), @Parameter(name="groupSize", description="GROUP_SIZE", schema=@Schema(implementation=int.class))})
    @PostMapping(value={"/update"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.UPDATE_TASK_GROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateTaskGroup(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") Integer id, @RequestParam(value="name") String name, @RequestParam(value="description") String description, @RequestParam(value="groupSize") Integer groupSize) {
        Map<String, Object> result = this.taskGroupService.updateTaskGroup(loginUser, id, name, description, groupSize);
        return this.returnDataList(result);
    }

    @Operation(summary="list-paging", description="QUERY_ALL_TASK_GROUP_NOTES")
    @Parameters(value={@Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="name", description="TASK_GROUP_NAME", required=false, schema=@Schema(implementation=String.class)), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="20"))})
    @GetMapping(value={"/list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_GROUP_LIST_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryAllTaskGroup(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="name", required=false) String name, @RequestParam(value="status", required=false) Integer status, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Map<String, Object> result = this.taskGroupService.queryAllTaskGroup(loginUser, name, status, pageNo, pageSize);
        return this.returnDataList(result);
    }

    @Operation(summary="queryTaskGroupByStatus", description="QUERY_TASK_GROUP_LIST_BY_STATUS_NOTES")
    @Parameters(value={@Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="20")), @Parameter(name="status", description="TASK_GROUP_STATUS", required=true, schema=@Schema(implementation=int.class))})
    @GetMapping(value={"/query-list-by-status"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_GROUP_LIST_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryTaskGroupByStatus(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="status", required=false) Integer status, @RequestParam(value="pageSize") Integer pageSize) {
        Map<String, Object> result = this.taskGroupService.queryTaskGroupByStatus(loginUser, pageNo, pageSize, status);
        return this.returnDataList(result);
    }

    @Operation(summary="queryTaskGroupByName", description="QUERY_TASK_GROUP_LIST_BY_PROJECT_ID_NOTES")
    @Parameters(value={@Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="20")), @Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=String.class))})
    @GetMapping(value={"/query-list-by-projectCode"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_GROUP_LIST_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryTaskGroupByCode(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="projectCode", required=false) Long projectCode, @RequestParam(value="pageSize") Integer pageSize) {
        Map<String, Object> result = this.taskGroupService.queryTaskGroupByProjectCode(loginUser, pageNo, pageSize, projectCode);
        return this.returnDataList(result);
    }

    @Operation(summary="closeTaskGroup", description="CLOSE_TASK_GROUP_NOTES")
    @Parameters(value={@Parameter(name="id", description="ID", required=true, schema=@Schema(implementation=int.class))})
    @PostMapping(value={"/close-task-group"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CLOSE_TASK_GROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result closeTaskGroup(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id", required=false) Integer id) {
        Map<String, Object> result = this.taskGroupService.closeTaskGroup(loginUser, id);
        return this.returnDataList(result);
    }

    @Operation(summary="startTaskGroup", description="START_TASK_GROUP_NOTES")
    @Parameters(value={@Parameter(name="id", description="TASK_GROUP_ID", required=true, schema=@Schema(implementation=int.class))})
    @PostMapping(value={"/start-task-group"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.START_TASK_GROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result startTaskGroup(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id", required=false) Integer id) {
        Map<String, Object> result = this.taskGroupService.startTaskGroup(loginUser, id);
        return this.returnDataList(result);
    }

    @Operation(summary="forceStart", description="FORCE_START_TASK_GROUP")
    @Parameters(value={@Parameter(name="queueId", description="TASK_GROUP_QUEUE_ID", required=true, schema=@Schema(implementation=int.class))})
    @PostMapping(value={"/forceStart"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.START_TASK_GROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result forceStart(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="queueId") Integer queueId) {
        Map<String, Object> result = this.taskGroupService.forceStartTask(loginUser, queueId);
        return this.returnDataList(result);
    }

    @Operation(summary="modifyPriority", description="MODIFY_TASK_GROUP_PRIORITY")
    @Parameters(value={@Parameter(name="queueId", description="TASK_GROUP_QUEUE_ID", required=true, schema=@Schema(implementation=int.class)), @Parameter(name="priority", description="TASK_GROUP_QUEUE_PRIORITY", required=true, schema=@Schema(implementation=int.class))})
    @PostMapping(value={"/modifyPriority"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.START_TASK_GROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result modifyPriority(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="queueId") Integer queueId, @RequestParam(value="priority") Integer priority) {
        Map<String, Object> result = this.taskGroupService.modifyPriority(loginUser, queueId, priority);
        return this.returnDataList(result);
    }

    @Operation(summary="queryTasksByGroupId", description="QUERY_ALL_TASKS_GROUP_NOTES")
    @Parameters(value={@Parameter(name="groupId", description="GROUP_ID", required=false, schema=@Schema(implementation=int.class, example="1", defaultValue="-1")), @Parameter(name="taskInstanceName", description="TASK_INSTANCE_NAME", required=false, schema=@Schema(implementation=String.class, example="taskName")), @Parameter(name="processInstanceName", description="PROCESS_INSTANCE_NAME", required=false, schema=@Schema(implementation=String.class, example="processName")), @Parameter(name="status", description="TASK_GROUP_STATUS", required=false, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="20"))})
    @GetMapping(value={"/query-list-by-group-id"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_GROUP_QUEUE_LIST_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryTasksByGroupId(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="groupId", required=false, defaultValue="-1") Integer groupId, @RequestParam(value="taskInstanceName", required=false) String taskName, @RequestParam(value="processInstanceName", required=false) String processName, @RequestParam(value="status", required=false) Integer status, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Map<String, Object> result = this.taskGroupQueueService.queryTasksByGroupId(loginUser, taskName, processName, status, groupId, pageNo, pageSize);
        return this.returnDataList(result);
    }
}

