/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.UiPluginService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.PluginType;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="UI_PLUGINS_TAG")
@RestController
@RequestMapping(value={"ui-plugins"})
public class UiPluginController
extends BaseController {
    @Autowired
    UiPluginService uiPluginService;

    @Operation(summary="queryUiPluginsByType", description="QUERY_UI_PLUGINS_BY_TYPE")
    @Parameters(value={@Parameter(name="pluginType", description="pluginType", required=true, schema=@Schema(implementation=PluginType.class))})
    @GetMapping(value={"/query-by-type"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.QUERY_PLUGINS_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryUiPluginsByType(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pluginType") PluginType pluginType) {
        Map<String, Object> result = this.uiPluginService.queryUiPluginsByType(pluginType);
        return this.returnDataList(result);
    }

    @Operation(summary="queryUiPluginDetailById", description="QUERY_UI_PLUGIN_DETAIL_BY_ID")
    @Parameters(value={@Parameter(name="id", description="PLUGIN_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.QUERY_PLUGINS_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryUiPluginDetailById(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") Integer pluginId) {
        Map<String, Object> result = this.uiPluginService.queryUiPluginDetailById(pluginId);
        return this.returnDataList(result);
    }
}

