/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller.v2;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.dto.CreateTokenRequest;
import org.apache.dolphinscheduler.api.dto.CreateTokenResponse;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.AccessTokenService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="ACCESS_TOKEN_TAG")
@RestController
@RequestMapping(value={"/v2/access-tokens"})
public class AccessTokenV2Controller
extends BaseController {
    @Autowired
    private AccessTokenService accessTokenService;

    @Operation(summary="createTokenV2", description="CREATE_TOKEN_V2")
    @PostMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Parameter(name="createTokenRequest", description="createTokenRequest", required=true, schema=@Schema(implementation=CreateTokenRequest.class))
    @ApiException(value=Status.CREATE_ACCESS_TOKEN_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public CreateTokenResponse createToken(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestBody CreateTokenRequest createTokenRequest) {
        Result result = this.accessTokenService.createToken(loginUser, createTokenRequest.getUserId(), createTokenRequest.getExpireTime(), createTokenRequest.getToken());
        return new CreateTokenResponse(result);
    }
}

