/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller.v2;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.dto.project.StatisticsStateRequest;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.DataAnalysisService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="STATISTICS_V2")
@RestController
@RequestMapping(value={"/v2/statistics"})
public class StatisticsV2Controller
extends BaseController {
    @Autowired
    private DataAnalysisService dataAnalysisService;

    @Operation(summary="queryAllWorkflowCount", description="QUERY_ALL_WORKFLOW_COUNT")
    @GetMapping(value={"/workflows/count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ALL_WORKFLOW_COUNT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryWorkflowInstanceCounts(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        Map<String, Object> result = this.dataAnalysisService.queryAllWorkflowCounts(loginUser);
        return this.returnDataList(result);
    }

    @Operation(summary="queryAllWorkflowStatesCount", description="QUERY_ALL_WORKFLOW_STATES_COUNT")
    @GetMapping(value={"/workflows/states/count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_WORKFLOW_STATES_COUNT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryWorkflowStatesCounts(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestBody(required=false) StatisticsStateRequest statisticsStateRequest) {
        Map<String, Object> result = this.dataAnalysisService.countWorkflowStates(loginUser, statisticsStateRequest);
        return this.returnDataList(result);
    }

    @Operation(summary="queryOneWorkflowStatesCount", description="QUERY_One_WORKFLOW_STATES_COUNT")
    @GetMapping(value={"/{workflowCode}/states/count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ONE_WORKFLOW_STATE_COUNT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryOneWorkflowStates(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="workflowCode") Long workflowCode) {
        Map<String, Object> result = this.dataAnalysisService.countOneWorkflowStates(loginUser, workflowCode);
        return this.returnDataList(result);
    }

    @Operation(summary="queryAllTaskStatesCount", description="QUERY_ALL_TASK_STATES_COUNT")
    @GetMapping(value={"/tasks/states/count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_STATES_COUNT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryTaskStatesCounts(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestBody(required=false) StatisticsStateRequest statisticsStateRequest) {
        Map<String, Object> result = this.dataAnalysisService.countTaskStates(loginUser, statisticsStateRequest);
        return this.returnDataList(result);
    }

    @Operation(summary="queryOneTaskStatesCount", description="QUERY_ONE_TASK_STATES_COUNT")
    @GetMapping(value={"/tasks/{taskCode}/states/count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ONE_TASK_STATES_COUNT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryOneTaskStatesCounts(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="taskCode") Long taskCode) {
        Map<String, Object> result = this.dataAnalysisService.countOneTaskStates(loginUser, taskCode);
        return this.returnDataList(result);
    }

    @Operation(summary="countDefinitionV2ByUserId", description="COUNT_PROCESS_DEFINITION_V2_BY_USERID_NOTES")
    @GetMapping(value={"/workflows/users/count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.COUNT_PROCESS_DEFINITION_USER_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result countDefinitionByUser(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestBody(required=false) StatisticsStateRequest statisticsStateRequest) {
        String projectName = statisticsStateRequest.getProjectName();
        Long projectCode = statisticsStateRequest.getProjectCode();
        if (null == projectCode && !StringUtils.isBlank((CharSequence)projectName)) {
            projectCode = this.dataAnalysisService.getProjectCodeByName(projectName);
        }
        Map<String, Object> result = this.dataAnalysisService.countDefinitionByUserV2(loginUser, projectCode, null, null);
        return this.returnDataList(result);
    }

    @Operation(summary="countDefinitionV2ByUser", description="COUNT_PROCESS_DEFINITION_V2_BY_USER_NOTES")
    @GetMapping(value={"/workflows/users/{userId}/count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.COUNT_PROCESS_DEFINITION_USER_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result countDefinitionByUserId(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="userId") Integer userId) {
        Map<String, Object> result = this.dataAnalysisService.countDefinitionByUserV2(loginUser, null, userId, null);
        return this.returnDataList(result);
    }

    @Operation(summary="countDefinitionV2ByUser", description="COUNT_PROCESS_DEFINITION_V2_BY_USER_NOTES")
    @GetMapping(value={"/workflows/users/{userId}/{releaseState}/count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.COUNT_PROCESS_DEFINITION_USER_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result countDefinitionByUserState(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="userId") Integer userId, @PathVariable(value="releaseState") Integer releaseState) {
        Map<String, Object> result = this.dataAnalysisService.countDefinitionByUserV2(loginUser, null, userId, releaseState);
        return this.returnDataList(result);
    }
}

