/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller.v2;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.dto.task.TaskCreateRequest;
import org.apache.dolphinscheduler.api.dto.task.TaskFilterRequest;
import org.apache.dolphinscheduler.api.dto.task.TaskUpdateRequest;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.TaskDefinitionService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="TASK_DEFINITION_TAG")
@RestController
@RequestMapping(value={"v2/tasks"})
public class TaskDefinitionV2Controller
extends BaseController {
    @Autowired
    private TaskDefinitionService taskDefinitionService;

    @Operation(summary="create", description="CREATE_TASK_DEFINITION_NOTES")
    @PostMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_TASK_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result<TaskDefinition> createTaskDefinition(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestBody TaskCreateRequest taskCreateRequest) {
        TaskDefinition taskDefinition = this.taskDefinitionService.createTaskDefinitionV2(loginUser, taskCreateRequest);
        return Result.success(taskDefinition);
    }

    @Operation(summary="delete", description="DELETE_TASK_DEFINITION_VERSION_NOTES")
    @Parameters(value={@Parameter(name="code", description="TASK_DEFINITION_CODE", schema=@Schema(implementation=long.class, example="123456", required=true))})
    @DeleteMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_SCHEDULE_BY_ID_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteTaskDefinition(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="code") Long code) {
        this.taskDefinitionService.deleteTaskDefinitionByCode(loginUser, code);
        return Result.success();
    }

    @Operation(summary="update", description="UPDATE_TASK_DEFINITION_NOTES")
    @Parameters(value={@Parameter(name="code", description="TASK_DEFINITION_CODE", schema=@Schema(implementation=long.class, example="123456", required=true))})
    @PutMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_TASK_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result<TaskDefinition> updateTaskDefinition(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="code") Long code, @RequestBody TaskUpdateRequest taskUpdateRequest) {
        TaskDefinition taskDefinition = this.taskDefinitionService.updateTaskDefinitionV2(loginUser, code, taskUpdateRequest);
        return Result.success(taskDefinition);
    }

    @Operation(summary="get", description="GET_TASK_DEFINITION_NOTES")
    @Parameters(value={@Parameter(name="code", description="TASK_DEFINITION_CODE", schema=@Schema(implementation=long.class, example="123456", required=true))})
    @GetMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DETAIL_OF_TASK_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result<TaskDefinition> getTaskDefinition(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="code") Long code) {
        TaskDefinition taskDefinition = this.taskDefinitionService.getTaskDefinition(loginUser, code);
        return Result.success(taskDefinition);
    }

    @Operation(summary="get", description="FILTER_TASK_DEFINITION_NOTES")
    @PostMapping(value={"/query"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_DEFINITION_LIST)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result<PageInfo<TaskDefinition>> filterTaskDefinition(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestBody TaskFilterRequest taskFilterRequest) {
        PageInfo<TaskDefinition> taskDefinitions = this.taskDefinitionService.filterTaskDefinition(loginUser, taskFilterRequest);
        return Result.success(taskDefinitions);
    }
}

