/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.exceptions;

import lombok.Generated;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.utils.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.HandlerMethod;

@RestControllerAdvice
@ResponseBody
public class ApiExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiExceptionHandler.class);

    @ExceptionHandler(value={ServiceException.class})
    public Result exceptionHandler(ServiceException e, HandlerMethod hm) {
        log.error("ServiceException: ", (Throwable)e);
        return new Result(e.getCode(), e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public Result exceptionHandler(Exception e, HandlerMethod hm) {
        ApiException ce = (ApiException)hm.getMethodAnnotation(ApiException.class);
        if (ce == null) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.errorWithArgs(Status.INTERNAL_SERVER_ERROR_ARGS, e.getMessage());
        }
        Status st = ce.value();
        log.error(st.getMsg(), (Throwable)e);
        return Result.error(st);
    }
}

