/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.executor;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.api.enums.ExecuteType;
import org.apache.dolphinscheduler.api.executor.ExecuteContext;
import org.apache.dolphinscheduler.api.executor.ExecuteFunction;
import org.apache.dolphinscheduler.api.executor.ExecuteFunctionBuilder;
import org.apache.dolphinscheduler.api.executor.ExecuteResult;
import org.apache.dolphinscheduler.api.executor.ExecuteRuntimeException;
import org.springframework.stereotype.Component;

@Component
public class ExecuteClient {
    private final Map<ExecuteType, ExecuteFunctionBuilder> executorFunctionBuilderMap;

    public ExecuteClient(List<ExecuteFunctionBuilder> executeFunctionBuilders) {
        this.executorFunctionBuilderMap = executeFunctionBuilders.stream().collect(Collectors.toMap(ExecuteFunctionBuilder::getExecuteType, Function.identity()));
    }

    public ExecuteResult executeWorkflowInstance(ExecuteContext executeContext) throws ExecuteRuntimeException {
        ExecuteFunctionBuilder executeFunctionBuilder = (ExecuteFunctionBuilder)Preconditions.checkNotNull((Object)this.executorFunctionBuilderMap.get((Object)executeContext.getExecuteType()), (Object)String.format("The executeType: %s is not supported", new Object[]{executeContext.getExecuteType()}));
        return (ExecuteResult)((CompletableFuture)executeFunctionBuilder.createWorkflowInstanceExecuteFunction(executeContext).thenCombine((CompletionStage)executeFunctionBuilder.createWorkflowInstanceExecuteRequest(executeContext), ExecuteFunction::execute)).join();
    }
}

