/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.executor.workflow.instance.pause.pause;

import org.apache.dolphinscheduler.api.enums.ExecuteType;
import org.apache.dolphinscheduler.api.executor.ExecuteFunction;
import org.apache.dolphinscheduler.api.executor.ExecuteRuntimeException;
import org.apache.dolphinscheduler.api.executor.workflow.instance.pause.pause.PauseExecuteFunctionBuilder;
import org.apache.dolphinscheduler.api.executor.workflow.instance.pause.pause.PauseExecuteRequest;
import org.apache.dolphinscheduler.api.executor.workflow.instance.pause.pause.PauseExecuteResult;
import org.apache.dolphinscheduler.api.rpc.ApiRpcClient;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.repository.ProcessInstanceDao;
import org.apache.dolphinscheduler.remote.command.workflow.WorkflowStateEventChangeRequest;
import org.apache.dolphinscheduler.remote.exceptions.RemotingException;
import org.apache.dolphinscheduler.remote.utils.Host;

public class PauseExecuteFunction
implements ExecuteFunction<PauseExecuteRequest, PauseExecuteResult> {
    private final ProcessInstanceDao processInstanceDao;
    private final ApiRpcClient apiRpcClient;

    public PauseExecuteFunction(ProcessInstanceDao processInstanceDao, ApiRpcClient apiRpcClient) {
        this.processInstanceDao = processInstanceDao;
        this.apiRpcClient = apiRpcClient;
    }

    @Override
    public PauseExecuteResult execute(PauseExecuteRequest request) throws ExecuteRuntimeException {
        ProcessInstance workflowInstance = request.getWorkflowInstance();
        if (!workflowInstance.getState().isRunning()) {
            throw new ExecuteRuntimeException(String.format("The workflow instance: %s status is %s, can not pause", workflowInstance.getName(), workflowInstance.getState()));
        }
        workflowInstance.setCommandType(CommandType.PAUSE);
        workflowInstance.addHistoryCmd(CommandType.PAUSE);
        workflowInstance.setStateWithDesc(WorkflowExecutionStatus.READY_PAUSE, CommandType.PAUSE.getDescp() + " by " + request.getExecuteUser().getUserName());
        if (!this.processInstanceDao.updateById((Object)workflowInstance)) {
            throw new ExecuteRuntimeException(String.format("The workflow instance: %s pause failed, due to update the workflow instance status in DB failed", workflowInstance.getName()));
        }
        WorkflowStateEventChangeRequest workflowStateEventChangeRequest = new WorkflowStateEventChangeRequest(workflowInstance.getId().intValue(), 0, workflowInstance.getState(), workflowInstance.getId().intValue(), 0);
        try {
            this.apiRpcClient.send(Host.of((String)workflowInstance.getHost()), workflowStateEventChangeRequest.convert2Command());
        }
        catch (RemotingException e) {
            throw new ExecuteRuntimeException(String.format("The workflow instance: %s pause failed, due to send rpc request to master: %s failed", workflowInstance.getName(), workflowInstance.getHost()), e);
        }
        return new PauseExecuteResult(workflowInstance);
    }

    @Override
    public ExecuteType getExecuteType() {
        return PauseExecuteFunctionBuilder.EXECUTE_TYPE;
    }
}

