/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.executor.workflow.instance.pause.pause;

import java.util.concurrent.CompletableFuture;
import org.apache.dolphinscheduler.api.enums.ExecuteType;
import org.apache.dolphinscheduler.api.executor.ExecuteContext;
import org.apache.dolphinscheduler.api.executor.ExecuteFunction;
import org.apache.dolphinscheduler.api.executor.ExecuteFunctionBuilder;
import org.apache.dolphinscheduler.api.executor.workflow.instance.pause.pause.PauseExecuteFunction;
import org.apache.dolphinscheduler.api.executor.workflow.instance.pause.pause.PauseExecuteRequest;
import org.apache.dolphinscheduler.api.executor.workflow.instance.pause.pause.PauseExecuteResult;
import org.apache.dolphinscheduler.api.rpc.ApiRpcClient;
import org.apache.dolphinscheduler.dao.repository.ProcessInstanceDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PauseExecuteFunctionBuilder
implements ExecuteFunctionBuilder<PauseExecuteRequest, PauseExecuteResult> {
    public static final ExecuteType EXECUTE_TYPE = ExecuteType.PAUSE;
    @Autowired
    private ProcessInstanceDao processInstanceDao;
    @Autowired
    private ApiRpcClient apiRpcClient;

    @Override
    public CompletableFuture<ExecuteFunction<PauseExecuteRequest, PauseExecuteResult>> createWorkflowInstanceExecuteFunction(ExecuteContext executeContext) {
        return CompletableFuture.completedFuture(new PauseExecuteFunction(this.processInstanceDao, this.apiRpcClient));
    }

    @Override
    public CompletableFuture<PauseExecuteRequest> createWorkflowInstanceExecuteRequest(ExecuteContext executeContext) {
        return CompletableFuture.completedFuture(new PauseExecuteRequest(executeContext.getWorkflowDefinition(), executeContext.getWorkflowInstance(), executeContext.getExecuteUser()));
    }

    @Override
    public ExecuteType getExecuteType() {
        return EXECUTE_TYPE;
    }
}

