/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.executor.workflow.instance.stop;

import lombok.Generated;
import org.apache.dolphinscheduler.api.enums.ExecuteType;
import org.apache.dolphinscheduler.api.executor.ExecuteFunction;
import org.apache.dolphinscheduler.api.executor.ExecuteRuntimeException;
import org.apache.dolphinscheduler.api.executor.workflow.instance.stop.StopExecuteFunctionBuilder;
import org.apache.dolphinscheduler.api.executor.workflow.instance.stop.StopRequest;
import org.apache.dolphinscheduler.api.executor.workflow.instance.stop.StopResult;
import org.apache.dolphinscheduler.api.rpc.ApiRpcClient;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.repository.ProcessInstanceDao;
import org.apache.dolphinscheduler.remote.command.workflow.WorkflowStateEventChangeRequest;
import org.apache.dolphinscheduler.remote.exceptions.RemotingException;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopExecuteFunction
implements ExecuteFunction<StopRequest, StopResult> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StopExecuteFunction.class);
    private final ProcessInstanceDao processInstanceDao;
    private final ApiRpcClient apiRpcClient;

    public StopExecuteFunction(ProcessInstanceDao processInstanceDao, ApiRpcClient apiRpcClient) {
        this.processInstanceDao = processInstanceDao;
        this.apiRpcClient = apiRpcClient;
    }

    @Override
    public StopResult execute(StopRequest request) throws ExecuteRuntimeException {
        ProcessInstance workflowInstance = request.getWorkflowInstance();
        if (!workflowInstance.getState().canStop() || workflowInstance.getState() == WorkflowExecutionStatus.READY_STOP) {
            throw new ExecuteRuntimeException(String.format("The workflow instance: %s status is %s, can not be stopped", workflowInstance.getName(), workflowInstance.getState()));
        }
        workflowInstance.setCommandType(CommandType.STOP);
        workflowInstance.addHistoryCmd(CommandType.STOP);
        workflowInstance.setStateWithDesc(WorkflowExecutionStatus.READY_STOP, CommandType.STOP.getDescp() + " by user");
        if (this.processInstanceDao.updateById((Object)workflowInstance)) {
            log.info("Workflow instance {} ready to stop success, will call master to stop the workflow instance", (Object)workflowInstance.getName());
            WorkflowStateEventChangeRequest workflowStateEventChangeRequest = new WorkflowStateEventChangeRequest(workflowInstance.getId().intValue(), 0, workflowInstance.getState(), workflowInstance.getId().intValue(), 0);
            try {
                this.apiRpcClient.send(Host.of((String)workflowInstance.getHost()), workflowStateEventChangeRequest.convert2Command());
            }
            catch (RemotingException e) {
                throw new ExecuteRuntimeException(String.format("Workflow instance: %s stop failed, due to send request to master: %s failed", workflowInstance.getName(), workflowInstance.getHost()), e);
            }
            return new StopResult(workflowInstance);
        }
        throw new ExecuteRuntimeException("Workflow instance stop failed, due to update the workflow instance status failed");
    }

    @Override
    public ExecuteType getExecuteType() {
        return StopExecuteFunctionBuilder.EXECUTE_TYPE;
    }
}

