/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public final class ApiServerMetrics {
    private static final Counter apiRequestCounter = Counter.builder((String)"ds.api.request.count").description("Api request count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter apiResponse2xxCounter = Counter.builder((String)"ds.api.response.count").tag("code", "2xx").description("Api 2xx response count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter apiResponse3xxCounter = Counter.builder((String)"ds.api.response.count").tag("code", "3xx").description("Api 3xx response count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter apiResponse4xxCounter = Counter.builder((String)"ds.api.response.count").tag("code", "4xx").description("Api 4xx response count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter apiResponse5xxCounter = Counter.builder((String)"ds.api.response.count").tag("code", "5xx").description("Api 5xx response count").register((MeterRegistry)Metrics.globalRegistry);
    private static final DistributionSummary apiResourceUploadSizeDistribution = DistributionSummary.builder((String)"ds.api.resource.upload.size").baseUnit("bytes").publishPercentiles(new double[]{0.5, 0.75, 0.95, 0.99}).publishPercentileHistogram().description("size of upload resource files on api").register((MeterRegistry)Metrics.globalRegistry);
    private static final DistributionSummary apiResourceDownloadSizeDistribution = DistributionSummary.builder((String)"ds.api.resource.download.size").baseUnit("bytes").publishPercentiles(new double[]{0.5, 0.75, 0.95, 0.99}).publishPercentileHistogram().description("size of download resource files on api").register((MeterRegistry)Metrics.globalRegistry);

    public static void incApiRequestCount() {
        apiRequestCounter.increment();
    }

    public static void incApiResponse2xxCount() {
        apiResponse2xxCounter.increment();
    }

    public static void incApiResponse3xxCount() {
        apiResponse3xxCounter.increment();
    }

    public static void incApiResponse4xxCount() {
        apiResponse4xxCounter.increment();
    }

    public static void incApiResponse5xxCount() {
        apiResponse5xxCounter.increment();
    }

    public static void recordApiResourceUploadSize(long size) {
        apiResourceUploadSizeDistribution.record((double)size);
    }

    public static void recordApiResourceDownloadSize(long size) {
        apiResourceDownloadSizeDistribution.record((double)size);
    }

    public static void recordApiResponseTime(long milliseconds, int userId) {
        Metrics.globalRegistry.timer("ds.api.response.time", new String[]{"user.id", String.valueOf(userId)}).record(milliseconds, TimeUnit.MILLISECONDS);
    }

    public static void cleanUpApiResponseTimeMetricsByUserId(int userId) {
        Metrics.globalRegistry.remove((Meter)Metrics.globalRegistry.timer("ds.api.response.time", new String[]{"user.id", String.valueOf(userId)}));
    }

    @Generated
    private ApiServerMetrics() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        Timer.builder((String)"ds.api.response.time").tag("user.id", "dummy").description("response time on api").register((MeterRegistry)Metrics.globalRegistry);
    }
}

