/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.security.impl.sso;

import java.security.MessageDigest;
import javax.servlet.http.HttpServletRequest;
import org.apache.dolphinscheduler.api.security.impl.AbstractSsoAuthenticator;
import org.apache.dolphinscheduler.api.service.UsersService;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.dao.entity.User;
import org.casbin.casdoor.entity.CasdoorUser;
import org.casbin.casdoor.service.CasdoorAuthService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class CasdoorAuthenticator
extends AbstractSsoAuthenticator {
    @Autowired
    private UsersService usersService;
    @Autowired
    private CasdoorAuthService casdoorAuthService;
    @Value(value="${casdoor.redirect-url}")
    private String redirectUrl;
    @Value(value="${security.authentication.casdoor.user.admin:#{null}}")
    private String adminUserName;

    @Override
    public User login(String state, String code, String extra) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (servletRequestAttributes == null) {
            return null;
        }
        HttpServletRequest request = servletRequestAttributes.getRequest();
        String originalState = (String)request.getSession().getAttribute("sso.login.user.state");
        request.getSession().setAttribute("sso.login.user.state", null);
        if (originalState == null || !MessageDigest.isEqual(originalState.getBytes(), state.getBytes())) {
            return null;
        }
        String token = this.casdoorAuthService.getOAuthToken(code, state);
        CasdoorUser casdoorUser = this.casdoorAuthService.parseJwtToken(token);
        User user = null;
        if (casdoorUser.getName() != null && (user = this.usersService.getUserByUserName(casdoorUser.getName())) == null) {
            user = this.usersService.createUser(this.getUserType(casdoorUser.getName()), casdoorUser.getName(), casdoorUser.getEmail());
        }
        return user;
    }

    public UserType getUserType(String userName) {
        return this.adminUserName.equalsIgnoreCase(userName) ? UserType.ADMIN_USER : UserType.GENERAL_USER;
    }

    @Override
    public String getSignInUrl(String state) {
        return this.casdoorAuthService.getSigninUrl(this.redirectUrl, state);
    }
}

