/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.dolphinscheduler.api.dto.CommandStateCount;
import org.apache.dolphinscheduler.api.dto.DefineUserDto;
import org.apache.dolphinscheduler.api.dto.TaskCountDto;
import org.apache.dolphinscheduler.api.dto.project.StatisticsStateRequest;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.DataAnalysisService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.common.constants.Constants;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.TriFunction;
import org.apache.dolphinscheduler.dao.entity.CommandCount;
import org.apache.dolphinscheduler.dao.entity.DefinitionGroupByUser;
import org.apache.dolphinscheduler.dao.entity.ExecuteStatusCount;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.CommandMapper;
import org.apache.dolphinscheduler.dao.mapper.ErrorCommandMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessTaskRelationMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataAnalysisServiceImpl
extends BaseServiceImpl
implements DataAnalysisService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataAnalysisServiceImpl.class);
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private ProcessInstanceMapper processInstanceMapper;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;
    @Autowired
    private CommandMapper commandMapper;
    @Autowired
    private ErrorCommandMapper errorCommandMapper;
    @Autowired
    private TaskInstanceMapper taskInstanceMapper;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private ProcessTaskRelationMapper relationMapper;

    @Override
    public Map<String, Object> countTaskStateByProject(User loginUser, long projectCode, String startDate, String endDate) {
        return this.countStateByProject(loginUser, projectCode, startDate, endDate, (TriFunction<Date, Date, Long[], List<ExecuteStatusCount>>)((TriFunction)this::countTaskInstanceAllStatesByProjectCodes));
    }

    @Override
    public Map<String, Object> countProcessInstanceStateByProject(User loginUser, long projectCode, String startDate, String endDate) {
        Map<String, Object> result = this.countStateByProject(loginUser, projectCode, startDate, endDate, (TriFunction<Date, Date, Long[], List<ExecuteStatusCount>>)((TriFunction)(start, end, projectCodes) -> this.processInstanceMapper.countInstanceStateByProjectCodes(start, end, projectCodes)));
        if (result.containsKey("status") && result.get("status").equals((Object)Status.SUCCESS)) {
            ((TaskCountDto)result.get("data")).removeStateFromCountList(TaskExecutionStatus.FORCED_SUCCESS);
        }
        return result;
    }

    private Map<String, Object> countStateByProject(User loginUser, long projectCode, String startDate, String endDate, TriFunction<Date, Date, Long[], List<ExecuteStatusCount>> instanceStateCounter) {
        Long[] longArray;
        Pair<Set<Integer>, Map<String, Object>> projectIds;
        Project project;
        Map<String, Object> result = new HashMap<String, Object>();
        if (projectCode != 0L && (result = this.projectService.checkProjectAndAuth(loginUser, project = this.projectMapper.queryByCode(projectCode), projectCode, "project:overview:view")).get("status") != Status.SUCCESS) {
            return result;
        }
        Date start = null;
        Date end = null;
        if (!StringUtils.isEmpty((CharSequence)startDate) && !StringUtils.isEmpty((CharSequence)endDate)) {
            start = DateUtils.stringToDate((String)startDate);
            end = DateUtils.stringToDate((String)endDate);
            if (Objects.isNull(start) || Objects.isNull(end)) {
                log.warn("Parameter startDate or endDate is invalid.");
                this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "startDate,endDate");
                return result;
            }
        }
        if ((projectIds = this.getProjectIds(loginUser, result)).getRight() != null) {
            return (Map)projectIds.getRight();
        }
        if (projectCode == 0L) {
            longArray = this.getProjectCodesArrays((Set)projectIds.getLeft());
        } else {
            Long[] longArray2 = new Long[1];
            longArray = longArray2;
            longArray2[0] = projectCode;
        }
        Long[] projectCodeArray = longArray;
        ArrayList<ExecuteStatusCount> processInstanceStateCounts = new ArrayList();
        if (projectCodeArray.length != 0 || loginUser.getUserType() == UserType.ADMIN_USER) {
            processInstanceStateCounts = (List)instanceStateCounter.apply((Object)start, (Object)end, (Object)projectCodeArray);
        }
        if (processInstanceStateCounts != null) {
            TaskCountDto taskCountResult = new TaskCountDto(processInstanceStateCounts);
            result.put("data", taskCountResult);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public Map<String, Object> countDefinitionByUser(User loginUser, long projectCode) {
        Long[] longArray;
        Project project;
        Map<String, Object> result = new HashMap<String, Object>();
        if (projectCode != 0L && (result = this.projectService.checkProjectAndAuth(loginUser, project = this.projectMapper.queryByCode(projectCode), projectCode, "project:overview:view")).get("status") != Status.SUCCESS) {
            return result;
        }
        ArrayList<DefinitionGroupByUser> defineGroupByUsers = new ArrayList();
        Pair<Set<Integer>, Map<String, Object>> projectIds = this.getProjectIds(loginUser, result);
        if (projectIds.getRight() != null) {
            ArrayList<DefinitionGroupByUser> emptyList = new ArrayList<DefinitionGroupByUser>();
            DefineUserDto dto = new DefineUserDto(emptyList);
            result.put("data", dto);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        if (projectCode == 0L) {
            longArray = this.getProjectCodesArrays((Set)projectIds.getLeft());
        } else {
            Long[] longArray2 = new Long[1];
            longArray = longArray2;
            longArray2[0] = projectCode;
        }
        Long[] projectCodeArray = longArray;
        if (projectCodeArray.length != 0 || loginUser.getUserType() == UserType.ADMIN_USER) {
            defineGroupByUsers = this.processDefinitionMapper.countDefinitionByProjectCodes(projectCodeArray);
        }
        DefineUserDto dto = new DefineUserDto(defineGroupByUsers);
        result.put("data", dto);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> countCommandState(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Date start = null;
        Date end = null;
        Pair<Set<Integer>, Map<String, Object>> projectIds = this.getProjectIds(loginUser, result);
        if (projectIds.getRight() != null) {
            List noData = Arrays.stream(CommandType.values()).map(commandType -> new CommandStateCount(0, 0, (CommandType)commandType)).collect(Collectors.toList());
            result.put("data", noData);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        Long[] projectCodeArray = this.getProjectCodesArrays((Set)projectIds.getLeft());
        Map<CommandType, Integer> normalCountCommandCounts = this.commandMapper.countCommandState(start, end, projectCodeArray).stream().collect(Collectors.toMap(CommandCount::getCommandType, CommandCount::getCount));
        Map<CommandType, Integer> errorCommandCounts = this.errorCommandMapper.countCommandState(start, end, projectCodeArray).stream().collect(Collectors.toMap(CommandCount::getCommandType, CommandCount::getCount));
        List list = Arrays.stream(CommandType.values()).map(commandType -> new CommandStateCount(errorCommandCounts.getOrDefault(commandType, 0), normalCountCommandCounts.getOrDefault(commandType, 0), (CommandType)commandType)).collect(Collectors.toList());
        result.put("data", list);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private Pair<Set<Integer>, Map<String, Object>> getProjectIds(User loginUser, Map<String, Object> result) {
        Set projectIds = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.PROJECTS, loginUser.getId(), log);
        if (projectIds.isEmpty()) {
            ArrayList<ExecuteStatusCount> taskInstanceStateCounts = new ArrayList<ExecuteStatusCount>();
            result.put("data", new TaskCountDto(taskInstanceStateCounts));
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return Pair.of(null, result);
        }
        return Pair.of(projectIds, null);
    }

    private Long[] getProjectCodesArrays(Set<Integer> projectIds) {
        List projects = this.projectMapper.selectBatchIds(projectIds);
        List<Long> codeList = projects.stream().map(Project::getCode).collect(Collectors.toList());
        Long[] projectCodeArray = new Long[codeList.size()];
        codeList.toArray(projectCodeArray);
        return projectCodeArray;
    }

    @Override
    public Map<String, Object> countQueueState(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
        dataMap.put("taskQueue", 0);
        dataMap.put("taskKill", 0);
        result.put("data", dataMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public List<ExecuteStatusCount> countTaskInstanceAllStatesByProjectCodes(Date startTime, Date endTime, Long[] projectCodes) {
        List needRecountState;
        Optional<List> startTimeStates = Optional.ofNullable(this.taskInstanceMapper.countTaskInstanceStateByProjectCodes(startTime, endTime, projectCodes));
        List allState = Arrays.stream(TaskExecutionStatus.values()).collect(Collectors.toList());
        if (startTimeStates.isPresent() && startTimeStates.get().size() != 0) {
            List instanceState = startTimeStates.get().stream().map(ExecuteStatusCount::getState).collect(Collectors.toList());
            needRecountState = allState.stream().filter(ele -> !instanceState.contains(ele)).collect(Collectors.toList());
            if (needRecountState.size() == 0) {
                return startTimeStates.get();
            }
        } else {
            needRecountState = allState;
        }
        List recounts = this.taskInstanceMapper.countTaskInstanceStateByProjectCodesAndStatesBySubmitTime(startTime, endTime, projectCodes, needRecountState);
        startTimeStates.orElseGet(ArrayList::new).addAll(recounts);
        return startTimeStates.orElse(null);
    }

    @Override
    public Map<String, Object> queryAllWorkflowCounts(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int count = 0;
        Set projectIds = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.PROJECTS, loginUser.getId(), log);
        if (!projectIds.isEmpty()) {
            List projects = this.projectMapper.selectBatchIds(projectIds);
            List projectCodes = projects.stream().map(project -> project.getCode()).collect(Collectors.toList());
            count = this.projectMapper.queryAllWorkflowCounts(projectCodes);
        }
        result.put("data", "AllWorkflowCounts = " + count);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> countWorkflowStates(User loginUser, StatisticsStateRequest statisticsStateRequest) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set projectIds = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.PROJECTS, loginUser.getId(), log);
        if (projectIds.isEmpty()) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        String projectName = statisticsStateRequest.getProjectName();
        String workflowName = statisticsStateRequest.getWorkflowName();
        Long projectCode = statisticsStateRequest.getProjectCode();
        Long workflowCode = statisticsStateRequest.getWorkflowCode();
        Integer model = Constants.QUERY_ALL_ON_SYSTEM;
        if (!StringUtils.isBlank((CharSequence)projectName) || null != projectCode) {
            model = Constants.QUERY_ALL_ON_PROJECT;
        }
        if (!StringUtils.isBlank((CharSequence)workflowName) || null != workflowCode) {
            model = Constants.QUERY_ALL_ON_WORKFLOW;
        }
        try {
            if (null == workflowCode || null == projectCode) {
                projectCode = this.projectMapper.queryByName(projectName).getCode();
                workflowCode = this.processDefinitionMapper.queryByDefineName(projectCode.longValue(), workflowName).getCode();
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        Date date = new Date();
        Date startTime = statisticsStateRequest.getStartTime() == null ? DateUtils.addMonths((Date)date, (int)-1) : statisticsStateRequest.getStartTime();
        Date endTime = statisticsStateRequest.getEndTime() == null ? date : statisticsStateRequest.getEndTime();
        List executeStatusCounts = this.processInstanceMapper.countInstanceStateV2(startTime, endTime, projectCode, workflowCode, model, projectIds);
        TaskCountDto taskCountResult = new TaskCountDto(executeStatusCounts);
        result.put("data", taskCountResult);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> countOneWorkflowStates(User loginUser, Long workflowCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByCode(workflowCode.longValue());
        boolean hasProjectAndWritePerm = this.projectService.hasProjectAndWritePerm(loginUser, project, result);
        if (!hasProjectAndWritePerm) {
            return result;
        }
        List executeStatusCounts = this.processInstanceMapper.countInstanceStateV2(null, null, null, workflowCode, Constants.QUERY_ALL_ON_WORKFLOW, null);
        if (executeStatusCounts != null) {
            TaskCountDto taskCountResult = new TaskCountDto(executeStatusCounts);
            result.put("data", taskCountResult);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public Map<String, Object> countTaskStates(User loginUser, StatisticsStateRequest statisticsStateRequest) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set projectIds = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.PROJECTS, loginUser.getId(), log);
        if (projectIds.isEmpty()) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        String projectName = statisticsStateRequest.getProjectName();
        String workflowName = statisticsStateRequest.getWorkflowName();
        String taskName = statisticsStateRequest.getTaskName();
        Long projectCode = statisticsStateRequest.getProjectCode();
        Long workflowCode = statisticsStateRequest.getWorkflowCode();
        Long taskCode = statisticsStateRequest.getTaskCode();
        Integer model = Constants.QUERY_ALL_ON_SYSTEM;
        if (!StringUtils.isBlank((CharSequence)projectName) || null != projectCode) {
            model = Constants.QUERY_ALL_ON_PROJECT;
        }
        if (!StringUtils.isBlank((CharSequence)workflowName) || null != workflowCode) {
            model = Constants.QUERY_ALL_ON_WORKFLOW;
        }
        if (!StringUtils.isBlank((CharSequence)taskName) || null != taskCode) {
            model = Constants.QUERY_ALL_ON_TASK;
        }
        try {
            if (null == taskCode || null == workflowCode || null == projectCode) {
                projectCode = this.projectMapper.queryByName(projectName).getCode();
                workflowCode = this.processDefinitionMapper.queryByDefineName(projectCode.longValue(), workflowName).getCode();
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        Date date = new Date();
        Date startTime = statisticsStateRequest.getStartTime() == null ? DateUtils.addMonths((Date)date, (int)-1) : statisticsStateRequest.getStartTime();
        Date endTime = statisticsStateRequest.getEndTime() == null ? date : statisticsStateRequest.getEndTime();
        Optional<List<ExecuteStatusCount>> startTimeStates = Optional.ofNullable(this.taskInstanceMapper.countTaskInstanceStateByProjectIdsV2(startTime, endTime, projectIds));
        List<TaskExecutionStatus> needRecountState = this.setOptional(startTimeStates);
        if (needRecountState.size() == 0) {
            TaskCountDto taskCountResult = new TaskCountDto(startTimeStates.get());
            result.put("data", taskCountResult);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        List recounts = this.taskInstanceMapper.countTaskInstanceStateByProjectCodesAndStatesBySubmitTimeV2(startTime, endTime, projectCode, workflowCode, taskCode, model, projectIds, needRecountState);
        startTimeStates.orElseGet(ArrayList::new).addAll(recounts);
        List executeStatusCounts = startTimeStates.orElse(null);
        TaskCountDto taskCountResult = new TaskCountDto(executeStatusCounts);
        result.put("data", taskCountResult);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> countOneTaskStates(User loginUser, Long taskCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode.longValue());
        long projectCode = taskDefinition.getProjectCode();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndWritePerm = this.projectService.hasProjectAndWritePerm(loginUser, project, result);
        if (!hasProjectAndWritePerm) {
            return result;
        }
        Set<Integer> projectId = Collections.singleton(project.getId());
        Optional<List<ExecuteStatusCount>> startTimeStates = Optional.ofNullable(this.taskInstanceMapper.countTaskInstanceStateByProjectIdsV2(null, null, projectId));
        List<TaskExecutionStatus> needRecountState = this.setOptional(startTimeStates);
        if (needRecountState.size() == 0) {
            TaskCountDto taskCountResult = new TaskCountDto(startTimeStates.get());
            result.put("data", taskCountResult);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        List recounts = this.taskInstanceMapper.countTaskInstanceStateByProjectCodesAndStatesBySubmitTimeV2(null, null, Long.valueOf(projectCode), null, taskCode, Constants.QUERY_ALL_ON_TASK, projectId, needRecountState);
        startTimeStates.orElseGet(ArrayList::new).addAll(recounts);
        List executeStatusCounts = startTimeStates.orElse(null);
        TaskCountDto taskCountResult = new TaskCountDto(executeStatusCounts);
        result.put("data", taskCountResult);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> countDefinitionByUserV2(User loginUser, Long projectCode, Integer userId, Integer releaseState) {
        Long[] longArray;
        Project project;
        Map<String, Object> result = new HashMap<String, Object>();
        if (null != projectCode && (result = this.projectService.checkProjectAndAuth(loginUser, project = this.projectMapper.queryByCode(projectCode.longValue()), projectCode, "project:overview:view")).get("status") != Status.SUCCESS) {
            return result;
        }
        List<Object> defineGroupByUsers = new ArrayList<DefinitionGroupByUser>();
        Pair<Set<Integer>, Map<String, Object>> projectIds = this.getProjectIds(loginUser, result);
        if (projectIds.getRight() != null) {
            ArrayList<DefinitionGroupByUser> emptyList = new ArrayList<DefinitionGroupByUser>();
            DefineUserDto dto = new DefineUserDto(emptyList);
            result.put("data", dto);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        if (projectCode == null) {
            longArray = this.getProjectCodesArrays((Set)projectIds.getLeft());
        } else {
            Long[] longArray2 = new Long[1];
            longArray = longArray2;
            longArray2[0] = projectCode;
        }
        Long[] projectCodeArray = longArray;
        if (projectCodeArray.length != 0 || loginUser.getUserType() == UserType.ADMIN_USER) {
            defineGroupByUsers = this.processDefinitionMapper.countDefinitionByProjectCodesV2(projectCodeArray, userId, releaseState);
        }
        DefineUserDto dto = new DefineUserDto(defineGroupByUsers);
        result.put("data", dto);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Long getProjectCodeByName(String projectName) {
        Project project = this.projectMapper.queryByName(projectName);
        return project == null ? 0L : project.getCode();
    }

    private List<TaskExecutionStatus> setOptional(Optional<List<ExecuteStatusCount>> startTimeStates) {
        List<TaskExecutionStatus> allState = Arrays.stream(TaskExecutionStatus.values()).collect(Collectors.toList());
        if (startTimeStates.isPresent() && startTimeStates.get().size() != 0) {
            List instanceState = startTimeStates.get().stream().map(ExecuteStatusCount::getState).collect(Collectors.toList());
            return allState.stream().filter(ele -> !instanceState.contains(ele)).collect(Collectors.toList());
        }
        return allState;
    }
}

