/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.DataSourceService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.DataSourceMapper;
import org.apache.dolphinscheduler.dao.mapper.DataSourceUserMapper;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.apache.dolphinscheduler.spi.params.base.ParamsOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataSourceServiceImpl
extends BaseServiceImpl
implements DataSourceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataSourceServiceImpl.class);
    @Autowired
    private DataSourceMapper dataSourceMapper;
    @Autowired
    private DataSourceUserMapper datasourceUserMapper;
    private static final String TABLE = "TABLE";
    private static final String VIEW = "VIEW";
    private static final String[] TABLE_TYPES = new String[]{"TABLE", "VIEW"};
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String COLUMN_NAME = "COLUMN_NAME";

    @Override
    @Transactional
    public Result<Object> createDataSource(User loginUser, BaseDataSourceParamDTO datasourceParam) {
        DataSourceUtils.checkDatasourceParam((BaseDataSourceParamDTO)datasourceParam);
        Result<Object> result = new Result<Object>();
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.DATASOURCE, "datasource:create")) {
            this.putMsg((Result)result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (this.checkName(datasourceParam.getName())) {
            log.warn("Datasource with the same name already exists, name:{}.", (Object)datasourceParam.getName());
            this.putMsg((Result)result, Status.DATASOURCE_EXIST, new Object[0]);
            return result;
        }
        if (this.checkDescriptionLength(datasourceParam.getNote())) {
            log.warn("Parameter description is too long, description:{}.", (Object)datasourceParam.getNote());
            this.putMsg((Result)result, Status.DESCRIPTION_TOO_LONG_ERROR, new Object[0]);
            return result;
        }
        ConnectionParam connectionParam = DataSourceUtils.buildConnectionParams((BaseDataSourceParamDTO)datasourceParam);
        DataSource dataSource = new DataSource();
        Date now = new Date();
        dataSource.setName(datasourceParam.getName().trim());
        dataSource.setNote(datasourceParam.getNote());
        dataSource.setUserId(loginUser.getId().intValue());
        dataSource.setUserName(loginUser.getUserName());
        dataSource.setType(datasourceParam.getType());
        dataSource.setConnectionParams(JSONUtils.toJsonString((Object)connectionParam));
        dataSource.setCreateTime(now);
        dataSource.setUpdateTime(now);
        try {
            this.dataSourceMapper.insert((Object)dataSource);
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
            this.permissionPostHandle(AuthorizationType.DATASOURCE, loginUser.getId(), Collections.singletonList(dataSource.getId()), log);
            log.info("Datasource create complete, dbType:{}, datasourceName:{}.", (Object)dataSource.getType().getDescp(), (Object)dataSource.getName());
        }
        catch (DuplicateKeyException ex) {
            log.error("Datasource create error.", (Throwable)ex);
            this.putMsg((Result)result, Status.DATASOURCE_EXIST, new Object[0]);
        }
        return result;
    }

    @Override
    public Result<Object> updateDataSource(int id, User loginUser, BaseDataSourceParamDTO dataSourceParam) {
        DataSourceUtils.checkDatasourceParam((BaseDataSourceParamDTO)dataSourceParam);
        Result<Object> result = new Result<Object>();
        DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)Integer.valueOf(id));
        if (dataSource == null) {
            log.error("Datasource does not exist, id:{}.", (Object)id);
            this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        if (!this.canOperatorPermissions(loginUser, new Object[]{dataSource.getId()}, AuthorizationType.DATASOURCE, "datasource:update")) {
            this.putMsg((Result)result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (!dataSourceParam.getName().trim().equals(dataSource.getName()) && this.checkName(dataSourceParam.getName())) {
            log.warn("Datasource with the same name already exists, name:{}.", (Object)dataSource.getName());
            this.putMsg((Result)result, Status.DATASOURCE_EXIST, new Object[0]);
            return result;
        }
        if (this.checkDescriptionLength(dataSourceParam.getNote())) {
            log.warn("Parameter description is too long, description:{}.", (Object)dataSourceParam.getNote());
            this.putMsg((Result)result, Status.DESCRIPTION_TOO_LONG_ERROR, new Object[0]);
            return result;
        }
        ConnectionParam connectionParam = DataSourceUtils.buildConnectionParams((BaseDataSourceParamDTO)dataSourceParam);
        String password = connectionParam.getPassword();
        if (StringUtils.isBlank((CharSequence)password)) {
            String oldConnectionParams = dataSource.getConnectionParams();
            ObjectNode oldParams = JSONUtils.parseObject((String)oldConnectionParams);
            connectionParam.setPassword(oldParams.path("password").asText());
        }
        Date now = new Date();
        dataSource.setName(dataSourceParam.getName().trim());
        dataSource.setNote(dataSourceParam.getNote());
        dataSource.setUserName(loginUser.getUserName());
        dataSource.setType(dataSource.getType());
        dataSource.setConnectionParams(JSONUtils.toJsonString((Object)connectionParam));
        dataSource.setUpdateTime(now);
        try {
            this.dataSourceMapper.updateById((Object)dataSource);
            log.info("Update datasource complete, datasourceId:{}, datasourceName:{}.", (Object)dataSource.getId(), (Object)dataSource.getName());
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        }
        catch (DuplicateKeyException ex) {
            log.error("Update datasource error, datasourceId:{}, datasourceName:{}.", (Object)dataSource.getId(), (Object)dataSource.getName());
            this.putMsg((Result)result, Status.DATASOURCE_EXIST, new Object[0]);
        }
        return result;
    }

    private boolean checkName(String name) {
        List queryDataSource = this.dataSourceMapper.queryDataSourceByName(name.trim());
        return queryDataSource != null && !queryDataSource.isEmpty();
    }

    @Override
    public BaseDataSourceParamDTO queryDataSource(int id, User loginUser) {
        DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)Integer.valueOf(id));
        if (dataSource == null) {
            log.error("Datasource does not exist, id:{}.", (Object)id);
            throw new ServiceException(Status.RESOURCE_NOT_EXIST);
        }
        if (!this.canOperatorPermissions(loginUser, new Object[]{dataSource.getId()}, AuthorizationType.DATASOURCE, "datasource:view")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        BaseDataSourceParamDTO baseDataSourceParamDTO = DataSourceUtils.buildDatasourceParamDTO((DbType)dataSource.getType(), (String)dataSource.getConnectionParams());
        baseDataSourceParamDTO.setId(dataSource.getId());
        baseDataSourceParamDTO.setName(dataSource.getName());
        baseDataSourceParamDTO.setNote(dataSource.getNote());
        return baseDataSourceParamDTO;
    }

    @Override
    public PageInfo<DataSource> queryDataSourceListPaging(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        IPage dataSourceList = null;
        Page dataSourcePage = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        PageInfo<DataSource> pageInfo = new PageInfo<DataSource>(pageNo, pageSize);
        if (loginUser.getUserType().equals((Object)UserType.ADMIN_USER)) {
            dataSourceList = this.dataSourceMapper.selectPaging((IPage)dataSourcePage, 0, searchVal);
        } else {
            Set ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.DATASOURCE, loginUser.getId(), log);
            if (ids.isEmpty()) {
                return pageInfo;
            }
            dataSourceList = this.dataSourceMapper.selectPagingByIds(dataSourcePage, new ArrayList(ids), searchVal);
        }
        List dataSources = dataSourceList != null ? dataSourceList.getRecords() : new ArrayList();
        this.handlePasswd(dataSources);
        pageInfo.setTotal((int)(dataSourceList != null ? dataSourceList.getTotal() : 0L));
        pageInfo.setTotalList(dataSources);
        return pageInfo;
    }

    private void handlePasswd(List<DataSource> dataSourceList) {
        for (DataSource dataSource : dataSourceList) {
            String connectionParams = dataSource.getConnectionParams();
            ObjectNode object = JSONUtils.parseObject((String)connectionParams);
            object.put("password", this.getHiddenPassword());
            dataSource.setConnectionParams(object.toString());
        }
    }

    private String getHiddenPassword() {
        return "******";
    }

    @Override
    public List<DataSource> queryDataSourceList(User loginUser, Integer type) {
        List datasourceList = null;
        if (loginUser.getUserType().equals((Object)UserType.ADMIN_USER)) {
            datasourceList = this.dataSourceMapper.queryDataSourceByType(0, type);
        } else {
            Set ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.DATASOURCE, loginUser.getId(), log);
            if (ids.isEmpty()) {
                return Collections.emptyList();
            }
            datasourceList = this.dataSourceMapper.selectBatchIds(ids).stream().filter(dataSource -> dataSource.getType().getCode() == type.intValue()).collect(Collectors.toList());
        }
        return datasourceList;
    }

    @Override
    public Result<Object> verifyDataSourceName(String name) {
        Result<Object> result = new Result<Object>();
        List dataSourceList = this.dataSourceMapper.queryDataSourceByName(name);
        if (dataSourceList != null && !dataSourceList.isEmpty()) {
            log.warn("Datasource with the same name already exists, dataSourceName:{}.", (Object)((DataSource)dataSourceList.get(0)).getName());
            this.putMsg((Result)result, Status.DATASOURCE_EXIST, new Object[0]);
        } else {
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public Result<Object> checkConnection(DbType type, ConnectionParam connectionParam) {
        Result<Object> result = new Result<Object>();
        DataSourceProcessor sshDataSourceProcessor = DataSourceUtils.getDatasourceProcessor((DbType)type);
        boolean connectivity = sshDataSourceProcessor.checkDataSourceConnectivity(connectionParam);
        if (connectivity) {
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg((Result)result, Status.CONNECTION_TEST_FAILURE, new Object[0]);
        }
        log.info("Connection test to {} datasource success, connectionParam:{}", (Object)type.name(), (Object)connectionParam);
        return result;
    }

    @Override
    public Result<Object> connectionTest(int id) {
        DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)Integer.valueOf(id));
        if (dataSource == null) {
            Result<Object> result = new Result<Object>();
            log.error("Datasource does not exist, datasourceId:{}.", (Object)id);
            this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        return this.checkConnection(dataSource.getType(), DataSourceUtils.buildConnectionParams((DbType)dataSource.getType(), (String)dataSource.getConnectionParams()));
    }

    @Override
    @Transactional
    public Result<Object> delete(User loginUser, int datasourceId) {
        Result<Object> result = new Result<Object>();
        try {
            DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)Integer.valueOf(datasourceId));
            if (dataSource == null) {
                log.warn("Datasource does not exist, datasourceId:{}.", (Object)datasourceId);
                this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
                return result;
            }
            if (!this.canOperatorPermissions(loginUser, new Object[]{dataSource.getId()}, AuthorizationType.DATASOURCE, "datasource:delete")) {
                this.putMsg((Result)result, Status.USER_NO_OPERATION_PERM, new Object[0]);
                return result;
            }
            this.dataSourceMapper.deleteById((Serializable)Integer.valueOf(datasourceId));
            this.datasourceUserMapper.deleteByDatasourceId(datasourceId);
            log.info("Delete datasource complete, datasourceId:{}.", (Object)datasourceId);
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        }
        catch (Exception e) {
            log.error("Delete datasource complete, datasourceId:{}.", (Object)datasourceId, (Object)e);
            throw new ServiceException(Status.DELETE_DATA_SOURCE_FAILURE);
        }
        return result;
    }

    @Override
    public List<DataSource> unAuthDatasource(User loginUser, Integer userId) {
        List datasourceList = this.canOperatorPermissions(loginUser, null, AuthorizationType.DATASOURCE, null) ? this.dataSourceMapper.queryDatasourceExceptUserId(userId.intValue()) : this.dataSourceMapper.selectByMap(Collections.singletonMap("user_id", loginUser.getId()));
        ArrayList<Object> resultList = new ArrayList<DataSource>();
        if (datasourceList != null && !datasourceList.isEmpty()) {
            HashSet datasourceSet = new HashSet(datasourceList);
            List authedDataSourceList = this.dataSourceMapper.queryAuthedDatasource(userId.intValue());
            if (authedDataSourceList != null && !authedDataSourceList.isEmpty()) {
                HashSet authedDataSourceSet = new HashSet(authedDataSourceList);
                datasourceSet.removeAll(authedDataSourceSet);
            }
            resultList = new ArrayList(datasourceSet);
        }
        return resultList;
    }

    @Override
    public List<DataSource> authedDatasource(User loginUser, Integer userId) {
        List authedDatasourceList = this.dataSourceMapper.queryAuthedDatasource(userId.intValue());
        return authedDatasourceList;
    }

    @Override
    public List<ParamsOptions> getTables(Integer datasourceId, String database) {
        DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)datasourceId);
        ArrayList<String> tableList = null;
        BaseConnectionParam connectionParam = (BaseConnectionParam)DataSourceUtils.buildConnectionParams((DbType)dataSource.getType(), (String)dataSource.getConnectionParams());
        if (null == connectionParam) {
            throw new ServiceException(Status.DATASOURCE_CONNECT_FAILED);
        }
        Connection connection = DataSourceUtils.getConnection((DbType)dataSource.getType(), (ConnectionParam)connectionParam);
        ResultSet tables = null;
        try {
            if (null == connection) {
                throw new ServiceException(Status.DATASOURCE_CONNECT_FAILED);
            }
            DatabaseMetaData metaData = connection.getMetaData();
            String schema = null;
            try {
                schema = metaData.getConnection().getSchema();
            }
            catch (SQLException e) {
                log.error("Cant not get the schema, datasourceId:{}.", (Object)datasourceId, (Object)e);
                throw new ServiceException(Status.GET_DATASOURCE_TABLES_ERROR);
            }
            tables = metaData.getTables(database, this.getDbSchemaPattern(dataSource.getType(), schema, connectionParam), "%", TABLE_TYPES);
            if (null == tables) {
                log.error("Get datasource tables error, datasourceId:{}.", (Object)datasourceId);
                throw new ServiceException(Status.GET_DATASOURCE_TABLES_ERROR);
            }
            tableList = new ArrayList<String>();
            while (tables.next()) {
                String name = tables.getString(TABLE_NAME);
                tableList.add(name);
            }
        }
        catch (Exception e) {
            try {
                log.error("Get datasource tables error, datasourceId:{}.", (Object)datasourceId, (Object)e);
                throw new ServiceException(Status.GET_DATASOURCE_TABLES_ERROR);
            }
            catch (Throwable throwable) {
                DataSourceServiceImpl.closeResult(tables);
                DataSourceServiceImpl.releaseConnection(connection);
                throw throwable;
            }
        }
        DataSourceServiceImpl.closeResult(tables);
        DataSourceServiceImpl.releaseConnection(connection);
        List<ParamsOptions> options = this.getParamsOptions(tableList);
        return options;
    }

    @Override
    public List<ParamsOptions> getTableColumns(Integer datasourceId, String database, String tableName) {
        DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)datasourceId);
        BaseConnectionParam connectionParam = (BaseConnectionParam)DataSourceUtils.buildConnectionParams((DbType)dataSource.getType(), (String)dataSource.getConnectionParams());
        if (null == connectionParam) {
            throw new ServiceException(Status.DATASOURCE_CONNECT_FAILED);
        }
        Connection connection = DataSourceUtils.getConnection((DbType)dataSource.getType(), (ConnectionParam)connectionParam);
        ArrayList<String> columnList = new ArrayList<String>();
        ResultSet rs = null;
        try {
            if (null == connection) {
                throw new ServiceException(Status.DATASOURCE_CONNECT_FAILED);
            }
            DatabaseMetaData metaData = connection.getMetaData();
            if (dataSource.getType() == DbType.ORACLE) {
                database = null;
            }
            if ((rs = metaData.getColumns(database, null, tableName, "%")) == null) {
                throw new ServiceException(Status.DATASOURCE_CONNECT_FAILED);
            }
            while (rs.next()) {
                columnList.add(rs.getString(COLUMN_NAME));
            }
        }
        catch (Exception e) {
            try {
                log.error("Get datasource table columns error, datasourceId:{}.", (Object)dataSource.getId(), (Object)e);
                throw new ServiceException(Status.DATASOURCE_CONNECT_FAILED);
            }
            catch (Throwable throwable) {
                DataSourceServiceImpl.closeResult(rs);
                DataSourceServiceImpl.releaseConnection(connection);
                throw throwable;
            }
        }
        DataSourceServiceImpl.closeResult(rs);
        DataSourceServiceImpl.releaseConnection(connection);
        List<ParamsOptions> options = this.getParamsOptions(columnList);
        return options;
    }

    @Override
    public List<ParamsOptions> getDatabases(Integer datasourceId) {
        ArrayList<String> tableList;
        DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)datasourceId);
        if (dataSource == null) {
            throw new ServiceException(Status.QUERY_DATASOURCE_ERROR);
        }
        BaseConnectionParam connectionParam = (BaseConnectionParam)DataSourceUtils.buildConnectionParams((DbType)dataSource.getType(), (String)dataSource.getConnectionParams());
        if (null == connectionParam) {
            throw new ServiceException(Status.DATASOURCE_CONNECT_FAILED);
        }
        Connection connection = DataSourceUtils.getConnection((DbType)dataSource.getType(), (ConnectionParam)connectionParam);
        ResultSet rs = null;
        try {
            if (null == connection) {
                throw new ServiceException(Status.DATASOURCE_CONNECT_FAILED);
            }
            rs = dataSource.getType() == DbType.POSTGRESQL ? connection.createStatement().executeQuery("SELECT datname FROM pg_database") : connection.createStatement().executeQuery("show databases");
            tableList = new ArrayList<String>();
            while (rs.next()) {
                String name = rs.getString(1);
                tableList.add(name);
            }
        }
        catch (Exception e) {
            try {
                log.error("Get databases error, datasourceId:{}.", (Object)datasourceId, (Object)e);
                throw new ServiceException(Status.GET_DATASOURCE_TABLES_ERROR);
            }
            catch (Throwable throwable) {
                DataSourceServiceImpl.closeResult(rs);
                DataSourceServiceImpl.releaseConnection(connection);
                throw throwable;
            }
        }
        DataSourceServiceImpl.closeResult(rs);
        DataSourceServiceImpl.releaseConnection(connection);
        List<ParamsOptions> options = this.getParamsOptions(tableList);
        return options;
    }

    private List<ParamsOptions> getParamsOptions(List<String> columnList) {
        ArrayList<ParamsOptions> options = null;
        if (CollectionUtils.isNotEmpty(columnList)) {
            options = new ArrayList<ParamsOptions>();
            for (String column : columnList) {
                ParamsOptions childrenOption = new ParamsOptions(column, (Object)column, false);
                options.add(childrenOption);
            }
        }
        return options;
    }

    private String getDbSchemaPattern(DbType dbType, String schema, BaseConnectionParam connectionParam) {
        if (dbType == null) {
            return null;
        }
        String schemaPattern = null;
        switch (dbType) {
            case HIVE: {
                schemaPattern = connectionParam.getDatabase();
                break;
            }
            case ORACLE: {
                schemaPattern = connectionParam.getUser();
                if (null == schemaPattern) break;
                schemaPattern = schemaPattern.toUpperCase();
                break;
            }
            case SQLSERVER: {
                schemaPattern = "dbo";
                break;
            }
            case CLICKHOUSE: 
            case DATABEND: 
            case PRESTO: {
                if (StringUtils.isEmpty((CharSequence)schema)) break;
                schemaPattern = schema;
                break;
            }
        }
        return schemaPattern;
    }

    private static void releaseConnection(Connection connection) {
        if (null != connection) {
            try {
                connection.close();
            }
            catch (Exception e) {
                log.error("Connection release error", (Throwable)e);
            }
        }
    }

    private static void closeResult(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception e) {
                log.error("ResultSet close error", (Throwable)e);
            }
        }
    }
}

