/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.Date;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.DqExecuteResultService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.DqExecuteResultMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DqExecuteResultServiceImpl
extends BaseServiceImpl
implements DqExecuteResultService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DqExecuteResultServiceImpl.class);
    @Autowired
    private DqExecuteResultMapper dqExecuteResultMapper;

    @Override
    public Result queryResultListPaging(User loginUser, String searchVal, Integer state, Integer ruleType, String startTime, String endTime, Integer pageNo, Integer pageSize) {
        Result result = new Result();
        int[] statusArray = null;
        if (state != null) {
            statusArray = new int[]{state};
        }
        Date start = null;
        Date end = null;
        try {
            if (StringUtils.isNotEmpty((CharSequence)startTime)) {
                start = DateUtils.stringToDate((String)startTime);
            }
            if (StringUtils.isNotEmpty((CharSequence)endTime)) {
                end = DateUtils.stringToDate((String)endTime);
            }
        }
        catch (Exception e) {
            log.warn("Parameter startTime or endTime is invalid.");
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, new Object[]{"startTime,endTime"});
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        if (ruleType == null) {
            ruleType = -1;
        }
        IPage dqsResultPage = this.dqExecuteResultMapper.queryResultListPaging((IPage)page, searchVal, loginUser, statusArray, ruleType.intValue(), start, end);
        pageInfo.setTotal((int)dqsResultPage.getTotal());
        pageInfo.setTotalList(dqsResultPage.getRecords());
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }
}

