/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.EnvironmentDto;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.EnvironmentService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Environment;
import org.apache.dolphinscheduler.dao.entity.EnvironmentWorkerGroupRelation;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.EnvironmentMapper;
import org.apache.dolphinscheduler.dao.mapper.EnvironmentWorkerGroupRelationMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EnvironmentServiceImpl
extends BaseServiceImpl
implements EnvironmentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnvironmentServiceImpl.class);
    @Autowired
    private EnvironmentMapper environmentMapper;
    @Autowired
    private EnvironmentWorkerGroupRelationMapper relationMapper;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;

    @Override
    @Transactional
    public Map<String, Object> createEnvironment(User loginUser, String name, String config, String desc, String workerGroups) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.ENVIRONMENT, "security:environment:create")) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (this.checkDescriptionLength(desc)) {
            log.warn("Parameter description is too long.");
            this.putMsg(result, Status.DESCRIPTION_TOO_LONG_ERROR, new Object[0]);
            return result;
        }
        Map<String, Object> checkResult = this.checkParams(name, config, workerGroups);
        if (checkResult.get("status") != Status.SUCCESS) {
            return checkResult;
        }
        Environment environment = this.environmentMapper.queryByEnvironmentName(name);
        if (environment != null) {
            log.warn("Environment with the same name already exist, environmentName:{}.", (Object)environment.getName());
            this.putMsg(result, Status.ENVIRONMENT_NAME_EXISTS, name);
            return result;
        }
        Environment env = new Environment();
        env.setName(name);
        env.setConfig(config);
        env.setDescription(desc);
        env.setOperator(loginUser.getId());
        env.setCreateTime(new Date());
        env.setUpdateTime(new Date());
        long code = 0L;
        try {
            code = CodeGenerateUtils.getInstance().genCode();
            env.setCode(Long.valueOf(code));
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            log.error("Generate environment code error.", (Throwable)e);
        }
        if (code == 0L) {
            this.putMsg(result, Status.INTERNAL_SERVER_ERROR_ARGS, "Error generating environment code");
            return result;
        }
        if (this.environmentMapper.insert((Object)env) > 0) {
            List workerGroupList;
            if (!StringUtils.isEmpty((CharSequence)workerGroups) && CollectionUtils.isNotEmpty((Collection)(workerGroupList = (List)JSONUtils.parseObject((String)workerGroups, (TypeReference)new TypeReference<List<String>>(){})))) {
                workerGroupList.stream().forEach(workerGroup -> {
                    if (!StringUtils.isEmpty((CharSequence)workerGroup)) {
                        EnvironmentWorkerGroupRelation relation = new EnvironmentWorkerGroupRelation();
                        relation.setEnvironmentCode(env.getCode());
                        relation.setWorkerGroup(workerGroup);
                        relation.setOperator(loginUser.getId());
                        relation.setCreateTime(new Date());
                        relation.setUpdateTime(new Date());
                        this.relationMapper.insert((Object)relation);
                        log.info("Environment-WorkerGroup relation create complete, environmentName:{}, workerGroup:{}.", (Object)env.getName(), (Object)relation.getWorkerGroup());
                    }
                });
            }
            result.put("data", env.getCode());
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            this.permissionPostHandle(AuthorizationType.ENVIRONMENT, loginUser.getId(), Collections.singletonList(env.getId()), log);
            log.info("Environment create complete, name:{}.", (Object)env.getName());
        } else {
            log.error("Environment create error, name:{}.", (Object)env.getName());
            this.putMsg(result, Status.CREATE_ENVIRONMENT_ERROR, new Object[0]);
        }
        return result;
    }

    @Override
    public Result queryEnvironmentListPaging(User loginUser, Integer pageNo, Integer pageSize, String searchVal) {
        IPage environmentIPage;
        Result result = new Result();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        PageInfo<Object> pageInfo = new PageInfo<Object>(pageNo, pageSize);
        if (loginUser.getUserType().equals((Object)UserType.ADMIN_USER)) {
            environmentIPage = this.environmentMapper.queryEnvironmentListPaging((IPage)page, searchVal);
        } else {
            Set ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.ENVIRONMENT, loginUser.getId(), log);
            if (ids.isEmpty()) {
                result.setData(pageInfo);
                this.putMsg(result, Status.SUCCESS, new Object[0]);
                return result;
            }
            environmentIPage = this.environmentMapper.queryEnvironmentListPagingByIds(page, new ArrayList(ids), searchVal);
        }
        pageInfo.setTotal((int)environmentIPage.getTotal());
        if (CollectionUtils.isNotEmpty((Collection)environmentIPage.getRecords())) {
            Map relationMap = this.relationMapper.selectList(null).stream().collect(Collectors.groupingBy(EnvironmentWorkerGroupRelation::getEnvironmentCode, Collectors.mapping(EnvironmentWorkerGroupRelation::getWorkerGroup, Collectors.toList())));
            List dtoList = environmentIPage.getRecords().stream().map(environment -> {
                EnvironmentDto dto = new EnvironmentDto();
                BeanUtils.copyProperties((Object)environment, (Object)dto);
                List workerGroups = relationMap.getOrDefault(environment.getCode(), new ArrayList());
                dto.setWorkerGroups(workerGroups);
                return dto;
            }).collect(Collectors.toList());
            pageInfo.setTotalList(dtoList);
        } else {
            pageInfo.setTotalList(new ArrayList());
        }
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryAllEnvironmentList(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.ENVIRONMENT, loginUser.getId(), log);
        if (ids.isEmpty()) {
            result.put("data", Collections.emptyList());
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        List environmentList = this.environmentMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)environmentList)) {
            Map relationMap = this.relationMapper.selectList(null).stream().collect(Collectors.groupingBy(EnvironmentWorkerGroupRelation::getEnvironmentCode, Collectors.mapping(EnvironmentWorkerGroupRelation::getWorkerGroup, Collectors.toList())));
            List dtoList = environmentList.stream().map(environment -> {
                EnvironmentDto dto = new EnvironmentDto();
                BeanUtils.copyProperties((Object)environment, (Object)dto);
                List workerGroups = relationMap.getOrDefault(environment.getCode(), new ArrayList());
                dto.setWorkerGroups(workerGroups);
                return dto;
            }).collect(Collectors.toList());
            result.put("data", dtoList);
        } else {
            result.put("data", new ArrayList());
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryEnvironmentByCode(Long code) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Environment env = this.environmentMapper.queryByEnvironmentCode(code);
        if (env == null) {
            this.putMsg(result, Status.QUERY_ENVIRONMENT_BY_CODE_ERROR, code);
        } else {
            List<String> workerGroups = this.relationMapper.queryByEnvironmentCode(env.getCode()).stream().map(item -> item.getWorkerGroup()).collect(Collectors.toList());
            EnvironmentDto dto = new EnvironmentDto();
            BeanUtils.copyProperties((Object)env, (Object)dto);
            dto.setWorkerGroups(workerGroups);
            result.put("data", dto);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public Map<String, Object> queryEnvironmentByName(String name) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Environment env = this.environmentMapper.queryByEnvironmentName(name);
        if (env == null) {
            this.putMsg(result, Status.QUERY_ENVIRONMENT_BY_NAME_ERROR, name);
        } else {
            List<String> workerGroups = this.relationMapper.queryByEnvironmentCode(env.getCode()).stream().map(item -> item.getWorkerGroup()).collect(Collectors.toList());
            EnvironmentDto dto = new EnvironmentDto();
            BeanUtils.copyProperties((Object)env, (Object)dto);
            dto.setWorkerGroups(workerGroups);
            result.put("data", dto);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> deleteEnvironmentByCode(User loginUser, Long code) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.ENVIRONMENT, "security:environment:delete")) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        Long relatedTaskNumber = this.taskDefinitionMapper.selectCount((Wrapper)new QueryWrapper().lambda().eq(TaskDefinition::getEnvironmentCode, (Object)code));
        if (relatedTaskNumber > 0L) {
            log.warn("Delete environment failed because {} tasks is using it, environmentCode:{}.", (Object)relatedTaskNumber, (Object)code);
            this.putMsg(result, Status.DELETE_ENVIRONMENT_RELATED_TASK_EXISTS, new Object[0]);
            return result;
        }
        int delete = this.environmentMapper.deleteByCode(code);
        if (delete > 0) {
            this.relationMapper.delete((Wrapper)new QueryWrapper().lambda().eq(EnvironmentWorkerGroupRelation::getEnvironmentCode, (Object)code));
            log.info("Environment and relations delete complete, environmentCode:{}.", (Object)code);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            log.error("Environment delete error, environmentCode:{}.", (Object)code);
            this.putMsg(result, Status.DELETE_ENVIRONMENT_ERROR, new Object[0]);
        }
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> updateEnvironmentByCode(User loginUser, Long code, String name, String config, String desc, String workerGroups) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.ENVIRONMENT, "security:environment:update")) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        Map<String, Object> checkResult = this.checkParams(name, config, workerGroups);
        if (checkResult.get("status") != Status.SUCCESS) {
            return checkResult;
        }
        if (this.checkDescriptionLength(desc)) {
            log.warn("Parameter description is too long.");
            this.putMsg(result, Status.DESCRIPTION_TOO_LONG_ERROR, new Object[0]);
            return result;
        }
        Environment environment = this.environmentMapper.queryByEnvironmentName(name);
        if (environment != null && !environment.getCode().equals(code)) {
            log.warn("Environment with the same name already exist, name:{}.", (Object)environment.getName());
            this.putMsg(result, Status.ENVIRONMENT_NAME_EXISTS, name);
            return result;
        }
        Set workerGroupSet = !StringUtils.isEmpty((CharSequence)workerGroups) ? (Set)JSONUtils.parseObject((String)workerGroups, (TypeReference)new TypeReference<Set<String>>(){}) : new TreeSet();
        Set existWorkerGroupSet = this.relationMapper.queryByEnvironmentCode(code).stream().map(item -> item.getWorkerGroup()).collect(Collectors.toSet());
        Set deleteWorkerGroupSet = SetUtils.difference(existWorkerGroupSet, workerGroupSet).toSet();
        Set addWorkerGroupSet = SetUtils.difference(workerGroupSet, existWorkerGroupSet).toSet();
        checkResult = this.checkUsedEnvironmentWorkerGroupRelation(deleteWorkerGroupSet, name, code);
        if (checkResult.get("status") != Status.SUCCESS) {
            return checkResult;
        }
        Environment env = new Environment();
        env.setCode(code);
        env.setName(name);
        env.setConfig(config);
        env.setDescription(desc);
        env.setOperator(loginUser.getId());
        env.setUpdateTime(new Date());
        int update = this.environmentMapper.update((Object)env, (Wrapper)new UpdateWrapper().lambda().eq(Environment::getCode, (Object)code));
        if (update > 0) {
            deleteWorkerGroupSet.stream().forEach(key -> {
                if (StringUtils.isNotEmpty((CharSequence)key)) {
                    this.relationMapper.delete((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(EnvironmentWorkerGroupRelation::getEnvironmentCode, (Object)code)).eq(EnvironmentWorkerGroupRelation::getWorkerGroup, key));
                }
            });
            addWorkerGroupSet.stream().forEach(key -> {
                if (StringUtils.isNotEmpty((CharSequence)key)) {
                    EnvironmentWorkerGroupRelation relation = new EnvironmentWorkerGroupRelation();
                    relation.setEnvironmentCode(code);
                    relation.setWorkerGroup(key);
                    relation.setUpdateTime(new Date());
                    relation.setCreateTime(new Date());
                    relation.setOperator(loginUser.getId());
                    this.relationMapper.insert((Object)relation);
                }
            });
            log.info("Environment and relations update complete, environmentId:{}.", (Object)env.getId());
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            log.error("Environment update error, environmentId:{}.", (Object)env.getId());
            this.putMsg(result, Status.UPDATE_ENVIRONMENT_ERROR, name);
        }
        return result;
    }

    @Override
    public Map<String, Object> verifyEnvironment(String environmentName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isEmpty((CharSequence)environmentName)) {
            log.warn("parameter environment name is empty.");
            this.putMsg(result, Status.ENVIRONMENT_NAME_IS_NULL, new Object[0]);
            return result;
        }
        Environment environment = this.environmentMapper.queryByEnvironmentName(environmentName);
        if (environment != null) {
            log.warn("Environment with the same name already exist, name:{}.", (Object)environment.getName());
            this.putMsg(result, Status.ENVIRONMENT_NAME_EXISTS, environmentName);
            return result;
        }
        result.put("status", (Object)Status.SUCCESS);
        return result;
    }

    private Map<String, Object> checkUsedEnvironmentWorkerGroupRelation(Set<String> deleteKeySet, String environmentName, Long environmentCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String workerGroup : deleteKeySet) {
            List taskDefinitionList = this.taskDefinitionMapper.selectList((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(TaskDefinition::getEnvironmentCode, (Object)environmentCode)).eq(TaskDefinition::getWorkerGroup, (Object)workerGroup));
            if (!Objects.nonNull(taskDefinitionList) || taskDefinitionList.size() == 0) continue;
            Set collect = taskDefinitionList.stream().map(TaskDefinition::getName).collect(Collectors.toSet());
            log.warn("Environment {} and worker group {} is being used by task {}, so can not update.", new Object[]{((TaskDefinition)taskDefinitionList.get(0)).getEnvironmentCode(), ((TaskDefinition)taskDefinitionList.get(0)).getWorkerGroup(), collect});
            this.putMsg(result, Status.UPDATE_ENVIRONMENT_WORKER_GROUP_RELATION_ERROR, workerGroup, environmentName, collect);
            return result;
        }
        result.put("status", (Object)Status.SUCCESS);
        return result;
    }

    public Map<String, Object> checkParams(String name, String config, String workerGroups) {
        List workerGroupList;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isEmpty((CharSequence)name)) {
            log.warn("parameter environment name is empty.");
            this.putMsg(result, Status.ENVIRONMENT_NAME_IS_NULL, new Object[0]);
            return result;
        }
        if (StringUtils.isEmpty((CharSequence)config)) {
            log.warn("parameter environment config is empty.");
            this.putMsg(result, Status.ENVIRONMENT_CONFIG_IS_NULL, new Object[0]);
            return result;
        }
        if (!StringUtils.isEmpty((CharSequence)workerGroups) && Objects.isNull(workerGroupList = (List)JSONUtils.parseObject((String)workerGroups, (TypeReference)new TypeReference<List<String>>(){}))) {
            log.warn("Parameter worker groups list is invalid.");
            this.putMsg(result, Status.ENVIRONMENT_WORKER_GROUPS_IS_INVALID, new Object[0]);
            return result;
        }
        result.put("status", (Object)Status.SUCCESS);
        return result;
    }
}

