/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import java.util.List;
import lombok.Generated;
import org.apache.dolphinscheduler.api.metrics.ApiServerMetrics;
import org.apache.dolphinscheduler.api.rpc.ApiRpcClient;
import org.apache.dolphinscheduler.api.service.MetricsCleanUpService;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.apache.dolphinscheduler.remote.command.workflow.WorkflowMetricsCleanUpRequest;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MetricsCleanUpServiceImpl
implements MetricsCleanUpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsCleanUpServiceImpl.class);
    @Autowired
    private ApiRpcClient apiRpcClient;
    @Autowired
    private RegistryClient registryClient;

    @Override
    public void cleanUpWorkflowMetricsByDefinitionCode(String workflowDefinitionCode) {
        WorkflowMetricsCleanUpRequest workflowMetricsCleanUpRequest = new WorkflowMetricsCleanUpRequest();
        workflowMetricsCleanUpRequest.setProcessDefinitionCode(workflowDefinitionCode);
        List masterNodeList = this.registryClient.getServerList(RegistryNodeType.MASTER);
        for (Server server : masterNodeList) {
            try {
                String host = String.format("%s:%s", server.getHost(), server.getPort());
                this.apiRpcClient.send(Host.of((String)host), workflowMetricsCleanUpRequest.convert2Command());
            }
            catch (Exception e) {
                log.error("Fail to clean up workflow related metrics on {} when deleting workflow definition {}, error message {}", new Object[]{server.getHost(), workflowDefinitionCode, e.getMessage()});
            }
        }
    }

    @Override
    public void cleanUpApiResponseTimeMetricsByUserId(int userId) {
        ApiServerMetrics.cleanUpApiResponseTimeMetricsByUserId(userId);
    }
}

