/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.MonitorService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.model.WorkerServerModel;
import org.apache.dolphinscheduler.dao.MonitorDBDao;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MonitorServiceImpl
extends BaseServiceImpl
implements MonitorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitorServiceImpl.class);
    @Autowired
    private MonitorDBDao monitorDBDao;
    @Autowired
    private RegistryClient registryClient;

    @Override
    public Map<String, Object> queryDatabaseState(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List monitorRecordList = this.monitorDBDao.queryDatabaseState();
        result.put("data", monitorRecordList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryMaster(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<Server> masterServers = this.getServerListFromRegistry(true);
        result.put("data", masterServers);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryWorker(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List workerServers = this.getServerListFromRegistry(false).stream().map(server -> {
            WorkerServerModel model = new WorkerServerModel();
            model.setId(server.getId());
            model.setHost(server.getHost());
            model.setPort(server.getPort());
            model.setZkDirectories((Set)Sets.newHashSet((Object[])new String[]{server.getZkDirectory()}));
            model.setResInfo(server.getResInfo());
            model.setCreateTime(server.getCreateTime());
            model.setLastHeartbeatTime(server.getLastHeartbeatTime());
            return model;
        }).collect(Collectors.toList());
        Map workerHostPortServerMapping = workerServers.stream().collect(Collectors.toMap(worker -> {
            String[] s = ((String)worker.getZkDirectories().iterator().next()).split("/");
            return s[s.length - 1];
        }, Function.identity(), (oldOne, newOne) -> {
            oldOne.getZkDirectories().addAll(newOne.getZkDirectories());
            return oldOne;
        }));
        result.put("data", workerHostPortServerMapping.values());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public List<Server> getServerListFromRegistry(boolean isMaster) {
        return isMaster ? this.registryClient.getServerList(RegistryNodeType.MASTER) : this.registryClient.getServerList(RegistryNodeType.WORKER);
    }
}

