/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.DynamicSubWorkflowDto;
import org.apache.dolphinscheduler.api.dto.gantt.GanttDto;
import org.apache.dolphinscheduler.api.dto.gantt.Task;
import org.apache.dolphinscheduler.api.dto.workflowInstance.WorkflowInstanceQueryRequest;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.ExecutorService;
import org.apache.dolphinscheduler.api.service.LoggerService;
import org.apache.dolphinscheduler.api.service.ProcessDefinitionService;
import org.apache.dolphinscheduler.api.service.ProcessInstanceService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.TaskInstanceService;
import org.apache.dolphinscheduler.api.service.UsersService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.placeholder.BusinessTimeUtils;
import org.apache.dolphinscheduler.dao.AlertDao;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelationLog;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.RelationSubWorkflow;
import org.apache.dolphinscheduler.dao.entity.ResponseTaskLog;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.RelationSubWorkflowMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.dao.repository.ProcessInstanceDao;
import org.apache.dolphinscheduler.dao.repository.ProcessInstanceMapDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.dao.utils.WorkflowUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskPluginManager;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependResult;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parameters.ParametersNode;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.service.expand.CuringParamsService;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProcessInstanceServiceImpl
extends BaseServiceImpl
implements ProcessInstanceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessInstanceServiceImpl.class);
    public static final String TASK_TYPE = "taskType";
    public static final String LOCAL_PARAMS_LIST = "localParamsList";
    @Autowired
    ProjectMapper projectMapper;
    @Autowired
    ProjectService projectService;
    @Autowired
    ProcessService processService;
    @Autowired
    TaskInstanceDao taskInstanceDao;
    @Lazy
    @Autowired
    private TaskInstanceService taskInstanceService;
    @Autowired
    ProcessInstanceMapper processInstanceMapper;
    @Autowired
    ProcessInstanceDao processInstanceDao;
    @Autowired
    private ProcessInstanceMapDao processInstanceMapDao;
    @Autowired
    ProcessDefinitionMapper processDefineMapper;
    @Autowired
    ProcessDefinitionService processDefinitionService;
    @Autowired
    ExecutorService execService;
    @Autowired
    TaskInstanceMapper taskInstanceMapper;
    @Autowired
    LoggerService loggerService;
    @Autowired
    ProcessDefinitionLogMapper processDefinitionLogMapper;
    @Autowired
    TaskDefinitionLogMapper taskDefinitionLogMapper;
    @Autowired
    UsersService usersService;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private TaskPluginManager taskPluginManager;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private RelationSubWorkflowMapper relationSubWorkflowMapper;
    @Autowired
    private AlertDao alertDao;
    @Autowired
    private CuringParamsService curingGlobalParamsService;

    @Override
    public Map<String, Object> queryTopNLongestRunningProcessInstance(User loginUser, long projectCode, int size, String startTime, String endTime) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:process-instance:list");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (0 > size) {
            this.putMsg(result, Status.NEGTIVE_SIZE_NUMBER_ERROR, size);
            return result;
        }
        if (Objects.isNull(startTime)) {
            this.putMsg(result, Status.DATA_IS_NULL, "start time");
            return result;
        }
        Date start = DateUtils.stringToDate((String)startTime);
        if (Objects.isNull(endTime)) {
            this.putMsg(result, Status.DATA_IS_NULL, "end time");
            return result;
        }
        Date end = DateUtils.stringToDate((String)endTime);
        if (start == null || end == null) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "startDate,endDate");
            return result;
        }
        if (start.getTime() > end.getTime()) {
            this.putMsg(result, Status.START_TIME_BIGGER_THAN_END_TIME_ERROR, startTime, endTime);
            return result;
        }
        List processInstances = this.processInstanceMapper.queryTopNProcessInstance(size, start, end, WorkflowExecutionStatus.SUCCESS, projectCode);
        result.put("data", processInstances);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryProcessInstanceById(User loginUser, long projectCode, Integer processId) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:process-instance:list");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessInstance processInstance = (ProcessInstance)this.processService.findProcessInstanceDetailById(processId.intValue()).orElseThrow(() -> new ServiceException(Status.PROCESS_INSTANCE_NOT_EXIST, processId));
        ProcessDefinition processDefinition = this.processService.findProcessDefinition(processInstance.getProcessDefinitionCode(), processInstance.getProcessDefinitionVersion());
        if (processDefinition == null || projectCode != processDefinition.getProjectCode()) {
            log.error("Process definition does not exist, projectCode:{}.", (Object)projectCode);
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, processId);
        } else {
            processInstance.setLocations(processDefinition.getLocations());
            processInstance.setDagData(this.processService.genDagData(processDefinition));
            result.put("data", processInstance);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public ProcessInstance queryByWorkflowInstanceIdThrowExceptionIfNotFound(Integer workflowInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.processInstanceDao.queryById((Serializable)workflowInstanceId);
        if (processInstance == null) {
            throw new ServiceException(Status.PROCESS_INSTANCE_NOT_EXIST, workflowInstanceId);
        }
        return processInstance;
    }

    @Override
    public Map<String, Object> queryProcessInstanceById(User loginUser, Integer workflowInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.processInstanceMapper.selectById((Serializable)workflowInstanceId);
        ProcessDefinition processDefinition = this.processDefineMapper.queryByCode(processInstance.getProcessDefinitionCode().longValue());
        return this.queryProcessInstanceById(loginUser, processDefinition.getProjectCode(), workflowInstanceId);
    }

    @Override
    public Result<PageInfo<ProcessInstance>> queryProcessInstanceList(User loginUser, long projectCode, long processDefineCode, String startDate, String endDate, String searchVal, String executorName, WorkflowExecutionStatus stateType, String host, String otherParamsJson, Integer pageNo, Integer pageSize) {
        Result<PageInfo<ProcessInstance>> result = new Result<PageInfo<ProcessInstance>>();
        Project project = this.projectMapper.queryByCode(projectCode);
        this.projectService.checkProjectAndAuthThrowException(loginUser, project, "project:process-instance:list");
        int[] statusArray = null;
        if (stateType != null) {
            statusArray = new int[]{stateType.getCode()};
        }
        Date start = this.checkAndParseDateParameters(startDate);
        Date end = this.checkAndParseDateParameters(endDate);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        IPage processInstanceList = this.processInstanceMapper.queryProcessInstanceListPaging(page, Long.valueOf(project.getCode()), Long.valueOf(processDefineCode), searchVal, executorName, statusArray, host, start, end);
        List processInstances = processInstanceList.getRecords();
        List<Integer> userIds = Collections.emptyList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)processInstances)) {
            userIds = processInstances.stream().map(ProcessInstance::getExecutorId).collect(Collectors.toList());
        }
        List<User> users = this.usersService.queryUser(userIds);
        Map<Object, Object> idToUserMap = Collections.emptyMap();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(users)) {
            idToUserMap = users.stream().collect(Collectors.toMap(User::getId, Function.identity()));
        }
        for (ProcessInstance processInstance : processInstances) {
            processInstance.setDuration(WorkflowUtils.getWorkflowInstanceDuration((ProcessInstance)processInstance));
            User executor = (User)idToUserMap.get(processInstance.getExecutorId());
            if (null == executor) continue;
            processInstance.setExecutorName(executor.getUserName());
        }
        pageInfo.setTotal((int)processInstanceList.getTotal());
        pageInfo.setTotalList(processInstances);
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result queryProcessInstanceList(User loginUser, WorkflowInstanceQueryRequest workflowInstanceQueryRequest) {
        Result result = new Result();
        ProcessInstance processInstance = workflowInstanceQueryRequest.convert2ProcessInstance();
        String projectName = workflowInstanceQueryRequest.getProjectName();
        if (!StringUtils.isBlank((CharSequence)projectName)) {
            Project project = this.projectMapper.queryByName(projectName);
            this.projectService.checkProjectAndAuthThrowException(loginUser, project, "project:definition:list");
            ProcessDefinition processDefinition = this.processDefineMapper.queryByDefineName(project.getCode(), processInstance.getName());
            processInstance.setProcessDefinitionCode(Long.valueOf(processDefinition.getCode()));
            processInstance.setProjectCode(Long.valueOf(project.getCode()));
        }
        Page page = new Page((long)workflowInstanceQueryRequest.getPageNo().intValue(), (long)workflowInstanceQueryRequest.getPageSize().intValue());
        PageInfo pageInfo = new PageInfo(workflowInstanceQueryRequest.getPageNo(), workflowInstanceQueryRequest.getPageSize());
        IPage processInstanceList = this.processInstanceMapper.queryProcessInstanceListV2Paging(page, processInstance.getProjectCode(), processInstance.getProcessDefinitionCode(), processInstance.getName(), workflowInstanceQueryRequest.getStartTime(), workflowInstanceQueryRequest.getEndTime(), workflowInstanceQueryRequest.getState(), processInstance.getHost());
        List processInstances = processInstanceList.getRecords();
        List<Integer> userIds = Collections.emptyList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)processInstances)) {
            userIds = processInstances.stream().map(ProcessInstance::getExecutorId).collect(Collectors.toList());
        }
        List<User> users = this.usersService.queryUser(userIds);
        Map<Object, Object> idToUserMap = Collections.emptyMap();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(users)) {
            idToUserMap = users.stream().collect(Collectors.toMap(User::getId, Function.identity()));
        }
        for (ProcessInstance Instance2 : processInstances) {
            Instance2.setDuration(WorkflowUtils.getWorkflowInstanceDuration((ProcessInstance)Instance2));
            User executor = (User)idToUserMap.get(Instance2.getExecutorId());
            if (null == executor) continue;
            Instance2.setExecutorName(executor.getUserName());
        }
        pageInfo.setTotal((int)processInstanceList.getTotal());
        pageInfo.setTotalList(processInstances);
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryTaskListByProcessId(User loginUser, long projectCode, Integer processId) throws IOException {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:process-instance:list");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessInstance processInstance = (ProcessInstance)this.processService.findProcessInstanceDetailById(processId.intValue()).orElseThrow(() -> new ServiceException(Status.PROCESS_INSTANCE_NOT_EXIST, processId));
        ProcessDefinition processDefinition = this.processDefineMapper.queryByCode(processInstance.getProcessDefinitionCode().longValue());
        if (processDefinition != null && projectCode != processDefinition.getProjectCode()) {
            log.error("Process definition does not exist, projectCode:{}, processDefinitionId:{}.", (Object)projectCode, (Object)processId);
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_EXIST, processId);
            return result;
        }
        List taskInstanceList = this.taskInstanceDao.queryValidTaskListByWorkflowInstanceId(processId, processInstance.getTestFlag());
        this.addDependResultForTaskList(loginUser, taskInstanceList);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("processInstanceState", processInstance.getState().toString());
        resultMap.put("taskList", taskInstanceList);
        result.put("data", resultMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public List<DynamicSubWorkflowDto> queryDynamicSubWorkflowInstances(User loginUser, Integer taskId) {
        int subWorkflowVersion;
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceDao.queryById((Serializable)taskId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (taskInstance == null) {
            this.putMsg(result, Status.TASK_INSTANCE_NOT_EXISTS, taskId);
            throw new ServiceException(Status.TASK_INSTANCE_NOT_EXISTS, taskId);
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskInstance.getTaskCode());
        if (taskDefinition == null) {
            this.putMsg(result, Status.TASK_INSTANCE_NOT_EXISTS, taskId);
            throw new ServiceException(Status.TASK_INSTANCE_NOT_EXISTS, taskId);
        }
        if (!taskInstance.isDynamic()) {
            this.putMsg(result, Status.TASK_INSTANCE_NOT_DYNAMIC_TASK, taskInstance.getName());
            throw new ServiceException(Status.TASK_INSTANCE_NOT_EXISTS, taskId);
        }
        List relationSubWorkflows = this.relationSubWorkflowMapper.queryAllSubProcessInstance(Long.valueOf(taskInstance.getProcessInstanceId()), Long.valueOf(taskInstance.getTaskCode()));
        List allSubProcessInstanceId = relationSubWorkflows.stream().map(RelationSubWorkflow::getSubWorkflowInstanceId).collect(Collectors.toList());
        List allSubWorkflows = this.processInstanceDao.queryByIds(allSubProcessInstanceId);
        if (allSubWorkflows == null || allSubWorkflows.isEmpty()) {
            this.putMsg(result, Status.SUB_PROCESS_INSTANCE_NOT_EXIST, taskId);
            throw new ServiceException(Status.SUB_PROCESS_INSTANCE_NOT_EXIST, taskId);
        }
        Long subWorkflowCode = ((ProcessInstance)allSubWorkflows.get(0)).getProcessDefinitionCode();
        ProcessDefinition subProcessDefinition = this.processService.findProcessDefinition(subWorkflowCode, subWorkflowVersion = ((ProcessInstance)allSubWorkflows.get(0)).getProcessDefinitionVersion());
        if (subProcessDefinition == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, subWorkflowCode);
            throw new ServiceException(Status.PROCESS_DEFINE_NOT_EXIST, subWorkflowCode);
        }
        allSubWorkflows.sort(Comparator.comparing(ProcessInstance::getId));
        ArrayList<DynamicSubWorkflowDto> allDynamicSubWorkflowDtos = new ArrayList<DynamicSubWorkflowDto>();
        int index = 1;
        for (ProcessInstance processInstance : allSubWorkflows) {
            DynamicSubWorkflowDto dynamicSubWorkflowDto = new DynamicSubWorkflowDto();
            dynamicSubWorkflowDto.setProcessInstanceId(processInstance.getId().intValue());
            dynamicSubWorkflowDto.setIndex(index);
            dynamicSubWorkflowDto.setState(processInstance.getState());
            dynamicSubWorkflowDto.setName(subProcessDefinition.getName());
            Map commandParamMap = JSONUtils.toMap((String)processInstance.getCommandParam());
            String parameter = (String)commandParamMap.get("dynamicParams");
            dynamicSubWorkflowDto.setParameters(JSONUtils.toMap((String)parameter));
            allDynamicSubWorkflowDtos.add(dynamicSubWorkflowDto);
            ++index;
        }
        return allDynamicSubWorkflowDtos;
    }

    private void addDependResultForTaskList(User loginUser, List<TaskInstance> taskInstanceList) throws IOException {
        for (TaskInstance taskInstance : taskInstanceList) {
            if (!"DEPENDENT".equalsIgnoreCase(taskInstance.getTaskType())) continue;
            log.info("DEPENDENT type task instance need to set dependent result, taskCode:{}, taskInstanceId:{}", (Object)taskInstance.getTaskCode(), (Object)taskInstance.getId());
            Result<ResponseTaskLog> logResult = this.loggerService.queryLog(loginUser, taskInstance.getId(), 0, 4096);
            if (logResult.getCode().intValue() != Status.SUCCESS.ordinal()) continue;
            String log = logResult.getData().getMessage();
            Map<String, DependResult> resultMap = this.parseLogForDependentResult(log);
            taskInstance.setDependentResult(JSONUtils.toJsonString(resultMap));
        }
    }

    @Override
    public Map<String, DependResult> parseLogForDependentResult(String content) throws IOException {
        String line;
        HashMap<String, DependResult> resultMap = new HashMap<String, DependResult>();
        if (StringUtils.isEmpty((CharSequence)content)) {
            log.warn("Log content is empty.");
            return resultMap;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
        while ((line = br.readLine()) != null) {
            String dependResultString;
            String[] dependStringArray;
            String[] tmpStringArray;
            if (!line.contains(":||") || (tmpStringArray = line.split(":\\|\\|")).length != 2 || (dependStringArray = (dependResultString = tmpStringArray[1]).split(",")).length != 3) continue;
            String key = dependStringArray[0].trim().split(":")[1].trim();
            String result = dependStringArray[1].trim().split(":")[1].trim();
            DependResult dependResult = DependResult.valueOf((String)result);
            resultMap.put(key, dependResult);
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> querySubProcessInstanceByTaskId(User loginUser, long projectCode, Integer taskId) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:process-instance:list");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceDao.queryById((Serializable)taskId);
        if (taskInstance == null) {
            log.error("Task instance does not exist, projectCode:{}, taskInstanceId{}.", (Object)projectCode, (Object)taskId);
            this.putMsg(result, Status.TASK_INSTANCE_NOT_EXISTS, taskId);
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskInstance.getTaskCode());
        if (taskDefinition != null && projectCode != taskDefinition.getProjectCode()) {
            log.error("Task definition does not exist, projectCode:{}, taskDefinitionCode:{}.", (Object)projectCode, (Object)taskInstance.getTaskCode());
            this.putMsg(result, Status.TASK_INSTANCE_NOT_EXISTS, taskId);
            return result;
        }
        if (!taskInstance.isSubProcess()) {
            log.warn("Task instance is not {} type instance, projectCode:{}, taskInstanceId:{}.", new Object[]{"SUB_PROCESS", projectCode, taskId});
            this.putMsg(result, Status.TASK_INSTANCE_NOT_SUB_WORKFLOW_INSTANCE, taskInstance.getName());
            return result;
        }
        ProcessInstance subWorkflowInstance = this.processService.findSubProcessInstance(Integer.valueOf(taskInstance.getProcessInstanceId()), taskInstance.getId());
        if (subWorkflowInstance == null) {
            log.error("SubProcess instance does not exist, projectCode:{}, taskInstanceId:{}.", (Object)projectCode, (Object)taskInstance.getId());
            this.putMsg(result, Status.SUB_PROCESS_INSTANCE_NOT_EXIST, taskId);
            return result;
        }
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
        dataMap.put("subProcessInstanceId", subWorkflowInstance.getId());
        result.put("data", dataMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> updateProcessInstance(User loginUser, long projectCode, Integer processInstanceId, String taskRelationJson, String taskDefinitionJson, String scheduleTime, Boolean syncDefine, String globalParams, String locations, int timeout) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:process-instance:update");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessInstance processInstance = (ProcessInstance)this.processService.findProcessInstanceDetailById(processInstanceId.intValue()).orElseThrow(() -> new ServiceException(Status.PROCESS_INSTANCE_NOT_EXIST, processInstanceId));
        ProcessDefinition processDefinition0 = this.processDefineMapper.queryByCode(processInstance.getProcessDefinitionCode().longValue());
        if (processDefinition0 != null && projectCode != processDefinition0.getProjectCode()) {
            log.error("Process definition does not exist, projectCode:{}, processDefinitionCode:{}.", (Object)projectCode, (Object)processInstance.getProcessDefinitionCode());
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_EXIST, processInstanceId);
            return result;
        }
        if (!processInstance.getState().isFinished()) {
            log.warn("Process Instance state is {} so can not update process instance, processInstanceId:{}.", (Object)processInstance.getState().getDesc(), (Object)processInstanceId);
            this.putMsg(result, Status.PROCESS_INSTANCE_STATE_OPERATION_ERROR, processInstance.getName(), processInstance.getState().toString(), "update");
            return result;
        }
        Map commandParamMap = JSONUtils.toMap((String)processInstance.getCommandParam());
        String timezoneId = null;
        timezoneId = commandParamMap == null || StringUtils.isBlank((CharSequence)((CharSequence)commandParamMap.get("schedule_timezone"))) ? loginUser.getTimeZone() : (String)commandParamMap.get("schedule_timezone");
        this.setProcessInstance(processInstance, scheduleTime, globalParams, timeout, timezoneId);
        List taskDefinitionLogs = JSONUtils.toList((String)taskDefinitionJson, TaskDefinitionLog.class);
        if (taskDefinitionLogs.isEmpty()) {
            log.warn("Parameter taskDefinitionJson is empty");
            this.putMsg(result, Status.DATA_IS_NOT_VALID, taskDefinitionJson);
            return result;
        }
        for (TaskDefinitionLog taskDefinitionLog : taskDefinitionLogs) {
            if (this.taskPluginManager.checkTaskParameters(ParametersNode.builder().taskType(taskDefinitionLog.getTaskType()).taskParams(taskDefinitionLog.getTaskParams()).dependence(taskDefinitionLog.getDependence()).build())) continue;
            log.error("Task parameters are invalid,  taskDefinitionName:{}.", (Object)taskDefinitionLog.getName());
            this.putMsg(result, Status.PROCESS_NODE_S_PARAMETER_INVALID, taskDefinitionLog.getName());
            return result;
        }
        int saveTaskResult = this.processService.saveTaskDefine(loginUser, projectCode, taskDefinitionLogs, syncDefine);
        if (saveTaskResult == -1) {
            log.error("Update task definition error, projectCode:{}, processInstanceId:{}", (Object)projectCode, (Object)processInstanceId);
            this.putMsg(result, Status.UPDATE_TASK_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_TASK_DEFINITION_ERROR);
        }
        ProcessDefinition processDefinition = this.processDefineMapper.queryByCode(processInstance.getProcessDefinitionCode().longValue());
        List taskRelationList = JSONUtils.toList((String)taskRelationJson, ProcessTaskRelationLog.class);
        result = this.processDefinitionService.checkProcessNodeList(taskRelationJson, taskDefinitionLogs);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        processDefinition.set(projectCode, processDefinition.getName(), processDefinition.getDescription(), globalParams, locations, timeout);
        processDefinition.setUpdateTime(new Date());
        int insertVersion = this.processService.saveProcessDefine(loginUser, processDefinition, syncDefine, Boolean.FALSE);
        if (insertVersion == 0) {
            log.error("Update process definition error, projectCode:{}, processDefinitionName:{}.", (Object)projectCode, (Object)processDefinition.getName());
            this.putMsg(result, Status.UPDATE_PROCESS_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_PROCESS_DEFINITION_ERROR);
        }
        log.info("Update process definition complete, projectCode:{}, processDefinitionName:{}.", (Object)projectCode, (Object)processDefinition.getName());
        int insertResult = this.processService.saveTaskRelation(loginUser, processDefinition.getProjectCode(), processDefinition.getCode(), insertVersion, taskRelationList, taskDefinitionLogs, syncDefine);
        if (insertResult != 0) {
            log.info("Update task relations error, projectCode:{}, processDefinitionCode:{}, processDefinitionVersion:{}.", new Object[]{projectCode, processDefinition.getCode(), insertVersion});
            this.putMsg(result, Status.UPDATE_PROCESS_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_PROCESS_DEFINITION_ERROR);
        }
        log.info("Update task relations complete, projectCode:{}, processDefinitionCode:{}, processDefinitionVersion:{}.", new Object[]{projectCode, processDefinition.getCode(), insertVersion});
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", processDefinition);
        processInstance.setProcessDefinitionVersion(insertVersion);
        boolean update = this.processInstanceDao.updateById((Object)processInstance);
        if (!update) {
            log.error("Update process instance version error, projectCode:{}, processDefinitionCode:{}, processDefinitionVersion:{}", new Object[]{projectCode, processDefinition.getCode(), insertVersion});
            this.putMsg(result, Status.UPDATE_PROCESS_INSTANCE_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_PROCESS_INSTANCE_ERROR);
        }
        log.info("Update process instance complete, projectCode:{}, processDefinitionCode:{}, processDefinitionVersion:{}, processInstanceId:{}", new Object[]{projectCode, processDefinition.getCode(), insertVersion, processInstanceId});
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private void setProcessInstance(ProcessInstance processInstance, String scheduleTime, String globalParams, int timeout, String timezone) {
        Date schedule = processInstance.getScheduleTime();
        if (scheduleTime != null) {
            schedule = DateUtils.stringToDate((String)scheduleTime);
        }
        processInstance.setScheduleTime(schedule);
        List globalParamList = JSONUtils.toList((String)globalParams, Property.class);
        Map<String, String> globalParamMap = globalParamList.stream().collect(Collectors.toMap(Property::getProp, Property::getValue));
        globalParams = this.curingGlobalParamsService.curingGlobalParams(processInstance.getId(), globalParamMap, globalParamList, processInstance.getCmdTypeIfComplement(), schedule, timezone);
        processInstance.setTimeout(timeout);
        processInstance.setGlobalParams(globalParams);
    }

    @Override
    public Map<String, Object> queryParentInstanceBySubId(User loginUser, long projectCode, Integer subId) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:process-instance:list");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessInstance subInstance = (ProcessInstance)this.processService.findProcessInstanceDetailById(subId.intValue()).orElseThrow(() -> new ServiceException(Status.PROCESS_INSTANCE_NOT_EXIST, subId));
        if (subInstance.getIsSubProcess() == Flag.NO) {
            log.warn("Process instance is not sub process instance type, processInstanceId:{}, processInstanceName:{}.", (Object)subId, (Object)subInstance.getName());
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_SUB_PROCESS_INSTANCE, subInstance.getName());
            return result;
        }
        ProcessInstance parentWorkflowInstance = this.processService.findParentProcessInstance(subId);
        if (parentWorkflowInstance == null) {
            log.error("Parent process instance does not exist, projectCode:{}, subProcessInstanceId:{}.", (Object)projectCode, (Object)subId);
            this.putMsg(result, Status.SUB_PROCESS_INSTANCE_NOT_EXIST, new Object[0]);
            return result;
        }
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
        dataMap.put("parentWorkflowInstance", parentWorkflowInstance.getId());
        result.put("data", dataMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public void deleteProcessInstanceById(User loginUser, Integer processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.processService.findProcessInstanceDetailById(processInstanceId.intValue()).orElseThrow(() -> new ServiceException(Status.PROCESS_INSTANCE_NOT_EXIST, processInstanceId));
        ProcessDefinitionLog processDefinition = this.processDefinitionLogMapper.queryByDefinitionCodeAndVersion(processInstance.getProcessDefinitionCode().longValue(), processInstance.getProcessDefinitionVersion());
        Project project = this.projectMapper.queryByCode(processDefinition.getProjectCode());
        this.projectService.checkProjectAndAuthThrowException(loginUser, project, "project:process-instance:delete");
        if (!processInstance.getState().isFinished()) {
            log.warn("Process Instance state is {} so can not delete process instance, processInstanceId:{}.", (Object)processInstance.getState().getDesc(), (Object)processInstanceId);
            throw new ServiceException(Status.PROCESS_INSTANCE_STATE_OPERATION_ERROR, processInstance.getName(), processInstance.getState(), "delete");
        }
        this.deleteProcessInstanceById(processInstanceId);
    }

    @Override
    public Map<String, Object> viewVariables(long projectCode, Integer processInstanceId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ProcessInstance processInstance = this.processInstanceMapper.queryDetailById(processInstanceId.intValue());
        if (processInstance == null) {
            log.error("Process instance does not exist, projectCode:{}, processInstanceId:{}.", (Object)projectCode, (Object)processInstanceId);
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_EXIST, processInstanceId);
            return result;
        }
        ProcessDefinition processDefinition = this.processDefineMapper.queryByCode(processInstance.getProcessDefinitionCode().longValue());
        if (processDefinition != null && projectCode != processDefinition.getProjectCode()) {
            log.error("Process definition does not exist, projectCode:{}, processDefinitionCode:{}.", (Object)projectCode, (Object)processInstance.getProcessDefinitionCode());
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_EXIST, processInstanceId);
            return result;
        }
        Map commandParam = JSONUtils.toMap((String)processInstance.getCommandParam());
        String timezone = null;
        if (commandParam != null) {
            timezone = (String)commandParam.get("schedule_timezone");
        }
        Map timeParams = BusinessTimeUtils.getBusinessTime((CommandType)processInstance.getCmdTypeIfComplement(), (Date)processInstance.getScheduleTime(), (String)timezone);
        String userDefinedParams = processInstance.getGlobalParams();
        List globalParams = new ArrayList();
        String globalParamStr = ParameterUtils.convertParameterPlaceholders((String)JSONUtils.toJsonString(globalParams), (Map)timeParams);
        globalParams = JSONUtils.toList((String)globalParamStr, Property.class);
        for (Property property : globalParams) {
            timeParams.put(property.getProp(), property.getValue());
        }
        if (userDefinedParams != null && userDefinedParams.length() > 0) {
            globalParams = JSONUtils.toList((String)userDefinedParams, Property.class);
        }
        Map<String, Map<String, Object>> localUserDefParams = this.getLocalParams(processInstance, timeParams);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("globalParams", globalParams);
        resultMap.put("localParams", localUserDefParams);
        result.put("data", resultMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private Map<String, Map<String, Object>> getLocalParams(ProcessInstance processInstance, Map<String, String> timeParams) {
        HashMap<String, Map<String, Object>> localUserDefParams = new HashMap<String, Map<String, Object>>();
        List taskInstanceList = this.taskInstanceMapper.findValidTaskListByProcessId(processInstance.getId(), Flag.YES, processInstance.getTestFlag());
        for (TaskInstance taskInstance : taskInstanceList) {
            TaskDefinitionLog taskDefinitionLog = this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(taskInstance.getTaskCode(), taskInstance.getTaskDefinitionVersion());
            String localParams = JSONUtils.getNodeString((String)taskDefinitionLog.getTaskParams(), (String)"localParams");
            if (StringUtils.isEmpty((CharSequence)localParams)) continue;
            localParams = ParameterUtils.convertParameterPlaceholders((String)localParams, timeParams);
            List localParamsList = JSONUtils.toList((String)localParams, Property.class);
            HashMap<String, Object> localParamsMap = new HashMap<String, Object>();
            localParamsMap.put(TASK_TYPE, taskDefinitionLog.getTaskType());
            localParamsMap.put(LOCAL_PARAMS_LIST, localParamsList);
            if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)localParamsList)) continue;
            localUserDefParams.put(taskDefinitionLog.getName(), localParamsMap);
        }
        return localUserDefParams;
    }

    @Override
    public Map<String, Object> viewGantt(long projectCode, Integer processInstanceId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ProcessInstance processInstance = this.processInstanceMapper.queryDetailById(processInstanceId.intValue());
        if (processInstance == null) {
            log.error("Process instance does not exist, projectCode:{}, processInstanceId:{}.", (Object)projectCode, (Object)processInstanceId);
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_EXIST, processInstanceId);
            return result;
        }
        ProcessDefinitionLog processDefinition = this.processDefinitionLogMapper.queryByDefinitionCodeAndVersion(processInstance.getProcessDefinitionCode().longValue(), processInstance.getProcessDefinitionVersion());
        if (processDefinition == null || projectCode != processDefinition.getProjectCode()) {
            log.error("Process definition does not exist, projectCode:{}, processDefinitionCode:{}.", (Object)projectCode, (Object)processInstance.getProcessDefinitionCode());
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_EXIST, processInstanceId);
            return result;
        }
        GanttDto ganttDto = new GanttDto();
        DAG dag = this.processService.genDagGraph((ProcessDefinition)processDefinition);
        List nodeList = dag.topologicalSort();
        ganttDto.setTaskNames(nodeList);
        ArrayList<Task> taskList = new ArrayList<Task>();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)nodeList)) {
            List taskInstances = this.taskInstanceMapper.queryByProcessInstanceIdsAndTaskCodes(Collections.singletonList(processInstanceId), nodeList);
            for (Long node : nodeList) {
                TaskInstance taskInstance = null;
                for (TaskInstance instance : taskInstances) {
                    if (instance.getProcessInstanceId() != processInstanceId.intValue() || instance.getTaskCode() != node.longValue()) continue;
                    taskInstance = instance;
                    break;
                }
                if (taskInstance == null) continue;
                Date startTime = taskInstance.getStartTime() == null ? new Date() : taskInstance.getStartTime();
                Date endTime = taskInstance.getEndTime() == null ? new Date() : taskInstance.getEndTime();
                Task task = new Task();
                task.setTaskName(taskInstance.getName());
                task.getStartDate().add(startTime.getTime());
                task.getEndDate().add(endTime.getTime());
                task.setIsoStart(startTime);
                task.setIsoEnd(endTime);
                task.setStatus(taskInstance.getState().name());
                task.setExecutionDate(taskInstance.getStartTime());
                task.setDuration(DateUtils.format2Readable((long)(endTime.getTime() - startTime.getTime())));
                taskList.add(task);
            }
        }
        ganttDto.setTasks(taskList);
        result.put("data", ganttDto);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public List<ProcessInstance> queryByProcessDefineCodeAndStatus(Long processDefinitionCode, int[] states) {
        return this.processInstanceMapper.queryByProcessDefineCodeAndStatus(processDefinitionCode, states);
    }

    @Override
    public List<ProcessInstance> queryByProcessDefineCode(Long processDefinitionCode, int size) {
        return this.processInstanceMapper.queryByProcessDefineCode(processDefinitionCode, size);
    }

    @Override
    public Map<String, Object> queryByTriggerCode(User loginUser, long projectCode, Long triggerCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:process-instance:list");
        if (result.get("status") != Status.SUCCESS || triggerCode == null) {
            return result;
        }
        List processInstances = this.processInstanceMapper.queryByTriggerCode(triggerCode);
        result.put("data", processInstances);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public void deleteProcessInstanceByWorkflowDefinitionCode(long workflowDefinitionCode) {
        List processInstances;
        while (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)(processInstances = this.processInstanceMapper.queryByProcessDefineCode(Long.valueOf(workflowDefinitionCode), 100)))) {
            log.info("Begin to delete workflow instance, workflow definition code: {}", (Object)workflowDefinitionCode);
            for (ProcessInstance processInstance : processInstances) {
                if (!processInstance.getState().isFinished()) {
                    log.warn("Workflow instance is not finished cannot delete, process instance id:{}", (Object)processInstance.getId());
                    throw new ServiceException(Status.PROCESS_INSTANCE_STATE_OPERATION_ERROR, processInstance.getName(), processInstance.getState(), "delete");
                }
                this.deleteProcessInstanceById(processInstance.getId());
            }
            log.info("Success delete workflow instance, workflow definition code: {}, size: {}", (Object)workflowDefinitionCode, (Object)processInstances.size());
        }
    }

    @Override
    public void deleteProcessInstanceById(int workflowInstanceId) {
        this.taskInstanceService.deleteByWorkflowInstanceId(workflowInstanceId);
        this.deleteSubWorkflowInstanceIfNeeded(workflowInstanceId);
        this.alertDao.deleteByWorkflowInstanceId(Integer.valueOf(workflowInstanceId));
        this.processInstanceDao.deleteById((Serializable)Integer.valueOf(workflowInstanceId));
    }

    private void deleteSubWorkflowInstanceIfNeeded(int workflowInstanceId) {
        List subWorkflowInstanceIds = this.processInstanceMapDao.querySubWorkflowInstanceIds(workflowInstanceId);
        if (CollectionUtils.isEmpty((Collection)subWorkflowInstanceIds)) {
            return;
        }
        for (Integer subWorkflowInstanceId : subWorkflowInstanceIds) {
            this.deleteProcessInstanceById(subWorkflowInstanceId);
        }
        this.processInstanceMapDao.deleteByParentId(workflowInstanceId);
    }
}

