/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.TaskGroupService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.ProjectUser;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectUserMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectServiceImpl
extends BaseServiceImpl
implements ProjectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectServiceImpl.class);
    @Lazy
    @Autowired
    private TaskGroupService taskGroupService;
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProjectUserMapper projectUserMapper;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;
    @Autowired
    private UserMapper userMapper;

    @Override
    @Transactional
    public Result createProject(User loginUser, String name, String desc) {
        Result<Project> result = new Result<Project>();
        ProjectServiceImpl.checkDesc(result, desc);
        if (result.getCode().intValue() != Status.SUCCESS.getCode()) {
            return result;
        }
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.PROJECTS, "project:create")) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        Project project = this.projectMapper.queryByName(name);
        if (project != null) {
            log.warn("Project {} already exists.", (Object)project.getName());
            this.putMsg(result, Status.PROJECT_ALREADY_EXISTS, new Object[]{name});
            return result;
        }
        Date now = new Date();
        try {
            project = Project.builder().name(name).code(CodeGenerateUtils.getInstance().genCode()).description(desc).userId(loginUser.getId()).userName(loginUser.getUserName()).createTime(now).updateTime(now).build();
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            log.error("Generate process definition code error.", (Throwable)e);
            this.putMsg(result, Status.CREATE_PROJECT_ERROR, new Object[0]);
            return result;
        }
        if (this.projectMapper.insert((Object)project) > 0) {
            log.info("Project is created and id is :{}", (Object)project.getId());
            result.setData(project);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            this.permissionPostHandle(AuthorizationType.PROJECTS, loginUser.getId(), Collections.singletonList(project.getId()), log);
        } else {
            log.error("Project create error, projectName:{}.", (Object)project.getName());
            this.putMsg(result, Status.CREATE_PROJECT_ERROR, new Object[0]);
        }
        return result;
    }

    public static void checkDesc(Result result, String desc) {
        if (!StringUtils.isEmpty((CharSequence)desc) && desc.codePointCount(0, desc.length()) > 255) {
            log.warn("Parameter description check failed.");
            result.setCode(Status.REQUEST_PARAMS_NOT_VALID_ERROR.getCode());
            result.setMsg(MessageFormat.format(Status.REQUEST_PARAMS_NOT_VALID_ERROR.getMsg(), "desc length"));
        } else {
            result.setCode(Status.SUCCESS.getCode());
        }
    }

    @Override
    public Result queryByCode(User loginUser, long projectCode) {
        Result<Project> result = new Result<Project>();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndPerm = this.hasProjectAndPerm(loginUser, project, result, "project:view");
        if (!hasProjectAndPerm) {
            return result;
        }
        if (project != null) {
            result.setData(project);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public Map<String, Object> queryByName(User loginUser, String projectName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByName(projectName);
        boolean hasProjectAndPerm = this.hasProjectAndPerm(loginUser, project, result, "project:view");
        if (!hasProjectAndPerm) {
            return result;
        }
        if (project != null) {
            result.put("data", project);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public Map<String, Object> checkProjectAndAuth(User loginUser, Project project, long projectCode, String permission) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (project == null) {
            log.error("Project does not exist, projectCode:{}.", (Object)projectCode);
            this.putMsg(result, Status.PROJECT_NOT_EXIST, new Object[0]);
        } else if (!this.canOperatorPermissions(loginUser, new Object[]{project.getId()}, AuthorizationType.PROJECTS, permission)) {
            log.error("User does not have {} permission to operate project, userName:{}, projectCode:{}.", new Object[]{permission, loginUser.getUserName(), projectCode});
            this.putMsg(result, Status.USER_NO_OPERATION_PROJECT_PERM, loginUser.getUserName(), projectCode);
        } else {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public void checkProjectAndAuthThrowException(@NonNull User loginUser, @Nullable Project project, String permission) {
        if (loginUser == null) {
            throw new NullPointerException("loginUser is marked non-null but is null");
        }
        if (project == null) {
            throw new ServiceException(Status.PROJECT_NOT_EXIST);
        }
        if (!this.canOperatorPermissions(loginUser, new Object[]{project.getId()}, AuthorizationType.PROJECTS, permission)) {
            throw new ServiceException(Status.USER_NO_OPERATION_PROJECT_PERM, loginUser.getUserName(), project.getCode());
        }
    }

    @Override
    public void checkProjectAndAuthThrowException(User loginUser, long projectCode, String permission) {
        Project project = this.projectMapper.queryByCode(projectCode);
        this.checkProjectAndAuthThrowException(loginUser, project, permission);
    }

    @Override
    public boolean hasProjectAndPerm(User loginUser, Project project, Map<String, Object> result, String permission) {
        boolean checkResult = false;
        if (project == null) {
            log.error("Project does not exist.");
            this.putMsg(result, Status.PROJECT_NOT_FOUND, "");
        } else if (!this.canOperatorPermissions(loginUser, new Object[]{project.getId()}, AuthorizationType.PROJECTS, permission)) {
            log.error("User does not have {} permission to operate project, userName:{}, projectCode:{}.", new Object[]{permission, loginUser.getUserName(), project.getCode()});
            this.putMsg(result, Status.USER_NO_OPERATION_PROJECT_PERM, loginUser.getUserName(), project.getCode());
        } else {
            checkResult = true;
        }
        return checkResult;
    }

    @Override
    public boolean hasProjectAndWritePerm(User loginUser, Project project, Result result) {
        boolean checkResult = false;
        if (project == null) {
            log.error("Project does not exist.");
            this.putMsg(result, Status.PROJECT_NOT_FOUND, new Object[]{""});
        } else {
            if (loginUser.getUserType() == UserType.ADMIN_USER) {
                return true;
            }
            if (project.getUserId().equals(loginUser.getId())) {
                return true;
            }
            ProjectUser projectUser = this.projectUserMapper.queryProjectRelation(project.getId().intValue(), loginUser.getId().intValue());
            if (projectUser == null || projectUser.getPerm() != 7) {
                this.putMsg(result, Status.USER_NO_WRITE_PROJECT_PERM, new Object[]{loginUser.getUserName(), project.getCode()});
                checkResult = false;
            } else {
                checkResult = true;
            }
        }
        return checkResult;
    }

    @Override
    public boolean hasProjectAndWritePerm(User loginUser, Project project, Map<String, Object> result) {
        boolean checkResult = false;
        if (project == null) {
            log.error("Project does not exist.");
            this.putMsg(result, Status.PROJECT_NOT_FOUND, "");
        } else {
            if (loginUser.getUserType() == UserType.ADMIN_USER) {
                return true;
            }
            if (project.getUserId().equals(loginUser.getId())) {
                return true;
            }
            ProjectUser projectUser = this.projectUserMapper.queryProjectRelation(project.getId().intValue(), loginUser.getId().intValue());
            if (projectUser == null || projectUser.getPerm() != 7) {
                this.putMsg(result, Status.USER_NO_WRITE_PROJECT_PERM, loginUser.getUserName(), project.getCode());
                checkResult = false;
            } else {
                checkResult = true;
            }
        }
        return checkResult;
    }

    @Override
    public boolean hasProjectAndPerm(User loginUser, Project project, Result result, String permission) {
        boolean checkResult = false;
        if (project == null) {
            log.error("Project does not exist.");
            this.putMsg(result, Status.PROJECT_NOT_FOUND, new Object[]{""});
        } else if (!this.canOperatorPermissions(loginUser, new Object[]{project.getId()}, AuthorizationType.PROJECTS, permission)) {
            log.error("User does not have {} permission to operate project, userName:{}, projectCode:{}.", new Object[]{permission, loginUser.getUserName(), project.getCode()});
            this.putMsg(result, Status.USER_NO_OPERATION_PROJECT_PERM, new Object[]{loginUser.getUserName(), project.getName()});
        } else {
            checkResult = true;
        }
        return checkResult;
    }

    @Override
    public Result queryProjectListPaging(User loginUser, Integer pageSize, Integer pageNo, String searchVal) {
        Result result = new Result();
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        Set projectIds = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.PROJECTS, loginUser.getId(), log);
        if (projectIds.isEmpty()) {
            result.setData(pageInfo);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        IPage projectIPage = this.projectMapper.queryProjectListPaging((IPage)page, new ArrayList(projectIds), searchVal);
        List projectList = projectIPage.getRecords();
        if (loginUser.getUserType() != UserType.ADMIN_USER) {
            for (Project project : projectList) {
                project.setPerm(7);
            }
        }
        pageInfo.setTotal((int)projectIPage.getTotal());
        pageInfo.setTotalList(projectList);
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result queryProjectWithAuthorizedLevelListPaging(Integer userId, User loginUser, Integer pageSize, Integer pageNo, String searchVal) {
        Result result = new Result();
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        Set allProjectIds = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.PROJECTS, loginUser.getId(), log);
        Set userProjectIds = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.PROJECTS, userId, log);
        if (allProjectIds.isEmpty()) {
            result.setData(pageInfo);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        IPage projectIPage = this.projectMapper.queryProjectListPaging((IPage)page, new ArrayList(allProjectIds), searchVal);
        List projectList = projectIPage.getRecords();
        for (Project project : projectList) {
            if (userProjectIds.contains(project.getId())) {
                ProjectUser projectUser = this.projectUserMapper.queryProjectRelation(project.getId().intValue(), userId.intValue());
                if (projectUser == null) {
                    project.setPerm(7);
                    continue;
                }
                project.setPerm(projectUser.getPerm());
                continue;
            }
            project.setPerm(0);
        }
        pageInfo.setTotal((int)projectIPage.getTotal());
        pageInfo.setTotalList(projectList);
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result deleteProject(User loginUser, Long projectCode) {
        Result<Boolean> result = new Result<Boolean>();
        Project project = this.projectMapper.queryByCode(projectCode.longValue());
        boolean hasProjectAndWritePerm = this.hasProjectAndWritePerm(loginUser, project, result);
        if (!hasProjectAndWritePerm) {
            return result;
        }
        this.checkProjectAndAuth(result, loginUser, project, project == null ? 0L : project.getCode(), "project:delete");
        if (result.getCode().intValue() != Status.SUCCESS.getCode()) {
            return result;
        }
        assert (project != null);
        List processDefinitionList = this.processDefinitionMapper.queryAllDefinitionList(project.getCode());
        if (!processDefinitionList.isEmpty()) {
            log.warn("Please delete the process definitions in project first! project code:{}.", (Object)projectCode);
            this.putMsg(result, Status.DELETE_PROJECT_ERROR_DEFINES_NOT_NULL, new Object[0]);
            return result;
        }
        this.taskGroupService.deleteTaskGroupByProjectCode(project.getCode());
        int delete = this.projectMapper.deleteById((Serializable)project.getId());
        if (delete > 0) {
            log.info("Project is deleted and id is :{}.", (Object)project.getId());
            result.setData(Boolean.TRUE);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            log.error("Project delete error, project code:{}, project name:{}.", (Object)projectCode, (Object)project.getName());
            this.putMsg(result, Status.DELETE_PROJECT_ERROR, new Object[0]);
        }
        return result;
    }

    private Map<String, Object> getCheckResult(User loginUser, Project project, String perm) {
        Map<String, Object> checkResult = this.checkProjectAndAuth(loginUser, project, project == null ? 0L : project.getCode(), perm);
        Status status = (Status)((Object)checkResult.get("status"));
        if (status != Status.SUCCESS) {
            return checkResult;
        }
        return null;
    }

    @Override
    public Result update(User loginUser, Long projectCode, String projectName, String desc, String userName) {
        Result<Project> result = new Result<Project>();
        ProjectServiceImpl.checkDesc(result, desc);
        if (result.getCode().intValue() != Status.SUCCESS.getCode()) {
            return result;
        }
        Project project = this.projectMapper.queryByCode(projectCode.longValue());
        boolean hasProjectAndWritePerm = this.hasProjectAndWritePerm(loginUser, project, result);
        if (!hasProjectAndWritePerm) {
            return result;
        }
        Project tempProject = this.projectMapper.queryByName(projectName);
        if (tempProject != null && tempProject.getCode() != project.getCode()) {
            this.putMsg(result, Status.PROJECT_ALREADY_EXISTS, new Object[]{projectName});
            return result;
        }
        User user = this.userMapper.queryByUserNameAccurately(userName);
        if (user == null) {
            log.error("User does not exist.");
            this.putMsg(result, Status.USER_NOT_EXIST, new Object[]{userName});
            return result;
        }
        project.setName(projectName);
        project.setDescription(desc);
        project.setUpdateTime(new Date());
        project.setUserId(user.getId());
        int update = this.projectMapper.updateById((Object)project);
        if (update > 0) {
            log.info("Project is updated and id is :{}", (Object)project.getId());
            result.setData(project);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            log.error("Project update error, projectCode:{}, projectName:{}.", (Object)project.getCode(), (Object)project.getName());
            this.putMsg(result, Status.UPDATE_PROJECT_ERROR, new Object[0]);
        }
        return result;
    }

    @Override
    public Result queryProjectWithAuthorizedLevel(User loginUser, Integer userId) {
        int i;
        Result result = new Result();
        Set projectIds = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.PROJECTS, loginUser.getId(), log);
        List projectList = this.projectMapper.listAuthorizedProjects(loginUser.getUserType().equals((Object)UserType.ADMIN_USER) ? 0 : loginUser.getId(), new ArrayList(projectIds));
        List<Object> unauthorizedProjectsList = new ArrayList();
        ArrayList<Project> authedProjectList = new ArrayList();
        if (projectList != null && !projectList.isEmpty()) {
            HashSet<Project> projectSet = new HashSet<Project>(projectList);
            authedProjectList = this.projectMapper.queryAuthedProjectListByUserId(userId.intValue());
            unauthorizedProjectsList = this.getUnauthorizedProjects(projectSet, authedProjectList);
        }
        for (i = 0; i < authedProjectList.size(); ++i) {
            ((Project)authedProjectList.get(i)).setPerm(7);
        }
        for (i = 0; i < unauthorizedProjectsList.size(); ++i) {
            ((Project)unauthorizedProjectsList.get(i)).setPerm(0);
        }
        ArrayList<Object> joined = new ArrayList<Object>();
        joined.addAll(authedProjectList);
        joined.addAll(unauthorizedProjectsList);
        result.setData(joined);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result queryUnauthorizedProject(User loginUser, Integer userId) {
        Result<List<Object>> result = new Result<List<Object>>();
        Set projectIds = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.PROJECTS, loginUser.getId(), log);
        if (projectIds.isEmpty()) {
            result.setData(Collections.emptyList());
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        List projectList = this.projectMapper.listAuthorizedProjects(loginUser.getUserType().equals((Object)UserType.ADMIN_USER) ? 0 : loginUser.getId(), new ArrayList(projectIds));
        List<Object> resultList = new ArrayList();
        if (projectList != null && !projectList.isEmpty()) {
            HashSet<Project> projectSet = new HashSet<Project>(projectList);
            List authedProjectList = this.projectMapper.queryAuthedProjectListByUserId(userId.intValue());
            resultList = this.getUnauthorizedProjects(projectSet, authedProjectList);
        }
        result.setData(resultList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private List<Project> getUnauthorizedProjects(Set<Project> projectSet, List<Project> authedProjectList) {
        if (authedProjectList != null && !authedProjectList.isEmpty()) {
            HashSet<Project> authedProjectSet = new HashSet<Project>(authedProjectList);
            projectSet.removeAll(authedProjectSet);
        }
        ArrayList<Project> resultList = new ArrayList<Project>(projectSet);
        return resultList;
    }

    @Override
    public Result queryAuthorizedProject(User loginUser, Integer userId) {
        Result<List> result = new Result<List>();
        List projects = this.projectMapper.queryAuthedProjectListByUserId(userId.intValue());
        result.setData(projects);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result queryAuthorizedUser(User loginUser, Long projectCode) {
        Result<List> result = new Result<List>();
        Project project = this.projectMapper.queryByCode(projectCode.longValue());
        boolean hasProjectAndPerm = this.hasProjectAndPerm(loginUser, project, result, "project:view");
        if (!hasProjectAndPerm) {
            return result;
        }
        List users = this.userMapper.queryAuthedUserListByProjectId(project.getId().intValue());
        result.setData(users);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryProjectCreatedByUser(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List projects = this.projectMapper.queryProjectCreatedByUser(loginUser.getId().intValue());
        result.put("data", projects);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result queryProjectCreatedAndAuthorizedByUser(User loginUser) {
        Result<List> result = new Result<List>();
        Set projectIds = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.PROJECTS, loginUser.getId(), log);
        if (projectIds.isEmpty()) {
            result.setData(Collections.emptyList());
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        List projects = this.projectMapper.selectBatchIds(projectIds);
        result.setData(projects);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private boolean checkReadPermission(User user, Project project) {
        int permissionId = this.queryPermission(user, project);
        return (permissionId & 2) != 0;
    }

    private int queryPermission(User user, Project project) {
        if (user.getUserType() == UserType.ADMIN_USER) {
            return 2;
        }
        if (Objects.equals(project.getUserId(), user.getId())) {
            return 7;
        }
        ProjectUser projectUser = this.projectUserMapper.queryProjectRelation(project.getId().intValue(), user.getId().intValue());
        if (projectUser == null) {
            return 0;
        }
        return projectUser.getPerm();
    }

    @Override
    public Result queryAllProjectList(User user) {
        Result<List> result = new Result<List>();
        List projects = this.projectMapper.queryAllProject(user.getUserType() == UserType.ADMIN_USER ? 0 : user.getId());
        result.setData(projects);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public void checkProjectAndAuth(Result result, User loginUser, Project project, long projectCode, String permission) {
        if (project == null) {
            log.error("Project does not exist, project code:{}.", (Object)projectCode);
            this.putMsg(result, Status.PROJECT_NOT_EXIST, new Object[0]);
        } else if (!this.canOperatorPermissions(loginUser, new Object[]{project.getId()}, AuthorizationType.PROJECTS, permission)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PROJECT_PERM, new Object[]{loginUser.getUserName(), projectCode});
        } else {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
    }

    @Override
    public Result queryAllProjectListForDependent() {
        Result<List> result = new Result<List>();
        List projects = this.projectMapper.queryAllProjectForDependent();
        result.setData(projects);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }
}

