/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.QueueService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.constants.Constants;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.dao.entity.Queue;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.QueueMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QueueServiceImpl
extends BaseServiceImpl
implements QueueService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueueServiceImpl.class);
    @Autowired
    private QueueMapper queueMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private TenantMapper tenantMapper;

    private void createQueueValid(Queue queue) throws ServiceException {
        if (StringUtils.isEmpty((CharSequence)queue.getQueue())) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, "queue");
        }
        if (StringUtils.isEmpty((CharSequence)queue.getQueueName())) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, "queueName");
        }
        if (this.checkQueueExist(queue.getQueue())) {
            throw new ServiceException(Status.QUEUE_VALUE_EXIST, queue.getQueue());
        }
        if (this.checkQueueNameExist(queue.getQueueName())) {
            throw new ServiceException(Status.QUEUE_NAME_EXIST, queue.getQueueName());
        }
    }

    private void updateQueueValid(Queue existsQueue, Queue updateQueue) throws ServiceException {
        if (Objects.isNull(existsQueue)) {
            throw new ServiceException(Status.QUEUE_NOT_EXIST, updateQueue.getQueue());
        }
        if (Objects.equals(existsQueue, updateQueue)) {
            throw new ServiceException(Status.NEED_NOT_UPDATE_QUEUE);
        }
        if (StringUtils.isEmpty((CharSequence)updateQueue.getQueue())) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, "queue");
        }
        if (StringUtils.isEmpty((CharSequence)updateQueue.getQueueName())) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, "queueName");
        }
        if (!Objects.equals(updateQueue.getQueue(), existsQueue.getQueue()) && this.checkQueueExist(updateQueue.getQueue())) {
            throw new ServiceException(Status.QUEUE_VALUE_EXIST, updateQueue.getQueue());
        }
        if (!Objects.equals(updateQueue.getQueueName(), existsQueue.getQueueName()) && this.checkQueueNameExist(updateQueue.getQueueName())) {
            throw new ServiceException(Status.QUEUE_NAME_EXIST, updateQueue.getQueueName());
        }
    }

    @Override
    public Result queryList(User loginUser) {
        Result<List> result = new Result<List>();
        HashSet<Integer> ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.QUEUE, loginUser.getId(), log);
        if (loginUser.getUserType().equals((Object)UserType.GENERAL_USER)) {
            ids = ids.isEmpty() ? new HashSet<Integer>() : ids;
            ids.add(Constants.DEFAULT_QUEUE_ID);
        }
        List queueList = this.queueMapper.selectBatchIds(ids);
        result.setData(queueList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result queryList(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        Result result = new Result();
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        Set ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.QUEUE, loginUser.getId(), log);
        if (ids.isEmpty()) {
            result.setData(pageInfo);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage queueList = this.queueMapper.queryQueuePaging((IPage)page, new ArrayList(ids), searchVal);
        Integer count = (int)queueList.getTotal();
        pageInfo.setTotal(count);
        pageInfo.setTotalList(queueList.getRecords());
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public Result createQueue(User loginUser, String queue, String queueName) {
        Result<Queue> result = new Result<Queue>();
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.QUEUE, "security:queue:create")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        Queue queueObj = new Queue(queueName, queue);
        this.createQueueValid(queueObj);
        this.queueMapper.insert((Object)queueObj);
        result.setData(queueObj);
        log.info("Queue create complete, queueName:{}.", (Object)queueObj.getQueueName());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        this.permissionPostHandle(AuthorizationType.QUEUE, loginUser.getId(), Collections.singletonList(queueObj.getId()), log);
        return result;
    }

    @Override
    public Result updateQueue(User loginUser, int id, String queue, String queueName) {
        Result<Queue> result = new Result<Queue>();
        if (!this.canOperatorPermissions(loginUser, new Object[]{id}, AuthorizationType.QUEUE, "security:queue:update")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        Queue updateQueue = new Queue(id, queueName, queue);
        Queue existsQueue = (Queue)this.queueMapper.selectById((Serializable)Integer.valueOf(id));
        this.updateQueueValid(existsQueue, updateQueue);
        if (this.checkIfQueueIsInUsing(existsQueue.getQueueName(), updateQueue.getQueueName())) {
            Integer relatedUserNums = this.userMapper.updateUserQueue(existsQueue.getQueueName(), updateQueue.getQueueName());
            log.info("Old queue have related {} users, exec update user success.", (Object)relatedUserNums);
        }
        this.queueMapper.updateById((Object)updateQueue);
        result.setData(updateQueue);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> deleteQueueById(User loginUser, int id) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.TENANT, "security:tenant:delete")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        Queue queue = (Queue)this.queueMapper.selectById((Serializable)Integer.valueOf(id));
        if (Objects.isNull(queue)) {
            log.error("Queue does not exist");
            throw new ServiceException(Status.QUEUE_NOT_EXIST);
        }
        List tenantList = this.tenantMapper.queryTenantListByQueueId(queue.getId());
        if (CollectionUtils.isNotEmpty((Collection)tenantList)) {
            log.warn("Delete queue failed, because there are {} tenants using it.", (Object)tenantList.size());
            throw new ServiceException(Status.DELETE_TENANT_BY_ID_FAIL_TENANTS, tenantList.size());
        }
        List userList = this.userMapper.queryUserListByQueue(queue.getQueueName());
        if (CollectionUtils.isNotEmpty((Collection)userList)) {
            log.warn("Delete queue failed, because there are {} users using it.", (Object)userList.size());
            throw new ServiceException(Status.DELETE_QUEUE_BY_ID_FAIL_USERS, userList.size());
        }
        int delete = this.queueMapper.deleteById((Serializable)Integer.valueOf(id));
        if (delete > 0) {
            log.info("Queue is deleted and id is {}.", (Object)id);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            log.error("Queue delete failed, queueId:{}.", (Object)id);
            this.putMsg(result, Status.DELETE_QUEUE_BY_ID_ERROR, new Object[0]);
        }
        return result;
    }

    @Override
    public Result<Object> verifyQueue(String queue, String queueName) {
        Result<Object> result = new Result<Object>();
        Queue queueValidator = new Queue(queueName, queue);
        this.createQueueValid(queueValidator);
        result.setData(queueValidator);
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private boolean checkQueueExist(String queue) {
        return this.queueMapper.existQueue(queue, null) == Boolean.TRUE;
    }

    private boolean checkQueueNameExist(String queueName) {
        return this.queueMapper.existQueue(null, queueName) == Boolean.TRUE;
    }

    private boolean checkIfQueueIsInUsing(String oldQueue, String newQueue) {
        return !oldQueue.equals(newQueue) && this.userMapper.existUser(oldQueue) == Boolean.TRUE;
    }

    @Override
    public Queue createQueueIfNotExists(String queue, String queueName) {
        Queue existsQueue = this.queueMapper.queryQueueName(queue, queueName);
        if (!Objects.isNull(existsQueue)) {
            log.info("Queue exists, so return it, queueName:{}.", (Object)queueName);
            return existsQueue;
        }
        Queue queueObj = new Queue(queueName, queue);
        this.createQueueValid(queueObj);
        this.queueMapper.insert((Object)queueObj);
        log.info("Queue create complete, queueName:{}.", (Object)queueObj.getQueueName());
        return queueObj;
    }
}

