/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.cronutils.model.Cron;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.ScheduleParam;
import org.apache.dolphinscheduler.api.dto.schedule.ScheduleCreateRequest;
import org.apache.dolphinscheduler.api.dto.schedule.ScheduleFilterRequest;
import org.apache.dolphinscheduler.api.dto.schedule.ScheduleUpdateRequest;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.ExecutorService;
import org.apache.dolphinscheduler.api.service.MonitorService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.SchedulerService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.api.vo.ScheduleVo;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Environment;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.EnvironmentMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessTaskRelationMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.scheduler.api.SchedulerApi;
import org.apache.dolphinscheduler.service.cron.CronUtils;
import org.apache.dolphinscheduler.service.exceptions.CronParseException;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SchedulerServiceImpl
extends BaseServiceImpl
implements SchedulerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchedulerServiceImpl.class);
    @Autowired
    private ProjectService projectService;
    @Autowired
    private ExecutorService executorService;
    @Autowired
    private MonitorService monitorService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;
    @Autowired
    private SchedulerApi schedulerApi;
    @Autowired
    private ProcessTaskRelationMapper processTaskRelationMapper;
    @Autowired
    private EnvironmentMapper environmentMapper;
    @Autowired
    private TenantMapper tenantMapper;

    @Override
    @Transactional
    public Map<String, Object> insertSchedule(User loginUser, long projectCode, long processDefineCode, String schedule, WarningType warningType, int warningGroupId, FailureStrategy failureStrategy, Priority processInstancePriority, String workerGroup, String tenantCode, Long environmentCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndPerm = this.projectService.hasProjectAndPerm(loginUser, project, result, null);
        if (!hasProjectAndPerm) {
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefineCode);
        this.executorService.checkProcessDefinitionValid(projectCode, processDefinition, processDefineCode, processDefinition.getVersion());
        Schedule scheduleExists = this.scheduleMapper.queryByProcessDefinitionCode(processDefineCode);
        if (scheduleExists != null) {
            log.error("Schedule already exist, scheduleId:{},processDefineCode:{}", (Object)scheduleExists.getId(), (Object)processDefineCode);
            this.putMsg(result, Status.SCHEDULE_ALREADY_EXISTS, processDefineCode, scheduleExists.getId());
            return result;
        }
        Schedule scheduleObj = new Schedule();
        Date now = new Date();
        this.checkValidTenant(tenantCode);
        scheduleObj.setTenantCode(tenantCode);
        scheduleObj.setProjectName(project.getName());
        scheduleObj.setProcessDefinitionCode(processDefineCode);
        scheduleObj.setProcessDefinitionName(processDefinition.getName());
        ScheduleParam scheduleParam = (ScheduleParam)JSONUtils.parseObject((String)schedule, ScheduleParam.class);
        if (DateUtils.differSec((Date)scheduleParam.getStartTime(), (Date)scheduleParam.getEndTime()) == 0L) {
            log.warn("The start time must not be the same as the end or time can not be null.");
            this.putMsg(result, Status.SCHEDULE_START_TIME_END_TIME_SAME, new Object[0]);
            return result;
        }
        if (scheduleParam.getStartTime().getTime() > scheduleParam.getEndTime().getTime()) {
            log.warn("The start time must smaller than end time");
            this.putMsg(result, Status.START_TIME_BIGGER_THAN_END_TIME_ERROR, new Object[0]);
            return result;
        }
        scheduleObj.setStartTime(scheduleParam.getStartTime());
        scheduleObj.setEndTime(scheduleParam.getEndTime());
        if (!CronUtils.isValidExpression((String)scheduleParam.getCrontab())) {
            log.error("Schedule crontab verify failure, crontab:{}.", (Object)scheduleParam.getCrontab());
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, scheduleParam.getCrontab());
            return result;
        }
        scheduleObj.setCrontab(scheduleParam.getCrontab());
        scheduleObj.setTimezoneId(scheduleParam.getTimezoneId());
        scheduleObj.setWarningType(warningType);
        scheduleObj.setWarningGroupId(warningGroupId);
        scheduleObj.setFailureStrategy(failureStrategy);
        scheduleObj.setCreateTime(now);
        scheduleObj.setUpdateTime(now);
        scheduleObj.setUserId(loginUser.getId().intValue());
        scheduleObj.setUserName(loginUser.getUserName());
        scheduleObj.setReleaseState(ReleaseState.OFFLINE);
        scheduleObj.setProcessInstancePriority(processInstancePriority);
        scheduleObj.setWorkerGroup(workerGroup);
        scheduleObj.setEnvironmentCode(environmentCode);
        this.scheduleMapper.insert(scheduleObj);
        processDefinition.setWarningGroupId(Integer.valueOf(warningGroupId));
        this.processDefinitionMapper.updateById(processDefinition);
        result.put("data", this.scheduleMapper.selectById((Serializable)scheduleObj.getId()));
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        log.info("Schedule create complete, projectCode:{}, processDefinitionCode:{}, scheduleId:{}.", new Object[]{projectCode, processDefineCode, scheduleObj.getId()});
        result.put("scheduleId", scheduleObj.getId());
        return result;
    }

    protected void projectPermCheckByProcess(User loginUser, long processDefinitionCode) {
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefinitionCode);
        if (processDefinition == null) {
            throw new ServiceException(Status.PROCESS_DEFINE_NOT_EXIST, processDefinitionCode);
        }
        Project project = this.projectMapper.queryByCode(processDefinition.getProjectCode());
        this.projectService.checkProjectAndAuthThrowException(loginUser, project, null);
    }

    private void scheduleParamCheck(String scheduleParamStr) {
        ScheduleParam scheduleParam = (ScheduleParam)JSONUtils.parseObject((String)scheduleParamStr, ScheduleParam.class);
        if (scheduleParam == null) {
            throw new ServiceException(Status.PARSE_SCHEDULE_PARAM_ERROR, scheduleParamStr);
        }
        if (DateUtils.differSec((Date)scheduleParam.getStartTime(), (Date)scheduleParam.getEndTime()) == 0L) {
            throw new ServiceException(Status.SCHEDULE_START_TIME_END_TIME_SAME);
        }
        if (scheduleParam.getStartTime().getTime() > scheduleParam.getEndTime().getTime()) {
            throw new ServiceException(Status.START_TIME_BIGGER_THAN_END_TIME_ERROR);
        }
        if (!CronUtils.isValidExpression((String)scheduleParam.getCrontab())) {
            throw new ServiceException(Status.SCHEDULE_CRON_CHECK_FAILED, scheduleParam.getCrontab());
        }
    }

    @Override
    @Transactional
    public Schedule createSchedulesV2(User loginUser, ScheduleCreateRequest scheduleCreateRequest) {
        this.projectPermCheckByProcess(loginUser, scheduleCreateRequest.getProcessDefinitionCode());
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(scheduleCreateRequest.getProcessDefinitionCode());
        this.executorService.checkProcessDefinitionValid(processDefinition.getProjectCode(), processDefinition, processDefinition.getCode(), processDefinition.getVersion());
        Schedule scheduleExists = this.scheduleMapper.queryByProcessDefinitionCode(scheduleCreateRequest.getProcessDefinitionCode());
        if (scheduleExists != null) {
            throw new ServiceException(Status.SCHEDULE_ALREADY_EXISTS, scheduleCreateRequest.getProcessDefinitionCode(), scheduleExists.getId());
        }
        this.checkValidTenant(scheduleCreateRequest.getTenantCode());
        Schedule schedule = scheduleCreateRequest.convert2Schedule();
        Environment environment = this.environmentMapper.queryByEnvironmentCode(schedule.getEnvironmentCode());
        if (environment == null) {
            throw new ServiceException(Status.QUERY_ENVIRONMENT_BY_CODE_ERROR, schedule.getEnvironmentCode());
        }
        schedule.setUserId(loginUser.getId().intValue());
        schedule.setUserName(loginUser.getUserName());
        schedule.setProcessDefinitionName(processDefinition.getName());
        this.scheduleParamCheck(scheduleCreateRequest.getScheduleParam());
        int create = this.scheduleMapper.insert(schedule);
        if (create <= 0) {
            throw new ServiceException(Status.CREATE_SCHEDULE_ERROR);
        }
        processDefinition.setWarningGroupId(Integer.valueOf(schedule.getWarningGroupId()));
        this.processDefinitionMapper.updateById(processDefinition);
        return schedule;
    }

    @Override
    @Transactional
    public Map<String, Object> updateSchedule(User loginUser, long projectCode, Integer id, String scheduleExpression, WarningType warningType, int warningGroupId, FailureStrategy failureStrategy, Priority processInstancePriority, String workerGroup, String tenantCode, Long environmentCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndPerm = this.projectService.hasProjectAndPerm(loginUser, project, result, null);
        if (!hasProjectAndPerm) {
            return result;
        }
        Schedule schedule = (Schedule)this.scheduleMapper.selectById((Serializable)id);
        if (schedule == null) {
            log.error("Schedule does not exist, scheduleId:{}.", (Object)id);
            this.putMsg(result, Status.SCHEDULE_NOT_EXISTS, id);
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(schedule.getProcessDefinitionCode());
        if (processDefinition == null || projectCode != processDefinition.getProjectCode()) {
            log.error("Process definition does not exist, processDefinitionCode:{}.", (Object)schedule.getProcessDefinitionCode());
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, String.valueOf(schedule.getProcessDefinitionCode()));
            return result;
        }
        this.updateSchedule(result, schedule, processDefinition, scheduleExpression, warningType, warningGroupId, failureStrategy, processInstancePriority, workerGroup, tenantCode, (long)environmentCode);
        return result;
    }

    @Override
    @Transactional
    public Schedule updateSchedulesV2(User loginUser, Integer scheduleId, ScheduleUpdateRequest scheduleUpdateRequest) {
        Environment environment;
        Schedule scheduleUpdate;
        Schedule schedule = (Schedule)this.scheduleMapper.selectById((Serializable)scheduleId);
        if (schedule == null) {
            throw new ServiceException(Status.SCHEDULE_NOT_EXISTS, scheduleId);
        }
        try {
            scheduleUpdate = scheduleUpdateRequest.mergeIntoSchedule(schedule);
            this.scheduleParamCheck(scheduleUpdateRequest.updateScheduleParam(scheduleUpdate));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, scheduleUpdateRequest.toString());
        }
        this.projectPermCheckByProcess(loginUser, scheduleUpdate.getProcessDefinitionCode());
        if (scheduleUpdate.getEnvironmentCode() != null && (environment = this.environmentMapper.queryByEnvironmentCode(scheduleUpdate.getEnvironmentCode())) == null) {
            throw new ServiceException(Status.QUERY_ENVIRONMENT_BY_CODE_ERROR, scheduleUpdate.getEnvironmentCode());
        }
        int update = this.scheduleMapper.updateById(scheduleUpdate);
        if (update <= 0) {
            throw new ServiceException(Status.UPDATE_SCHEDULE_ERROR);
        }
        return scheduleUpdate;
    }

    @Override
    @Transactional
    public Schedule getSchedule(User loginUser, Integer scheduleId) {
        Schedule schedule = (Schedule)this.scheduleMapper.selectById((Serializable)scheduleId);
        if (schedule == null) {
            throw new ServiceException(Status.SCHEDULE_NOT_EXISTS, scheduleId);
        }
        this.projectPermCheckByProcess(loginUser, schedule.getProcessDefinitionCode());
        return schedule;
    }

    @Override
    @Transactional
    public void setScheduleState(User loginUser, long projectCode, Integer id, ReleaseState scheduleStatus) {
        List<Server> masterServers;
        Project project = this.projectMapper.queryByCode(projectCode);
        this.projectService.checkProjectAndAuthThrowException(loginUser, project, null);
        Schedule scheduleObj = (Schedule)this.scheduleMapper.selectById((Serializable)id);
        if (scheduleObj == null) {
            log.error("Schedule does not exist, scheduleId:{}.", (Object)id);
            throw new ServiceException(Status.SCHEDULE_CRON_NOT_EXISTS, id);
        }
        if (scheduleObj.getReleaseState() == scheduleStatus) {
            log.warn("Schedule state does not need to change due to schedule state is already {}, scheduleId:{}.", (Object)scheduleObj.getReleaseState().getDescp(), (Object)scheduleObj.getId());
            throw new ServiceException(Status.SCHEDULE_CRON_REALEASE_NEED_NOT_CHANGE, scheduleStatus);
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(scheduleObj.getProcessDefinitionCode());
        if (processDefinition == null || projectCode != processDefinition.getProjectCode()) {
            log.error("Process definition does not exist, processDefinitionCode:{}.", (Object)scheduleObj.getProcessDefinitionCode());
            throw new ServiceException(Status.PROCESS_DEFINE_NOT_EXIST, String.valueOf(scheduleObj.getProcessDefinitionCode()));
        }
        List processTaskRelations = this.processTaskRelationMapper.queryByProcessCode(projectCode, scheduleObj.getProcessDefinitionCode());
        if (processTaskRelations.isEmpty()) {
            log.error("Process task relations do not exist, projectCode:{}, processDefinitionCode:{}.", (Object)projectCode, (Object)processDefinition.getCode());
            throw new ServiceException(Status.PROCESS_DAG_IS_EMPTY);
        }
        if (scheduleStatus == ReleaseState.ONLINE) {
            if (processDefinition.getReleaseState() != ReleaseState.ONLINE) {
                log.warn("Only process definition state is {} can change schedule state, processDefinitionCode:{}.", (Object)ReleaseState.ONLINE.getDescp(), (Object)processDefinition.getCode());
                throw new ServiceException(Status.PROCESS_DEFINE_NOT_RELEASE, processDefinition.getName());
            }
            ArrayList subProcessDefineCodes = new ArrayList();
            this.processService.recurseFindSubProcess(processDefinition.getCode(), subProcessDefineCodes);
            if (!subProcessDefineCodes.isEmpty()) {
                log.info("Need to check sub process definition state before change schedule state, subProcessDefineCodes:{}.", (Object)StringUtils.join(subProcessDefineCodes, (String)","));
                List subProcessDefinitionList = this.processDefinitionMapper.queryByCodes(subProcessDefineCodes);
                if (subProcessDefinitionList != null && !subProcessDefinitionList.isEmpty()) {
                    for (ProcessDefinition subProcessDefinition : subProcessDefinitionList) {
                        if (subProcessDefinition.getReleaseState() == ReleaseState.ONLINE) continue;
                        log.warn("Only sub process definition state is {} can change schedule state, subProcessDefinitionCode:{}.", (Object)ReleaseState.ONLINE.getDescp(), (Object)subProcessDefinition.getCode());
                        throw new ServiceException(Status.PROCESS_DEFINE_NOT_RELEASE, String.valueOf(subProcessDefinition.getId()));
                    }
                }
            }
        }
        if ((masterServers = this.monitorService.getServerListFromRegistry(true)).isEmpty()) {
            log.error("Master does not exist.");
            throw new ServiceException(Status.MASTER_NOT_EXISTS);
        }
        scheduleObj.setReleaseState(scheduleStatus);
        this.scheduleMapper.updateById(scheduleObj);
        try {
            switch (scheduleStatus) {
                case ONLINE: {
                    log.info("Call master client set schedule online, project id: {}, flow id: {},host: {}", new Object[]{project.getId(), processDefinition.getId(), masterServers});
                    this.setSchedule(project.getId(), scheduleObj);
                    break;
                }
                case OFFLINE: {
                    log.info("Call master client set schedule offline, project id: {}, flow id: {},host: {}", new Object[]{project.getId(), processDefinition.getId(), masterServers});
                    this.deleteSchedule(project.getId(), id);
                    break;
                }
                default: {
                    throw new ServiceException(Status.SCHEDULE_STATUS_UNKNOWN, scheduleStatus.toString());
                }
            }
        }
        catch (Exception e) {
            log.error("Set schedule state to {} error, projectCode:{}, scheduleId:{}.", new Object[]{scheduleStatus.getDescp(), projectCode, scheduleObj.getId()});
            Status status = scheduleStatus == ReleaseState.ONLINE ? Status.PUBLISH_SCHEDULE_ONLINE_ERROR : Status.OFFLINE_SCHEDULE_ERROR;
            throw new ServiceException(status, e);
        }
    }

    @Override
    public Result querySchedule(User loginUser, long projectCode, long processDefineCode, String searchVal, Integer pageNo, Integer pageSize) {
        ProcessDefinition processDefinition;
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndPerm = this.projectService.hasProjectAndPerm(loginUser, project, result, "project:view");
        if (!hasProjectAndPerm) {
            return result;
        }
        if (processDefineCode != 0L && ((processDefinition = this.processDefinitionMapper.queryByCode(processDefineCode)) == null || projectCode != processDefinition.getProjectCode())) {
            log.error("Process definition does not exist, processDefinitionCode:{}.", (Object)processDefineCode);
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, new Object[]{String.valueOf(processDefineCode)});
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage schedulePage = this.scheduleMapper.queryByProjectAndProcessDefineCodePaging((IPage)page, projectCode, processDefineCode, searchVal);
        ArrayList<ScheduleVo> scheduleList = new ArrayList<ScheduleVo>();
        for (Schedule schedule : schedulePage.getRecords()) {
            scheduleList.add(new ScheduleVo(schedule));
        }
        PageInfo<ScheduleVo> pageInfo = new PageInfo<ScheduleVo>(pageNo, pageSize);
        pageInfo.setTotal((int)schedulePage.getTotal());
        pageInfo.setTotalList(scheduleList);
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public List<Schedule> queryScheduleByProcessDefinitionCodes(@NonNull List<Long> processDefinitionCodes) {
        if (processDefinitionCodes == null) {
            throw new NullPointerException("processDefinitionCodes is marked non-null but is null");
        }
        if (CollectionUtils.isEmpty(processDefinitionCodes)) {
            return Collections.emptyList();
        }
        return this.scheduleMapper.querySchedulesByProcessDefinitionCodes(processDefinitionCodes);
    }

    @Override
    @Transactional
    public PageInfo<Schedule> filterSchedules(User loginUser, ScheduleFilterRequest scheduleFilterRequest) {
        if (scheduleFilterRequest.getProjectName() != null) {
            Project project = this.projectMapper.queryByName(scheduleFilterRequest.getProjectName());
            this.projectService.checkProjectAndAuthThrowException(loginUser, project, null);
        }
        Page page = new Page((long)scheduleFilterRequest.getPageNo().intValue(), (long)scheduleFilterRequest.getPageSize().intValue());
        IPage scheduleIPage = this.scheduleMapper.filterSchedules((IPage)page, scheduleFilterRequest.convert2Schedule());
        PageInfo<Schedule> pageInfo = new PageInfo<Schedule>(scheduleFilterRequest.getPageNo(), scheduleFilterRequest.getPageSize());
        pageInfo.setTotal((int)scheduleIPage.getTotal());
        pageInfo.setTotalList(scheduleIPage.getRecords());
        return pageInfo;
    }

    @Override
    public Map<String, Object> queryScheduleList(User loginUser, long projectCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndPerm = this.projectService.hasProjectAndPerm(loginUser, project, result, null);
        if (!hasProjectAndPerm) {
            return result;
        }
        List schedules = this.scheduleMapper.querySchedulerListByProjectName(project.getName());
        ArrayList<ScheduleVo> scheduleList = new ArrayList<ScheduleVo>();
        for (Schedule schedule : schedules) {
            scheduleList.add(new ScheduleVo(schedule));
        }
        result.put("data", scheduleList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public void setSchedule(int projectId, Schedule schedule) {
        log.info("Set schedule state {}, project id: {}, scheduleId: {}", new Object[]{schedule.getReleaseState().getDescp(), projectId, schedule.getId()});
        this.schedulerApi.insertOrUpdateScheduleTask(projectId, schedule);
    }

    @Override
    public void deleteSchedule(int projectId, int scheduleId) {
        log.info("Delete schedule of project, projectId:{}, scheduleId:{}", (Object)projectId, (Object)scheduleId);
        this.schedulerApi.deleteScheduleTask(projectId, scheduleId);
    }

    private boolean checkValid(Map<String, Object> result, boolean bool, Status status) {
        if (bool) {
            this.putMsg(result, status, new Object[0]);
            return true;
        }
        return false;
    }

    @Override
    public void deleteSchedulesById(User loginUser, Integer scheduleId) {
        Schedule schedule = (Schedule)this.scheduleMapper.selectById((Serializable)scheduleId);
        if (schedule == null) {
            throw new ServiceException(Status.SCHEDULE_NOT_EXISTS, scheduleId);
        }
        if (schedule.getReleaseState() == ReleaseState.ONLINE) {
            throw new ServiceException(Status.SCHEDULE_STATE_ONLINE, scheduleId);
        }
        if (loginUser.getId().intValue() != schedule.getUserId() && loginUser.getUserType() != UserType.ADMIN_USER) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        this.projectPermCheckByProcess(loginUser, schedule.getProcessDefinitionCode());
        int delete = this.scheduleMapper.deleteById((Serializable)scheduleId);
        if (delete <= 0) {
            throw new ServiceException(Status.DELETE_SCHEDULE_BY_ID_ERROR);
        }
    }

    @Override
    public Map<String, Object> previewSchedule(User loginUser, String schedule) {
        Cron cron;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ScheduleParam scheduleParam = (ScheduleParam)JSONUtils.parseObject((String)schedule, ScheduleParam.class);
        assert (scheduleParam != null);
        ZoneId zoneId = TimeZone.getTimeZone(scheduleParam.getTimezoneId()).toZoneId();
        ZonedDateTime now = ZonedDateTime.now(zoneId);
        ZonedDateTime startTime = ZonedDateTime.ofInstant(scheduleParam.getStartTime().toInstant(), zoneId);
        ZonedDateTime endTime = ZonedDateTime.ofInstant(scheduleParam.getEndTime().toInstant(), zoneId);
        startTime = now.isAfter(startTime) ? now : startTime;
        try {
            cron = CronUtils.parse2Cron((String)scheduleParam.getCrontab());
        }
        catch (CronParseException e) {
            log.error("Parse cron to cron expression error, crontab:{}.", (Object)scheduleParam.getCrontab(), (Object)e);
            this.putMsg(result, Status.PARSE_TO_CRON_EXPRESSION_ERROR, new Object[0]);
            return result;
        }
        List selfFireDateList = CronUtils.getSelfFireDateList((ZonedDateTime)startTime, (ZonedDateTime)endTime, (Cron)cron, (int)5);
        List previewDateList = selfFireDateList.stream().map(t -> DateUtils.dateToString((ZonedDateTime)t, (ZoneId)zoneId)).collect(Collectors.toList());
        result.put("data", previewDateList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> updateScheduleByProcessDefinitionCode(User loginUser, long projectCode, long processDefinitionCode, String scheduleExpression, WarningType warningType, int warningGroupId, FailureStrategy failureStrategy, Priority processInstancePriority, String workerGroup, String tenantCode, long environmentCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, null);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        Schedule schedule = this.scheduleMapper.queryByProcessDefinitionCode(processDefinitionCode);
        if (schedule == null) {
            log.error("Schedule of process definition does not exist, processDefinitionCode:{}.", (Object)processDefinitionCode);
            this.putMsg(result, Status.SCHEDULE_CRON_NOT_EXISTS, processDefinitionCode);
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefinitionCode);
        if (processDefinition == null || projectCode != processDefinition.getProjectCode()) {
            log.error("Process definition does not exist, processDefinitionCode:{}.", (Object)processDefinitionCode);
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, String.valueOf(processDefinitionCode));
            return result;
        }
        this.updateSchedule(result, schedule, processDefinition, scheduleExpression, warningType, warningGroupId, failureStrategy, processInstancePriority, workerGroup, tenantCode, environmentCode);
        return result;
    }

    private void updateSchedule(Map<String, Object> result, Schedule schedule, ProcessDefinition processDefinition, String scheduleExpression, WarningType warningType, int warningGroupId, FailureStrategy failureStrategy, Priority processInstancePriority, String workerGroup, String tenantCode, long environmentCode) {
        if (this.checkValid(result, schedule.getReleaseState() == ReleaseState.ONLINE, Status.SCHEDULE_CRON_ONLINE_FORBID_UPDATE)) {
            log.warn("Schedule can not be updated due to schedule is {}, scheduleId:{}.", (Object)ReleaseState.ONLINE.getDescp(), (Object)schedule.getId());
            return;
        }
        Date now = new Date();
        this.checkValidTenant(tenantCode);
        schedule.setTenantCode(tenantCode);
        if (!StringUtils.isEmpty((CharSequence)scheduleExpression)) {
            ScheduleParam scheduleParam = (ScheduleParam)JSONUtils.parseObject((String)scheduleExpression, ScheduleParam.class);
            if (scheduleParam == null) {
                log.warn("Parameter scheduleExpression is invalid, so parse cron error.");
                this.putMsg(result, Status.PARSE_TO_CRON_EXPRESSION_ERROR, new Object[0]);
                return;
            }
            if (DateUtils.differSec((Date)scheduleParam.getStartTime(), (Date)scheduleParam.getEndTime()) == 0L) {
                log.warn("The start time must not be the same as the end or time can not be null.");
                this.putMsg(result, Status.SCHEDULE_START_TIME_END_TIME_SAME, new Object[0]);
                return;
            }
            if (scheduleParam.getStartTime().getTime() > scheduleParam.getEndTime().getTime()) {
                log.warn("The start time must smaller than end time");
                this.putMsg(result, Status.START_TIME_BIGGER_THAN_END_TIME_ERROR, new Object[0]);
                return;
            }
            schedule.setStartTime(scheduleParam.getStartTime());
            schedule.setEndTime(scheduleParam.getEndTime());
            if (!CronUtils.isValidExpression((String)scheduleParam.getCrontab())) {
                log.error("Schedule crontab verify failure, crontab:{}.", (Object)scheduleParam.getCrontab());
                this.putMsg(result, Status.SCHEDULE_CRON_CHECK_FAILED, scheduleParam.getCrontab());
                return;
            }
            schedule.setCrontab(scheduleParam.getCrontab());
            schedule.setTimezoneId(scheduleParam.getTimezoneId());
        }
        if (warningType != null) {
            schedule.setWarningType(warningType);
        }
        schedule.setWarningGroupId(warningGroupId);
        if (failureStrategy != null) {
            schedule.setFailureStrategy(failureStrategy);
        }
        schedule.setWorkerGroup(workerGroup);
        schedule.setEnvironmentCode(Long.valueOf(environmentCode));
        schedule.setUpdateTime(now);
        schedule.setProcessInstancePriority(processInstancePriority);
        this.scheduleMapper.updateById(schedule);
        processDefinition.setWarningGroupId(Integer.valueOf(warningGroupId));
        this.processDefinitionMapper.updateById(processDefinition);
        log.info("Schedule update complete, projectCode:{}, processDefinitionCode:{}, scheduleId:{}.", new Object[]{processDefinition.getProjectCode(), processDefinition.getCode(), schedule.getId()});
        this.putMsg(result, Status.SUCCESS, new Object[0]);
    }

    private void checkValidTenant(String tenantCode) {
        Tenant tenant;
        if (!"default".equals(tenantCode) && (tenant = this.tenantMapper.queryByTenantCode(tenantCode)) == null) {
            throw new ServiceException(Status.TENANT_NOT_EXIST, tenantCode);
        }
    }
}

