/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.QueueService;
import org.apache.dolphinscheduler.api.service.TenantService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.RegexUtils;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.Queue;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperate;
import org.apache.dolphinscheduler.service.utils.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TenantServiceImpl
extends BaseServiceImpl
implements TenantService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantServiceImpl.class);
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private ProcessInstanceMapper processInstanceMapper;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private QueueService queueService;
    @Autowired(required=false)
    private StorageOperate storageOperate;

    private void createTenantValid(Tenant tenant) throws ServiceException {
        if (StringUtils.isEmpty((CharSequence)tenant.getTenantCode())) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, tenant.getTenantCode());
        }
        if (StringUtils.length((CharSequence)tenant.getTenantCode()) > 30) {
            throw new ServiceException(Status.TENANT_FULL_NAME_TOO_LONG_ERROR);
        }
        if (!RegexUtils.isValidLinuxUserName(tenant.getTenantCode())) {
            throw new ServiceException(Status.CHECK_OS_TENANT_CODE_ERROR);
        }
        if (this.checkTenantExists(tenant.getTenantCode())) {
            throw new ServiceException(Status.OS_TENANT_CODE_EXIST, tenant.getTenantCode());
        }
    }

    private void updateTenantValid(Tenant existsTenant, Tenant updateTenant) throws ServiceException {
        if (Objects.isNull(existsTenant)) {
            log.error("Tenant does not exist.");
            throw new ServiceException(Status.TENANT_NOT_EXIST);
        }
        if (StringUtils.isEmpty((CharSequence)updateTenant.getTenantCode())) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, updateTenant.getTenantCode());
        }
        if (StringUtils.length((CharSequence)updateTenant.getTenantCode()) > 30) {
            throw new ServiceException(Status.TENANT_FULL_NAME_TOO_LONG_ERROR);
        }
        if (!RegexUtils.isValidLinuxUserName(updateTenant.getTenantCode())) {
            throw new ServiceException(Status.CHECK_OS_TENANT_CODE_ERROR);
        }
        if (!Objects.equals(existsTenant.getTenantCode(), updateTenant.getTenantCode()) && this.checkTenantExists(updateTenant.getTenantCode())) {
            throw new ServiceException(Status.OS_TENANT_CODE_EXIST, updateTenant.getTenantCode());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> createTenant(User loginUser, String tenantCode, int queueId, String desc) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.TENANT, "security:tenant:create")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        if (this.checkDescriptionLength(desc)) {
            log.warn("Parameter description is too long.");
            this.putMsg(result, Status.DESCRIPTION_TOO_LONG_ERROR, new Object[0]);
            return result;
        }
        Tenant tenant = new Tenant(tenantCode, desc, queueId);
        this.createTenantValid(tenant);
        this.tenantMapper.insert((Object)tenant);
        this.storageOperate.createTenantDirIfNotExists(tenantCode);
        this.permissionPostHandle(AuthorizationType.TENANT, loginUser.getId(), Collections.singletonList(tenant.getId()), log);
        result.put("data", tenant);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result<Object> queryTenantList(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        Result<Object> result = new Result<Object>();
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        Set ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.TENANT, loginUser.getId(), log);
        if (ids.isEmpty()) {
            result.setData(pageInfo);
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage tenantPage = this.tenantMapper.queryTenantPaging((IPage)page, new ArrayList(ids), searchVal);
        pageInfo.setTotal((int)tenantPage.getTotal());
        pageInfo.setTotalList(tenantPage.getRecords());
        result.setData(pageInfo);
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> updateTenant(User loginUser, int id, String tenantCode, int queueId, String desc) throws Exception {
        int update;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.TENANT, "security:tenant:update")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        if (this.checkDescriptionLength(desc)) {
            log.warn("Parameter description is too long.");
            this.putMsg(result, Status.DESCRIPTION_TOO_LONG_ERROR, new Object[0]);
            return result;
        }
        Tenant updateTenant = new Tenant(id, tenantCode, desc, queueId);
        Tenant existsTenant = this.tenantMapper.queryById(id);
        this.updateTenantValid(existsTenant, updateTenant);
        if (!Objects.equals(existsTenant.getTenantCode(), updateTenant.getTenantCode())) {
            this.storageOperate.createTenantDirIfNotExists(tenantCode);
        }
        if ((update = this.tenantMapper.updateById(updateTenant)) > 0) {
            log.info("Tenant is updated and id is {}.", (Object)updateTenant.getId());
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            log.error("Tenant update error, id:{}.", (Object)updateTenant.getId());
            this.putMsg(result, Status.UPDATE_TENANT_ERROR, new Object[0]);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> deleteTenantById(User loginUser, int id) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.TENANT, "security:tenant:delete")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        Tenant tenant = this.tenantMapper.queryById(id);
        if (Objects.isNull(tenant)) {
            log.error("Tenant does not exist, userId:{}.", (Object)id);
            throw new ServiceException(Status.TENANT_NOT_EXIST);
        }
        List<ProcessInstance> processInstances = this.getProcessInstancesByTenant(tenant);
        if (CollectionUtils.isNotEmpty(processInstances)) {
            log.warn("Delete tenant failed, because there are {} executing process instances using it.", (Object)processInstances.size());
            throw new ServiceException(Status.DELETE_TENANT_BY_ID_FAIL, processInstances.size());
        }
        List schedules = this.scheduleMapper.queryScheduleListByTenant(tenant.getTenantCode());
        if (CollectionUtils.isNotEmpty((Collection)schedules)) {
            log.warn("Delete tenant failed, because there are {} schedule using it.", (Object)schedules.size());
            throw new ServiceException(Status.DELETE_TENANT_BY_ID_FAIL_DEFINES, schedules.size());
        }
        List userList = this.userMapper.queryUserListByTenant(tenant.getId().intValue());
        if (CollectionUtils.isNotEmpty((Collection)userList)) {
            log.warn("Delete tenant failed, because there are {} users using it.", (Object)userList.size());
            throw new ServiceException(Status.DELETE_TENANT_BY_ID_FAIL_USERS, userList.size());
        }
        this.storageOperate.deleteTenant(tenant.getTenantCode());
        int delete = this.tenantMapper.deleteById(id);
        if (delete > 0) {
            this.processInstanceMapper.updateProcessInstanceByTenantCode(tenant.getTenantCode(), "default");
            log.info("Tenant is deleted and id is {}.", (Object)id);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            log.error("Tenant delete failed, tenantId:{}.", (Object)id);
            this.putMsg(result, Status.DELETE_TENANT_BY_ID_ERROR, new Object[0]);
        }
        return result;
    }

    private List<ProcessInstance> getProcessInstancesByTenant(Tenant tenant) {
        return this.processInstanceMapper.queryByTenantCodeAndStatus(tenant.getTenantCode(), Constants.NOT_TERMINATED_STATES);
    }

    @Override
    public Map<String, Object> queryTenantList(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.TENANT, loginUser.getId(), log);
        if (ids.isEmpty()) {
            result.put("data", Collections.emptyList());
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        List resourceList = this.tenantMapper.selectBatchIds(ids);
        result.put("data", resourceList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result<Object> verifyTenantCode(String tenantCode) {
        Result<Object> result = new Result<Object>();
        if (this.checkTenantExists(tenantCode)) {
            throw new ServiceException(Status.OS_TENANT_CODE_EXIST, tenantCode);
        }
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private boolean checkTenantExists(String tenantCode) {
        Boolean existTenant = this.tenantMapper.existTenant(tenantCode);
        return Boolean.TRUE.equals(existTenant);
    }

    @Override
    public Map<String, Object> queryByTenantCode(String tenantCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Tenant tenant = this.tenantMapper.queryByTenantCode(tenantCode);
        if (tenant != null) {
            result.put("data", tenant);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public Tenant createTenantIfNotExists(String tenantCode, String desc, String queue, String queueName) {
        if (this.checkTenantExists(tenantCode)) {
            return this.tenantMapper.queryByTenantCode(tenantCode);
        }
        Queue queueObj = this.queueService.createQueueIfNotExists(queue, queueName);
        Tenant tenant = new Tenant(tenantCode, desc, queueObj.getId().intValue());
        this.createTenantValid(tenant);
        this.tenantMapper.insert((Object)tenant);
        return tenant;
    }
}

