/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.WorkerGroupService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.EnvironmentWorkerGroupRelation;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkerGroup;
import org.apache.dolphinscheduler.dao.mapper.EnvironmentWorkerGroupRelationMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkerGroupMapper;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.utils.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkerGroupServiceImpl
extends BaseServiceImpl
implements WorkerGroupService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerGroupServiceImpl.class);
    @Autowired
    private WorkerGroupMapper workerGroupMapper;
    @Autowired
    private ProcessInstanceMapper processInstanceMapper;
    @Autowired
    private RegistryClient registryClient;
    @Autowired
    private EnvironmentWorkerGroupRelationMapper environmentWorkerGroupRelationMapper;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;

    @Override
    @Transactional
    public Map<String, Object> saveWorkerGroup(User loginUser, int id, String name, String addrList, String description, String otherParamsJson) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.WORKER_GROUP, "security:worker-group:create")) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            log.warn("Parameter name can ot be null.");
            this.putMsg(result, Status.NAME_NULL, new Object[0]);
            return result;
        }
        Date now = new Date();
        WorkerGroup workerGroup = null;
        if (id != 0 && Objects.nonNull(workerGroup = (WorkerGroup)this.workerGroupMapper.selectById((Serializable)Integer.valueOf(id))) && !workerGroup.getName().equals(name) && this.checkWorkerGroupDependencies(workerGroup, result)) {
            return result;
        }
        if (workerGroup == null) {
            workerGroup = new WorkerGroup();
            workerGroup.setCreateTime(now);
        }
        workerGroup.setName(name);
        workerGroup.setAddrList(addrList);
        workerGroup.setUpdateTime(now);
        workerGroup.setDescription(description);
        if (this.checkWorkerGroupNameExists(workerGroup)) {
            log.warn("Worker group with the same name already exists, name:{}.", (Object)workerGroup.getName());
            this.putMsg(result, Status.NAME_EXIST, workerGroup.getName());
            return result;
        }
        String invalidAddr = this.checkWorkerGroupAddrList(workerGroup);
        if (invalidAddr != null) {
            log.warn("Worker group address is invalid, invalidAddr:{}.", (Object)invalidAddr);
            this.putMsg(result, Status.WORKER_ADDRESS_INVALID, invalidAddr);
            return result;
        }
        this.handleDefaultWorkGroup(this.workerGroupMapper, workerGroup, loginUser, otherParamsJson);
        log.info("Worker group save complete, workerGroupName:{}.", (Object)workerGroup.getName());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    protected void handleDefaultWorkGroup(WorkerGroupMapper workerGroupMapper, WorkerGroup workerGroup, User loginUser, String otherParamsJson) {
        if (workerGroup.getId() != null) {
            workerGroupMapper.updateById(workerGroup);
        } else {
            workerGroupMapper.insert(workerGroup);
            this.permissionPostHandle(AuthorizationType.WORKER_GROUP, loginUser.getId(), Collections.singletonList(workerGroup.getId()), log);
        }
    }

    private boolean checkWorkerGroupNameExists(WorkerGroup workerGroup) {
        List workerGroupList = this.workerGroupMapper.queryWorkerGroupByName(workerGroup.getName());
        if (CollectionUtils.isNotEmpty((Collection)workerGroupList)) {
            if (workerGroup.getId() == null) {
                return true;
            }
            Optional<WorkerGroup> sameNameWorkGroupOptional = workerGroupList.stream().filter(group -> !Objects.equals(group.getId(), workerGroup.getId())).findFirst();
            if (sameNameWorkGroupOptional.isPresent()) {
                return true;
            }
        }
        return false;
    }

    private boolean checkWorkerGroupDependencies(WorkerGroup workerGroup, Map<String, Object> result) {
        List taskDefinitions = this.taskDefinitionMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(TaskDefinition::getWorkerGroup, (Object)workerGroup.getName()));
        if (CollectionUtils.isNotEmpty((Collection)taskDefinitions)) {
            List taskNames = taskDefinitions.stream().limit(3L).map(taskDefinition -> taskDefinition.getName()).collect(Collectors.toList());
            this.putMsg(result, Status.WORKER_GROUP_DEPENDENT_TASK_EXISTS, taskDefinitions.size(), JSONUtils.toJsonString(taskNames));
            return true;
        }
        List schedules = this.scheduleMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(Schedule::getWorkerGroup, (Object)workerGroup.getName()));
        if (CollectionUtils.isNotEmpty((Collection)schedules)) {
            List processNames = schedules.stream().limit(3L).map(schedule -> this.processDefinitionMapper.queryByCode(schedule.getProcessDefinitionCode()).getName()).collect(Collectors.toList());
            this.putMsg(result, Status.WORKER_GROUP_DEPENDENT_SCHEDULER_EXISTS, schedules.size(), JSONUtils.toJsonString(processNames));
            return true;
        }
        List environmentWorkerGroupRelations = this.environmentWorkerGroupRelationMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(EnvironmentWorkerGroupRelation::getWorkerGroup, (Object)workerGroup.getName()));
        if (CollectionUtils.isNotEmpty((Collection)environmentWorkerGroupRelations)) {
            this.putMsg(result, Status.WORKER_GROUP_DEPENDENT_ENVIRONMENT_EXISTS, environmentWorkerGroupRelations.size());
            return true;
        }
        return false;
    }

    private String checkWorkerGroupAddrList(WorkerGroup workerGroup) {
        if (StringUtils.isEmpty((CharSequence)workerGroup.getAddrList())) {
            return null;
        }
        Map serverMaps = this.registryClient.getServerMaps(RegistryNodeType.WORKER);
        for (String addr : workerGroup.getAddrList().split(",")) {
            if (serverMaps.containsKey(addr)) continue;
            return addr;
        }
        return null;
    }

    @Override
    public Result queryAllGroupPaging(User loginUser, Integer pageNo, Integer pageSize, String searchVal) {
        Set ids;
        int fromIndex = (pageNo - 1) * pageSize;
        int toIndex = (pageNo - 1) * pageSize + pageSize;
        Result result = new Result();
        List<WorkerGroup> workerGroups = loginUser.getUserType().equals((Object)UserType.ADMIN_USER) ? this.getWorkerGroups(null) : this.getWorkerGroups((ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.WORKER_GROUP, loginUser.getId(), log)).isEmpty() ? Collections.emptyList() : new ArrayList(ids));
        List<Object> resultDataList = new ArrayList();
        int total = 0;
        if (CollectionUtils.isNotEmpty(workerGroups)) {
            List<Object> searchValDataList = new ArrayList();
            if (!StringUtils.isEmpty((CharSequence)searchVal)) {
                for (WorkerGroup workerGroup : workerGroups) {
                    if (!workerGroup.getName().contains(searchVal)) continue;
                    searchValDataList.add(workerGroup);
                }
            } else {
                searchValDataList = workerGroups;
            }
            total = searchValDataList.size();
            if (fromIndex < searchValDataList.size()) {
                if (toIndex > searchValDataList.size()) {
                    toIndex = searchValDataList.size();
                }
                resultDataList = searchValDataList.subList(fromIndex, toIndex);
            }
        }
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotal(total);
        pageInfo.setTotalList(resultDataList);
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryAllGroup(User loginUser) {
        Set ids;
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<WorkerGroup> workerGroups = loginUser.getUserType().equals((Object)UserType.ADMIN_USER) ? this.getWorkerGroups(null) : this.getWorkerGroups((ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.WORKER_GROUP, loginUser.getId(), log)).isEmpty() ? Collections.emptyList() : new ArrayList(ids));
        List availableWorkerGroupList = workerGroups.stream().map(WorkerGroup::getName).collect(Collectors.toList());
        result.put("data", availableWorkerGroupList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private List<WorkerGroup> getWorkerGroups(List<Integer> ids) {
        List<Object> workerGroups = ids != null ? (ids.isEmpty() ? new ArrayList() : this.workerGroupMapper.selectBatchIds(ids)) : this.workerGroupMapper.queryAllWorkerGroup();
        boolean containDefaultWorkerGroups = workerGroups.stream().anyMatch(workerGroup -> "default".equals(workerGroup.getName()));
        if (!containDefaultWorkerGroups) {
            Set activeWorkerNodes = this.registryClient.getServerNodeSet(RegistryNodeType.WORKER);
            WorkerGroup defaultWorkerGroup = new WorkerGroup();
            defaultWorkerGroup.setName("default");
            defaultWorkerGroup.setAddrList(String.join((CharSequence)",", activeWorkerNodes));
            defaultWorkerGroup.setCreateTime(new Date());
            defaultWorkerGroup.setUpdateTime(new Date());
            defaultWorkerGroup.setSystemDefault(true);
            workerGroups.add(defaultWorkerGroup);
        }
        return workerGroups;
    }

    @Override
    @Transactional
    public Map<String, Object> deleteWorkerGroupById(User loginUser, Integer id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.WORKER_GROUP, "security:worker-group:delete")) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        WorkerGroup workerGroup = (WorkerGroup)this.workerGroupMapper.selectById((Serializable)id);
        if (workerGroup == null) {
            log.error("Worker group does not exist, workerGroupId:{}.", (Object)id);
            this.putMsg(result, Status.DELETE_WORKER_GROUP_NOT_EXIST, new Object[0]);
            return result;
        }
        List processInstances = this.processInstanceMapper.queryByWorkerGroupNameAndStatus(workerGroup.getName(), Constants.NOT_TERMINATED_STATES);
        if (CollectionUtils.isNotEmpty((Collection)processInstances)) {
            List processInstanceIds = processInstances.stream().map(ProcessInstance::getId).collect(Collectors.toList());
            log.warn("Delete worker group failed because there are {} processInstances are using it, processInstanceIds:{}.", (Object)processInstances.size(), processInstanceIds);
            this.putMsg(result, Status.DELETE_WORKER_GROUP_BY_ID_FAIL, processInstances.size());
            return result;
        }
        if (this.checkWorkerGroupDependencies(workerGroup, result)) {
            return result;
        }
        this.workerGroupMapper.deleteById(id);
        log.info("Delete worker group complete, workerGroupName:{}.", (Object)workerGroup.getName());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> getWorkerAddressList() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set serverNodeList = this.registryClient.getServerNodeSet(RegistryNodeType.WORKER);
        result.put("data", serverNodeList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public String getTaskWorkerGroup(TaskInstance taskInstance) {
        if (taskInstance == null) {
            return null;
        }
        String workerGroup = taskInstance.getWorkerGroup();
        if (StringUtils.isNotEmpty((CharSequence)workerGroup)) {
            return workerGroup;
        }
        int processInstanceId = taskInstance.getProcessInstanceId();
        ProcessInstance processInstance = this.processService.findProcessInstanceById(processInstanceId);
        if (processInstance != null) {
            return processInstance.getWorkerGroup();
        }
        log.info("task : {} will use default worker group", (Object)taskInstance.getId());
        return "default";
    }

    @Override
    public Map<Long, String> queryWorkerGroupByProcessDefinitionCodes(List<Long> processDefinitionCodeList) {
        List processDefinitionScheduleList = this.scheduleMapper.querySchedulesByProcessDefinitionCodes(processDefinitionCodeList);
        return processDefinitionScheduleList.stream().collect(Collectors.toMap(Schedule::getProcessDefinitionCode, Schedule::getWorkerGroup));
    }
}

