/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.AccessTokenService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.AccessToken;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="ACCESS_TOKEN_TAG")
@RestController
@RequestMapping(value={"/access-tokens"})
public class AccessTokenController
extends BaseController {
    @Autowired
    private AccessTokenService accessTokenService;

    @Operation(summary="createToken", description="CREATE_TOKEN_NOTES")
    @Parameters(value={@Parameter(name="userId", description="USER_ID", schema=@Schema(implementation=int.class), required=true), @Parameter(name="expireTime", description="EXPIRE_TIME", schema=@Schema(implementation=String.class), required=true, example="2021-12-31 00:00:00"), @Parameter(name="token", description="TOKEN", required=false, schema=@Schema(implementation=String.class), example="xxxx")})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_ACCESS_TOKEN_ERROR)
    public Result<AccessToken> createToken(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="expireTime") String expireTime, @RequestParam(value="token", required=false) String token) {
        AccessToken accessToken = this.accessTokenService.createToken(loginUser, userId, expireTime, token);
        return Result.success(accessToken);
    }

    @Parameter(hidden=true)
    @PostMapping(value={"/generate"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.GENERATE_TOKEN_ERROR)
    public Result<String> generateToken(@RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="expireTime") String expireTime) {
        String token = this.accessTokenService.generateToken(loginUser, userId, expireTime);
        return Result.success(token);
    }

    @Operation(summary="queryAccessTokenList", description="QUERY_ACCESS_TOKEN_LIST_NOTES")
    @Parameters(value={@Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class)), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class), example="1"), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class), example="20")})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ACCESSTOKEN_LIST_PAGING_ERROR)
    public Result<PageInfo<AccessToken>> queryAccessTokenList(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize) {
        this.checkPageParams(pageNo, pageSize);
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        PageInfo<AccessToken> accessTokenPageInfo = this.accessTokenService.queryAccessTokenList(loginUser, searchVal, pageNo, pageSize);
        return Result.success(accessTokenPageInfo);
    }

    @Operation(summary="queryAccessTokenByUser", description="QUERY_ACCESS_TOKEN_BY_USER_NOTES")
    @Parameters(value={@Parameter(name="userId", description="USER_ID", schema=@Schema(implementation=int.class))})
    @GetMapping(value={"/user/{userId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ACCESSTOKEN_BY_USER_ERROR)
    public Result<List<AccessToken>> queryAccessTokenByUser(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="userId") Integer userId) {
        List<AccessToken> accessTokens = this.accessTokenService.queryAccessTokenByUser(loginUser, userId);
        return Result.success(accessTokens);
    }

    @Parameter(hidden=true)
    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_ACCESS_TOKEN_ERROR)
    public Result<Boolean> delAccessTokenById(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id) {
        this.accessTokenService.deleteAccessTokenById(loginUser, id);
        return Result.success(true);
    }

    @Operation(summary="updateToken", description="UPDATE_TOKEN_NOTES")
    @Parameters(value={@Parameter(name="id", description="TOKEN_ID", required=true, schema=@Schema(implementation=int.class)), @Parameter(name="userId", description="USER_ID", required=true, schema=@Schema(implementation=int.class)), @Parameter(name="expireTime", description="EXPIRE_TIME", required=true, schema=@Schema(implementation=String.class), example="2021-12-31 00:00:00"), @Parameter(name="token", description="TOKEN", required=false, schema=@Schema(implementation=String.class), example="xxxx")})
    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_ACCESS_TOKEN_ERROR)
    public Result<AccessToken> updateToken(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id, @RequestParam(value="userId") int userId, @RequestParam(value="expireTime") String expireTime, @RequestParam(value="token", required=false) String token) {
        AccessToken accessToken = this.accessTokenService.updateToken(loginUser, id, userId, expireTime, token);
        return Result.success(accessToken);
    }
}

