/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.EnvironmentService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.Environment;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="ENVIRONMENT_TAG")
@RestController
@RequestMapping(value={"environment"})
public class EnvironmentController
extends BaseController {
    @Autowired
    private EnvironmentService environmentService;

    @Operation(summary="createEnvironment", description="CREATE_ENVIRONMENT_NOTES")
    @Parameters(value={@Parameter(name="name", description="ENVIRONMENT_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="config", description="ENVIRONMENT_CONFIG", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="description", description="ENVIRONMENT_DESC", schema=@Schema(implementation=String.class)), @Parameter(name="workerGroups", description="WORKER_GROUP_LIST", schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/create"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_ENVIRONMENT_ERROR)
    public Result<Long> createEnvironment(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="name") String name, @RequestParam(value="config") String config, @RequestParam(value="description", required=false) String description, @RequestParam(value="workerGroups", required=false) String workerGroups) {
        Long environmentCode = this.environmentService.createEnvironment(loginUser, name, config, description, workerGroups);
        return Result.success(environmentCode);
    }

    @Operation(summary="updateEnvironment", description="UPDATE_ENVIRONMENT_NOTES")
    @Parameters(value={@Parameter(name="code", description="ENVIRONMENT_CODE", required=true, schema=@Schema(implementation=long.class, example="100")), @Parameter(name="name", description="ENVIRONMENT_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="config", description="ENVIRONMENT_CONFIG", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="description", description="ENVIRONMENT_DESC", schema=@Schema(implementation=String.class)), @Parameter(name="workerGroups", description="WORKER_GROUP_LIST", schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/update"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_ENVIRONMENT_ERROR)
    public Result<Environment> updateEnvironment(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="code") Long code, @RequestParam(value="name") String name, @RequestParam(value="config") String config, @RequestParam(value="description", required=false) String description, @RequestParam(value="workerGroups", required=false) String workerGroups) {
        Environment environment = this.environmentService.updateEnvironmentByCode(loginUser, code, name, config, description, workerGroups);
        return Result.success(environment);
    }

    @Operation(summary="queryEnvironmentByCode", description="QUERY_ENVIRONMENT_BY_CODE_NOTES")
    @Parameters(value={@Parameter(name="environmentCode", description="ENVIRONMENT_CODE", required=true, schema=@Schema(implementation=long.class, example="100"))})
    @GetMapping(value={"/query-by-code"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ENVIRONMENT_BY_CODE_ERROR)
    public Result queryEnvironmentByCode(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="environmentCode") Long environmentCode) {
        Map<String, Object> result = this.environmentService.queryEnvironmentByCode(environmentCode);
        return this.returnDataList(result);
    }

    @Operation(summary="queryEnvironmentListPaging", description="QUERY_ENVIRONMENT_LIST_PAGING_NOTES")
    @Parameters(value={@Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class)), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="20")), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1"))})
    @GetMapping(value={"/list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ENVIRONMENT_ERROR)
    public Result queryEnvironmentListPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="pageNo") Integer pageNo) {
        this.checkPageParams(pageNo, pageSize);
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        return this.environmentService.queryEnvironmentListPaging(loginUser, pageNo, pageSize, searchVal);
    }

    @Operation(summary="deleteEnvironmentByCode", description="DELETE_ENVIRONMENT_BY_CODE_NOTES")
    @Parameters(value={@Parameter(name="environmentCode", description="ENVIRONMENT_CODE", required=true, schema=@Schema(implementation=long.class, example="100"))})
    @PostMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_ENVIRONMENT_ERROR)
    public Result deleteEnvironment(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="environmentCode") Long environmentCode) {
        Map<String, Object> result = this.environmentService.deleteEnvironmentByCode(loginUser, environmentCode);
        return this.returnDataList(result);
    }

    @Operation(summary="queryAllEnvironmentList", description="QUERY_ALL_ENVIRONMENT_LIST_NOTES")
    @GetMapping(value={"/query-environment-list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ENVIRONMENT_ERROR)
    public Result queryAllEnvironmentList(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        Map<String, Object> result = this.environmentService.queryAllEnvironmentList(loginUser);
        return this.returnDataList(result);
    }

    @Operation(summary="verifyEnvironment", description="VERIFY_ENVIRONMENT_NOTES")
    @Parameters(value={@Parameter(name="environmentName", description="ENVIRONMENT_NAME", required=true, schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/verify-environment"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_ENVIRONMENT_ERROR)
    public Result verifyEnvironment(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="environmentName") String environmentName) {
        Map<String, Object> result = this.environmentService.verifyEnvironment(environmentName);
        return this.returnDataList(result);
    }
}

